/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.typeeditor;

import agg.editor.impl.EdType;
import agg.gui.editor.GraphPanel;
import agg.gui.typeeditor.TypeEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TypePalette
extends JPanel
implements MouseListener,
MouseMotionListener {
    final Vector<JLabel> nodeTypes;
    final Vector<JLabel> edgeTypes;
    final JList nodeTypeList;
    final JList edgeTypeList;
    private final JSplitPane splitPane;
    private final JPanel panel1;
    private final JPanel panel2;
    private final JPanel editNodeTypeP;
    private final JPanel editEdgeTypeP;
    final JButton modifyNodeTypeB;
    final JButton newNodeTypeB;
    final JButton deleteNodeTypeB;
    final JButton modifyEdgeTypeB;
    final JButton newEdgeTypeB;
    final JButton deleteEdgeTypeB;
    final TypeEditor typeEditor;
    private int dividerLocation = 0;
    private int width = 220;
    private boolean selectionDone;
    private int indxN = -1;
    private int indxE = -1;
    private Point p = new Point(0, 0);
    private Point lp = new Point(-1, -1);
    private boolean dragged;

    public TypePalette(TypeEditor typeeditor) {
        this.typeEditor = typeeditor;
        this.nodeTypes = new Vector();
        this.nodeTypeList = new JList();
        this.nodeTypeList.setToolTipText("Double click to get attribute editor.");
        this.edgeTypes = new Vector();
        this.edgeTypeList = new JList();
        this.edgeTypeList.setToolTipText("Double click to get attribute editor.");
        this.panel1 = new JPanel(new BorderLayout());
        this.newNodeTypeB = new JButton("New");
        this.modifyNodeTypeB = new JButton("Edit");
        this.deleteNodeTypeB = new JButton("Del");
        this.editNodeTypeP = this.handleNodeTypeButtons();
        this.panel2 = new JPanel(new BorderLayout());
        this.newEdgeTypeB = new JButton("New");
        this.modifyEdgeTypeB = new JButton("Edit");
        this.deleteEdgeTypeB = new JButton("Del");
        this.editEdgeTypeP = this.handleArcTypeButtons();
        this.splitPane = new JSplitPane(0, null, null);
        this.splitPane.setDividerSize(15);
        this.add((Component)this.splitPane, "Center");
        this.validate();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.nodeTypeList.setEnabled(b);
        this.edgeTypeList.setEnabled(b);
        if (!b) {
            this.newNodeTypeB.setEnabled(b);
            this.modifyNodeTypeB.setEnabled(b);
            this.deleteNodeTypeB.setEnabled(b);
            this.newEdgeTypeB.setEnabled(b);
            this.modifyEdgeTypeB.setEnabled(b);
            this.deleteEdgeTypeB.setEnabled(b);
        } else {
            this.newNodeTypeB.setEnabled(b);
            this.newEdgeTypeB.setEnabled(b);
            if (this.nodeTypeList.getModel().getSize() > 0) {
                this.modifyNodeTypeB.setEnabled(b);
                this.deleteNodeTypeB.setEnabled(b);
            } else {
                this.modifyNodeTypeB.setEnabled(false);
                this.deleteNodeTypeB.setEnabled(false);
            }
            if (this.edgeTypeList.getModel().getSize() > 0) {
                this.modifyEdgeTypeB.setEnabled(b);
                this.deleteEdgeTypeB.setEnabled(b);
            } else {
                this.modifyEdgeTypeB.setEnabled(false);
                this.deleteEdgeTypeB.setEnabled(false);
            }
        }
    }

    private JPanel handleNodeTypeButtons() {
        JPanel p = new JPanel();
        this.newNodeTypeB.setToolTipText(" Create Node Type ");
        this.newNodeTypeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypePalette.this.typeEditor.getNodeTypePropertyEditor().setNewTypeDefaultProperty();
                TypePalette.this.typeEditor.getNodeTypePropertyEditor().enableChangeButton(false);
                TypePalette.this.typeEditor.getNodeTypePropertyEditor().enableDeleteButton(false);
                Point point = ((JButton)e.getSource()).getLocationOnScreen();
                TypePalette.this.typeEditor.showNodeTypePropertyEditorl(point.x, point.y);
            }
        });
        this.modifyNodeTypeB.setToolTipText(" Modify Node Type ");
        this.modifyNodeTypeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypePalette.this.typeEditor.getNodeTypePropertyEditor().enableChangeButton(true);
                TypePalette.this.typeEditor.getNodeTypePropertyEditor().enableDeleteButton(true);
                EdType type = TypePalette.this.typeEditor.getSelectedNodeType();
                TypePalette.this.typeEditor.getNodeTypePropertyEditor().setSelectedTypeProperty(type);
                Point point = ((JButton)e.getSource()).getLocationOnScreen();
                TypePalette.this.typeEditor.showNodeTypePropertyEditorl(point.x, point.y);
            }
        });
        this.deleteNodeTypeB.setToolTipText(" Delete Node Type ");
        this.deleteNodeTypeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypePalette.this.typeEditor.deleteSelectedNodeType(true);
            }
        });
        p.add(this.newNodeTypeB);
        p.add(this.modifyNodeTypeB);
        p.add(this.deleteNodeTypeB);
        return p;
    }

    private JPanel handleArcTypeButtons() {
        JPanel p = new JPanel();
        this.newEdgeTypeB.setToolTipText("Create Edge Type");
        this.newEdgeTypeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypePalette.this.typeEditor.getArcTypePropertyEditor().setNewTypeDefaultProperty();
                TypePalette.this.typeEditor.getArcTypePropertyEditor().enableChangeButton(false);
                TypePalette.this.typeEditor.getArcTypePropertyEditor().enableDeleteButton(false);
                Point point = ((JButton)e.getSource()).getLocationOnScreen();
                TypePalette.this.typeEditor.showArcTypePropertyEditorl(point.x, point.y);
            }
        });
        this.modifyEdgeTypeB.setToolTipText("Modify Edge Type");
        this.modifyEdgeTypeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypePalette.this.typeEditor.getArcTypePropertyEditor().enableChangeButton(true);
                TypePalette.this.typeEditor.getArcTypePropertyEditor().enableDeleteButton(true);
                EdType type = TypePalette.this.typeEditor.getSelectedArcType();
                TypePalette.this.typeEditor.getArcTypePropertyEditor().setSelectedTypeProperty(type);
                Point point = ((JButton)e.getSource()).getLocationOnScreen();
                TypePalette.this.typeEditor.showArcTypePropertyEditorl(point.x, point.y);
            }
        });
        this.deleteEdgeTypeB.setToolTipText("Delete Edge Type");
        this.deleteEdgeTypeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypePalette.this.typeEditor.deleteSelectedArcType(true);
            }
        });
        p.add(this.newEdgeTypeB);
        p.add(this.modifyEdgeTypeB);
        p.add(this.deleteEdgeTypeB);
        return p;
    }

    public void setTypes(Vector<JLabel> nodetypes, Vector<JLabel> edgetypes) {
        this.panel1.removeAll();
        this.panel2.removeAll();
        this.indxN = nodetypes.size() > 0 ? 0 : -1;
        this.indxE = edgetypes.size() > 0 ? 0 : -1;
        this.setNodeTypes(nodetypes);
        this.setArcTypes(edgetypes);
        this.createTypeList(this.nodeTypeList, nodetypes);
        try {
            JScrollPane scrollPane1 = new JScrollPane(this.nodeTypeList);
            scrollPane1.setBorder(new TitledBorder("  Node Types  "));
            this.nodeTypeList.setSelectedIndex(this.nodeTypeList.getModel().getSize() - 1);
            if (this.panel1.getComponentCount() == 0) {
                this.panel1.add((Component)scrollPane1, "Center");
                this.panel1.add((Component)this.editNodeTypeP, "South");
                this.splitPane.setTopComponent(this.panel1);
            }
        }
        catch (IllegalArgumentException scrollPane1) {
            // empty catch block
        }
        this.createTypeList(this.edgeTypeList, edgetypes);
        try {
            JScrollPane scrollPane2 = new JScrollPane(this.edgeTypeList);
            scrollPane2.setBorder(new TitledBorder("  Edge Types  "));
            this.edgeTypeList.setSelectedIndex(this.edgeTypeList.getModel().getSize() - 1);
            if (this.panel2.getComponentCount() == 0) {
                this.panel2.add((Component)scrollPane2, "Center");
                this.panel2.add((Component)this.editEdgeTypeP, "South");
                this.splitPane.setBottomComponent(this.panel2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.splitPane.revalidate();
        if (this.dividerLocation == 0) {
            this.splitPane.setDividerLocation(this.getHeight() / 2);
        }
    }

    public boolean isEmpty() {
        return this.nodeTypes.isEmpty() && this.edgeTypes.isEmpty();
    }

    public boolean isNodeTypesEmpty() {
        return this.nodeTypes.isEmpty();
    }

    public boolean isArcTypesEmpty() {
        return this.edgeTypes.isEmpty();
    }

    public void enableNodeTypeModifyButton(boolean b) {
        this.modifyNodeTypeB.setEnabled(b);
    }

    public void enableNodeTypeDeleteButton(boolean b) {
        this.deleteNodeTypeB.setEnabled(b);
    }

    public void enableArcTypeModifyButton(boolean b) {
        this.modifyEdgeTypeB.setEnabled(b);
    }

    public void enableArcTypeDeleteButton(boolean b) {
        this.deleteEdgeTypeB.setEnabled(b);
    }

    public boolean isOpen() {
        return this.splitPane.getWidth() > 0;
    }

    public void clear() {
        this.nodeTypes.clear();
        this.edgeTypes.clear();
        this.nodeTypeList.removeAll();
        this.edgeTypeList.removeAll();
        this.splitPane.setTopComponent(null);
        this.splitPane.setBottomComponent(null);
    }

    public void setDividerLocation(int d) {
        this.splitPane.setDividerLocation(d);
        this.dividerLocation = this.splitPane.getDividerLocation();
    }

    public int getDividerLocation() {
        if (this.dividerLocation != 0 && this.dividerLocation != this.splitPane.getDividerLocation()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
        }
        return this.dividerLocation;
    }

    public Component getTypePaletteComponent() {
        return this.splitPane;
    }

    public int getWidthOfPalette() {
        return this.width;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 500);
    }

    public JButton getEditNodeTypeButton() {
        return this.modifyNodeTypeB;
    }

    public JButton getNewNodeTypeButton() {
        return this.newNodeTypeB;
    }

    public JButton getDeleteNodeTypeButton() {
        return this.deleteNodeTypeB;
    }

    public JButton getEditArcTypeButton() {
        return this.modifyEdgeTypeB;
    }

    public JButton getNewArcTypeButton() {
        return this.newEdgeTypeB;
    }

    public JButton getDeleteArcTypeButton() {
        return this.deleteEdgeTypeB;
    }

    public JList getNodeTypeList() {
        return this.nodeTypeList;
    }

    public JList getArcTypeList() {
        return this.edgeTypeList;
    }

    public void setSelectedNodeTypeIndex(int index) {
        if (index >= 0) {
            this.nodeTypeList.setSelectedIndex(index);
        } else {
            this.modifyNodeTypeB.setEnabled(false);
            this.deleteNodeTypeB.setEnabled(false);
            this.typeEditor.getNodeTypePropertyEditor().enableChangeButton(false);
            this.typeEditor.getNodeTypePropertyEditor().enableDeleteButton(false);
        }
    }

    public int getSelectedNodeTypeIndex() {
        return this.nodeTypeList.getSelectedIndex();
    }

    public JLabel getSelectedNodeTypeLabel() {
        int i = this.nodeTypeList.getSelectedIndex();
        if (i < 0) {
            return new JLabel("");
        }
        return this.nodeTypes.get(i);
    }

    public void setSelectedArcTypeIndex(int index) {
        if (index >= 0) {
            this.edgeTypeList.setSelectedIndex(index);
        } else {
            this.modifyEdgeTypeB.setEnabled(false);
            this.deleteEdgeTypeB.setEnabled(false);
            this.typeEditor.getArcTypePropertyEditor().enableChangeButton(false);
            this.typeEditor.getArcTypePropertyEditor().enableDeleteButton(false);
        }
    }

    public int getSelectedArcTypeIndex() {
        return this.edgeTypeList.getSelectedIndex();
    }

    public JLabel getSelectedArcTypeLabel() {
        int i = this.edgeTypeList.getSelectedIndex();
        if (i < 0) {
            return new JLabel("");
        }
        return this.edgeTypes.get(i);
    }

    public int addNodeType(JLabel l) {
        this.nodeTypes.add(l);
        int index = this.nodeTypes.size() - 1;
        ((DefaultListModel)this.nodeTypeList.getModel()).addElement(l.getText());
        return index;
    }

    public void addNodeType(JLabel l, int index) {
        if (index < this.nodeTypes.size()) {
            this.nodeTypes.add(index, l);
            ((DefaultListModel)this.nodeTypeList.getModel()).add(index, l.getText());
        } else {
            this.nodeTypes.add(l);
            ((DefaultListModel)this.nodeTypeList.getModel()).addElement(l.getText());
        }
    }

    public int addArcType(JLabel l) {
        this.edgeTypes.add(l);
        int index = this.edgeTypes.size() - 1;
        ((DefaultListModel)this.edgeTypeList.getModel()).addElement(l.getText());
        return index;
    }

    public void addArcType(JLabel l, int index) {
        if (index < this.edgeTypes.size()) {
            this.edgeTypes.add(index, l);
            ((DefaultListModel)this.edgeTypeList.getModel()).add(index, l.getText());
        } else {
            this.edgeTypes.add(l);
            ((DefaultListModel)this.edgeTypeList.getModel()).addElement(l.getText());
        }
    }

    public void changeNodeType(JLabel l, int index) {
        if (index < this.nodeTypeList.getModel().getSize()) {
            this.nodeTypes.set(index, l);
            ((DefaultListModel)this.nodeTypeList.getModel()).setElementAt(l.getText(), index);
        }
    }

    public void deleteSelectedNodeType() {
        int index = this.getSelectedNodeTypeIndex();
        this.nodeTypes.remove(index);
        ((DefaultListModel)this.nodeTypeList.getModel()).remove(index);
    }

    public void deleteNodeTypeAt(int index) {
        if (index < this.nodeTypeList.getModel().getSize()) {
            this.nodeTypes.remove(index);
            ((DefaultListModel)this.nodeTypeList.getModel()).remove(index);
        }
    }

    public void refreshNodeType(JLabel l, int index) {
        if (index < this.nodeTypeList.getModel().getSize()) {
            this.nodeTypes.set(index, l);
            ((DefaultListModel)this.nodeTypeList.getModel()).setElementAt(l.getText(), index);
        }
    }

    public void changeArcType(JLabel l, int index) {
        if (index < this.edgeTypeList.getModel().getSize()) {
            this.edgeTypes.set(index, l);
            ((DefaultListModel)this.edgeTypeList.getModel()).setElementAt(l.getText(), index);
        }
    }

    public void deleteSelectedEdgeType() {
        int index = this.getSelectedArcTypeIndex();
        ((DefaultListModel)this.edgeTypeList.getModel()).remove(index);
        this.edgeTypes.remove(index);
    }

    public void deleteArcTypeAt(int index) {
        if (index < this.edgeTypeList.getModel().getSize()) {
            ((DefaultListModel)this.edgeTypeList.getModel()).remove(index);
            this.edgeTypes.remove(index);
        }
    }

    public void refreshArcType(JLabel l, int index) {
        if (index < this.edgeTypeList.getModel().getSize()) {
            this.edgeTypes.set(index, l);
            ((DefaultListModel)this.edgeTypeList.getModel()).setElementAt(l.getText(), index);
        }
    }

    private void setNodeTypes(Vector<JLabel> types) {
        this.nodeTypes.clear();
        int i = 0;
        while (i < types.size()) {
            JLabel l = types.get(i);
            this.nodeTypes.add(l);
            ++i;
        }
    }

    private void setArcTypes(Vector<JLabel> types) {
        this.edgeTypes.clear();
        int i = 0;
        while (i < types.size()) {
            JLabel l = types.get(i);
            this.edgeTypes.add(l);
            ++i;
        }
    }

    private JList createTypeList(JList list, Vector<JLabel> types) {
        Vector<String> v = new Vector<String>(types.size());
        int i = 0;
        while (i < types.size()) {
            v.add(types.get(i).getText());
            ++i;
        }
        list.setModel(new DefaultListModel());
        list.getSelectionModel().setSelectionMode(0);
        i = 0;
        while (i < v.size()) {
            String text = (String)v.get(i);
            ((DefaultListModel)list.getModel()).addElement(text);
            ++i;
        }
        list.setPrototypeCellValue("Index 1234567890");
        MyCellRenderer cellRenderer = new MyCellRenderer();
        list.setCellRenderer(cellRenderer);
        list.addMouseListener(this);
        list.addMouseMotionListener(this);
        return list;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            this.transferFocusBackward();
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e) && !this.selectionDone) {
            this.selectType(e);
        }
        if (e.getClickCount() == 2 || this.typeEditor.getGraGraEditor().hasAttrEditorOnTop()) {
            if ((JList)e.getSource() == this.nodeTypeList) {
                if (!this.nodeTypes.isEmpty()) {
                    this.typeEditor.getGraGraEditor().setAttrEditorOnTopForType(this.typeEditor.getSelectedNodeType().getBasisType());
                }
            } else if ((JList)e.getSource() == this.edgeTypeList && !this.edgeTypes.isEmpty()) {
                this.typeEditor.getGraGraEditor().setAttrEditorOnTopForType(this.typeEditor.getSelectedArcType().getBasisType());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getPoint().x > 0 && e.getPoint().y > 0) {
                this.selectType(e);
            } else {
                Point pt;
                GraphPanel panel;
                this.nodeTypeList.setSelectedIndex(this.indxN);
                this.edgeTypeList.setSelectedIndex(this.indxE);
                if (this.dragged && e.getSource() == this.nodeTypeList && (panel = this.typeEditor.getGraGraEditor().getPanelOfLocationOnScreen(e.getLocationOnScreen())) != null && (pt = this.getLocationOnCanvas(panel, e.getLocationOnScreen())) != null) {
                    this.typeEditor.getGraGraEditor().updateGraphics();
                    panel.getCanvas().addNode(pt.x, pt.y);
                }
            }
        }
        this.dragged = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragged = false;
        this.p = e.getPoint();
        if (SwingUtilities.isLeftMouseButton(e) && this.p.x > 0 && this.p.y > 0) {
            this.selectionDone = false;
            this.selectType(e);
        }
    }

    private void selectType(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.p.x > 0 && this.p.y > 0) {
            if ((JList)e.getSource() == this.nodeTypeList) {
                if (this.nodeTypeList.getModel().getSize() > 0) {
                    int index = this.nodeTypeList.locationToIndex(e.getPoint());
                    if (index == -1 || index >= this.nodeTypes.size()) {
                        return;
                    }
                    this.indxN = index;
                    EdType type = this.typeEditor.selectNodeTypeAtIndex(index);
                    this.typeEditor.getNodeTypePropertyEditor().setSelectedTypeProperty(type);
                    this.modifyNodeTypeB.setEnabled(true);
                    this.deleteNodeTypeB.setEnabled(true);
                    this.typeEditor.getNodeTypePropertyEditor().enableChangeButton(true);
                    this.typeEditor.getNodeTypePropertyEditor().enableDeleteButton(true);
                    this.typeEditor.getGraGraEditor().setEditMode(11);
                    this.typeEditor.getGraGraEditor().forwardModeCommand("Draw");
                    this.selectionDone = true;
                }
            } else if ((JList)e.getSource() == this.edgeTypeList && this.edgeTypeList.getModel().getSize() > 0) {
                int index = this.edgeTypeList.locationToIndex(e.getPoint());
                if (index == -1 || index >= this.edgeTypes.size()) {
                    return;
                }
                this.indxE = index;
                EdType type = this.typeEditor.selectArcTypeAtIndex(index);
                this.typeEditor.getArcTypePropertyEditor().setSelectedTypeProperty(type);
                this.modifyEdgeTypeB.setEnabled(true);
                this.deleteEdgeTypeB.setEnabled(true);
                this.typeEditor.getArcTypePropertyEditor().enableChangeButton(true);
                this.typeEditor.getArcTypePropertyEditor().enableDeleteButton(true);
                this.typeEditor.getGraGraEditor().setEditMode(11);
                this.typeEditor.getGraGraEditor().forwardModeCommand("Draw");
                this.selectionDone = true;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.p = e.getPoint();
        if (SwingUtilities.isLeftMouseButton(e) && (this.p.x < 0 || this.p.y < 0)) {
            this.nodeTypeList.setSelectedIndex(this.indxN);
            this.edgeTypeList.setSelectedIndex(this.indxE);
            if (e.getSource() == this.nodeTypeList) {
                int px = e.getLocationOnScreen().x - this.typeEditor.getGraGraEditor().getLocationOnScreen().x;
                int py = e.getLocationOnScreen().y - this.typeEditor.getGraGraEditor().getLocationOnScreen().y;
                if (this.lp.x > 0 && this.lp.y > 0) {
                    this.typeEditor.getGraGraEditor().setForeground(Color.WHITE);
                    this.typeEditor.getGraGraEditor().getGraphics().drawRect(this.lp.x, this.lp.y, 14, 10);
                    this.typeEditor.getGraGraEditor().setForeground(Color.BLACK);
                }
                this.typeEditor.getGraGraEditor().getGraphics().drawRect(px, py, 14, 10);
                this.lp.x = px;
                this.lp.y = py;
                this.dragged = true;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private Point getLocationOnCanvas(GraphPanel panel, Point pointOnScreen) {
        Point pt = new Point(20, 20);
        pt.x = pointOnScreen.x - panel.getLocationOnScreen().x + panel.getHorizontalScrollBar().getValue();
        pt.y = pointOnScreen.y - panel.getLocationOnScreen().y + panel.getVerticalScrollBar().getValue();
        return pt;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str = value.toString();
            this.setText(str);
            if (list == TypePalette.this.nodeTypeList && !TypePalette.this.nodeTypes.isEmpty()) {
                Icon icon = TypePalette.this.nodeTypes.get(index).getIcon();
                this.setIcon(icon);
                this.setForeground(TypePalette.this.nodeTypes.get(index).getForeground());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setBackground(list.getBackground());
                }
            } else if (list == TypePalette.this.edgeTypeList && !TypePalette.this.edgeTypes.isEmpty()) {
                Icon icon = TypePalette.this.edgeTypes.get(index).getIcon();
                this.setIcon(icon);
                this.setForeground(TypePalette.this.edgeTypes.get(index).getForeground());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setBackground(list.getBackground());
                }
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

