/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdConstraint;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class ConstraintTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdConstraint eConstraint;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public ConstraintTreeNodeData(EdConstraint c) {
        this.setConstraint(c);
    }

    private void setConstraint(EdConstraint c) {
        this.data = c;
        this.string = !c.getBasisConstraint().isEnabled() ? "[D]" + c.getBasisConstraint().getName() : c.getName();
        this.eConstraint = c;
    }

    public ConstraintTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public ConstraintTreeNodeData(Object obj) {
        if (obj instanceof EdConstraint) {
            this.setConstraint((EdConstraint)obj);
        } else if (obj instanceof String) {
            new ConstraintTreeNodeData((String)obj);
        }
    }

    @Override
    public void dispose() {
        this.data = null;
        this.eConstraint = null;
        this.string = null;
        this.treeNode = null;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdConstraint) {
            this.setConstraint((EdConstraint)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
        } else {
            this.data = null;
            this.eConstraint = null;
            this.string = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        String s = newString;
        String sD = "";
        if (!this.eConstraint.getBasisConstraint().isEnabled()) {
            sD = "[D]";
        }
        if (newString.indexOf("[D]") != -1) {
            newString = newString.substring(3, newString.length());
        }
        if (newString.indexOf("[") == 0 && newString.indexOf("]") != -1) {
            s = newString.substring(newString.indexOf("]") + 1, newString.length());
        }
        String sL = "";
        Vector<Integer> layer = this.eConstraint.getBasisConstraint().getLayer();
        if (this.eConstraint.getGraGra().getBasisGraGra().isLayered() && !layer.isEmpty()) {
            sL = "[";
            int k = 0;
            while (k < layer.size()) {
                int l = layer.get(k);
                sL = String.valueOf(sL) + String.valueOf(l);
                if (k < layer.size() - 1) {
                    sL = String.valueOf(sL) + ",";
                }
                ++k;
            }
            sL = String.valueOf(sL) + "]";
        }
        if (!this.eConstraint.getName().equals(s)) {
            this.eConstraint.setName(s);
            this.eConstraint.getGraGra().setChanged(true);
        }
        this.string = String.valueOf(sD) + sL + s;
    }

    @Override
    public void setString(String tag, String newString) {
        if (tag.equals("[]")) {
            tag = "";
        }
        this.string = String.valueOf(tag) + newString;
        if (!this.eConstraint.getBasisConstraint().getName().equals(newString)) {
            this.eConstraint.getBasisConstraint().setName(newString);
            this.eConstraint.getGraGra().setChanged(true);
        }
    }

    @Override
    public void setString(String tag, String tag1, String newString) {
        if (tag.equals("[]")) {
            tag = "";
        }
        if (tag1.equals("[]")) {
            tag1 = "";
        }
        this.string = String.valueOf(tag) + tag1 + newString;
        if (!this.eConstraint.getBasisConstraint().getName().equals(newString)) {
            this.eConstraint.getGraGra().setChanged(true);
        }
        this.eConstraint.getBasisConstraint().setName(newString);
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string();
    }

    @Override
    public EdConstraint getConstraint() {
        return this.eConstraint;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isConstraint() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = "Graph constraint : " + this.eConstraint.getAsString() + " ";
        if (!this.eConstraint.getBasisConstraint().getTextualComment().equals("")) {
            toolTipText = " " + this.eConstraint.getBasisConstraint().getTextualComment();
        }
        return toolTipText;
    }
}

