/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.attribute.impl.ContextView;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdRule;
import agg.gui.editor.GraphMorphismEditor;
import agg.ruleappl.ObjectFlow;
import agg.ruleappl.RuleSequence;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObjectFlowDesktop
extends JDialog
implements InternalFrameListener,
ListSelectionListener {
    protected final JFrame parentFrame;
    protected JDesktopPane desktop;
    protected JPanel panel;
    protected ImageIcon internalFrameIcon;
    protected int nextX;
    protected int nextY;
    protected int myW;
    protected int myH;
    protected JButton connect;
    protected JButton disconnect;
    protected JButton refresh;
    protected JButton close;
    protected Hashtable<GraphMorphismEditor, JInternalFrame> internalFrames;
    protected Hashtable<ObjectFlow, GraphMorphismEditor> editors;
    protected Dimension internalFrameSize;
    protected EdGraGra gragra;
    protected final RuleSequence ruleSequence;
    protected ObjectFlow currentObjFlow;
    protected JInternalFrame currentFrame;
    protected final List<String> ruleNames = new Vector<String>();
    protected JTable ruleList1;
    protected JTable ruleList2;
    protected boolean list2Clicked;
    protected JScrollPane scrollRuleList1;
    protected JScrollPane scrollRuleList2;
    protected Object rule1;
    protected Object rule2;
    protected int indx_rule1 = -1;
    protected int indx_rule2 = -1;
    protected final String title = "Object Flow of Rule Sequence ";

    public ObjectFlowDesktop(JFrame parent, EdGraGra gragra, RuleSequence ruleSeq, Point location) {
        this.setModal(false);
        this.setTitle("Object Flow of Rule Sequence ");
        this.extendTitle(ruleSeq.getName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ObjectFlowDesktop.this.setVisible(false);
            }
        });
        this.parentFrame = parent;
        this.gragra = gragra;
        this.ruleSequence = ruleSeq;
        TitledBorder border = new TitledBorder("");
        JPanel ruleP = this.makeRuleListPanel(border);
        if (this.gragra != null) {
            this.updateRuleList(this.ruleSequence.getRuleNames());
        }
        JPanel desktopP = this.makeDesktop(border);
        JPanel closeP = new JPanel(new GridLayout(0, 3));
        this.close = new JButton("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectFlowDesktop.this.closeDialog();
            }
        });
        closeP.add(new JLabel("     "));
        closeP.add(this.close);
        closeP.add(new JLabel("     "));
        JSplitPane p = new JSplitPane(0, ruleP, desktopP);
        p.setDividerSize(10);
        p.setContinuousLayout(true);
        p.setOneTouchExpandable(true);
        JScrollPane scroll = new JScrollPane(p);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(scroll);
        this.getContentPane().add((Component)closeP, "South");
        this.validate();
        this.setLocation(location);
        this.pack();
    }

    public void seVisible(boolean b) {
        super.setVisible(b);
    }

    public RuleSequence getRuleSequence() {
        return this.ruleSequence;
    }

    public EdGraGra getGraGra() {
        return this.gragra;
    }

    protected void extendTitle(String name) {
        String str = " ".concat(name).concat(" - ");
        super.setTitle(str.concat("Object Flow of Rule Sequence "));
    }

    private boolean needRefresh() {
        boolean need = false;
        if (this.ruleSequence.doesCheckAtGraph() && this.ruleSequence.getGraph() != null) {
            if (this.ruleList1.getRowCount() != this.ruleSequence.getRules().size() + 1 || !this.compareGraphName() || !this.compareRuleName(1)) {
                need = true;
            }
        } else if (this.ruleList1.getRowCount() != this.ruleSequence.getRules().size() || !this.compareRuleName(0)) {
            need = true;
        }
        return need;
    }

    public void refresh() {
        if (this.needRefresh()) {
            if (this.ruleNames.size() == this.ruleSequence.getRuleNames().size()) {
                if (!this.ruleNames.equals(this.ruleSequence.getRuleNames())) {
                    this.ruleSequence.removeObjFlow();
                }
            } else {
                List<String> tmp = this.ruleNames.subList(1, this.ruleNames.size());
                if (!tmp.equals(this.ruleSequence.getRuleNames())) {
                    this.ruleSequence.removeObjFlow();
                } else {
                    String firstName = (String)this.ruleList1.getValueAt(0, 0);
                    if (this.ruleSequence.getGraph() != null && !this.ruleSequence.getGraph().getName().equals(firstName)) {
                        this.ruleSequence.removeObjFlowOfGraph();
                    }
                }
            }
            this.removeAllFrames();
            this.updateRuleList(this.ruleSequence.getRuleNames());
        }
    }

    private boolean compareRuleName(int startIndx) {
        if (this.ruleList1.getRowCount() - startIndx != this.ruleSequence.getRuleNames().size()) {
            return false;
        }
        int i = startIndx;
        while (i < this.ruleList1.getRowCount()) {
            if (!this.ruleList1.getValueAt(i, 0).equals(this.ruleSequence.getRuleNames().get(i - startIndx))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareGraphName() {
        return this.ruleList1.getValueAt(0, 0).equals(this.ruleSequence.getGraph().getName());
    }

    public int getListSize() {
        return this.ruleList1.getRowCount();
    }

    private JPanel makeRuleListPanel(Border border) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(border);
        this.ruleList1 = new JTable(0, 1);
        this.scrollRuleList1 = new JScrollPane(this.ruleList1);
        JPanel p1 = this.makeRuleList("OUTPUT ( Graph | Rule RHS )", this.ruleList1, this.scrollRuleList1);
        this.ruleList2 = new JTable(0, 1);
        this.scrollRuleList2 = new JScrollPane(this.ruleList2);
        JPanel p2 = this.makeRuleList("INPUT ( Rule LHS )", this.ruleList2, this.scrollRuleList2);
        JPanel p3 = new JPanel(new GridLayout(0, 1));
        JLabel text = new JLabel("  OUTPUT   >>   INPUT  ");
        this.connect = new JButton("Connect >>");
        this.connect.setEnabled(false);
        this.connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ObjectFlowDesktop.this.rule1 != null && ObjectFlowDesktop.this.rule2 != null) {
                    String str = "An output object can be connected (by clicking) to an input object";
                    String key = String.valueOf(ObjectFlowDesktop.this.indx_rule1).concat(":").concat(String.valueOf(ObjectFlowDesktop.this.indx_rule2));
                    ObjectFlow objFlow = ObjectFlowDesktop.this.ruleSequence.getObjectFlow().get(key);
                    if (objFlow == null && ObjectFlowDesktop.this.rule2 instanceof EdRule) {
                        if (ObjectFlowDesktop.this.rule1 instanceof EdGraph) {
                            objFlow = new ObjectFlow(((EdGraph)ObjectFlowDesktop.this.rule1).getBasisGraph(), ((EdRule)ObjectFlowDesktop.this.rule2).getBasisRule(), ObjectFlowDesktop.this.indx_rule1, ObjectFlowDesktop.this.indx_rule2);
                            ObjectFlowDesktop.this.ruleSequence.addObjFlow(objFlow);
                        } else if (ObjectFlowDesktop.this.rule1 instanceof EdRule) {
                            objFlow = new ObjectFlow(((EdRule)ObjectFlowDesktop.this.rule1).getBasisRule(), ((EdRule)ObjectFlowDesktop.this.rule2).getBasisRule(), ObjectFlowDesktop.this.indx_rule1, ObjectFlowDesktop.this.indx_rule2);
                            ObjectFlowDesktop.this.ruleSequence.addObjFlow(objFlow);
                        }
                    }
                    if (ObjectFlowDesktop.this.editors.get(objFlow) == null || ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)) == null) {
                        ObjectFlowDesktop.this.addGraphMorphismEditor(objFlow, str);
                        ObjectFlowDesktop.this.connect.setEnabled(false);
                        ObjectFlowDesktop.this.disconnect.setEnabled(true);
                    } else {
                        try {
                            ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setIcon(false);
                            ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setSelected(true);
                            ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setVisible(true);
                            ObjectFlowDesktop.this.connect.setEnabled(false);
                            ObjectFlowDesktop.this.disconnect.setEnabled(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.disconnect = new JButton("Disconnect >>");
        this.disconnect.setEnabled(false);
        this.disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ObjectFlowDesktop.this.rule1 != null && ObjectFlowDesktop.this.rule2 != null) {
                    String str = "An output object will be disconnected from an input object";
                    if (ObjectFlowDesktop.this.rule1 instanceof EdGraph && ObjectFlowDesktop.this.rule2 instanceof EdRule) {
                        String key = String.valueOf(ObjectFlowDesktop.this.indx_rule1).concat(":").concat(String.valueOf(ObjectFlowDesktop.this.indx_rule2));
                        ObjectFlow objFlow = ObjectFlowDesktop.this.ruleSequence.getObjectFlow().get(key);
                        if (objFlow != null) {
                            if (ObjectFlowDesktop.this.editors.get(objFlow) == null || ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)) == null) {
                                ObjectFlowDesktop.this.addGraphMorphismEditor(objFlow, str);
                            }
                            ObjectFlowDesktop.this.editors.get(objFlow).removeAllMappings();
                            ObjectFlowDesktop.this.editors.get(objFlow).updateGraphs();
                            ObjectFlowDesktop.this.editors.get(objFlow).updateGraphics();
                            try {
                                if (!ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).isVisible()) {
                                    ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setIcon(false);
                                    ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setSelected(true);
                                    ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setVisible(true);
                                }
                                if (ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).isVisible()) {
                                    ObjectFlowDesktop.this.removeFrame(ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)));
                                    ObjectFlowDesktop.this.internalFrames.remove(ObjectFlowDesktop.this.editors.get(objFlow));
                                    ObjectFlowDesktop.this.editors.remove(objFlow);
                                    if (ObjectFlowDesktop.this.internalFrames.isEmpty()) {
                                        ObjectFlowDesktop.this.connect.setEnabled(true);
                                        ObjectFlowDesktop.this.disconnect.setEnabled(false);
                                    }
                                }
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                            ObjectFlowDesktop.this.ruleSequence.getObjectFlow().remove(key);
                            ObjectFlowDesktop.this.currentObjFlow = null;
                            ObjectFlowDesktop.this.setCurrentObjectFlow();
                        }
                    } else if (ObjectFlowDesktop.this.rule1 instanceof EdRule && ObjectFlowDesktop.this.rule2 instanceof EdRule) {
                        String key = String.valueOf(ObjectFlowDesktop.this.indx_rule1).concat(":").concat(String.valueOf(ObjectFlowDesktop.this.indx_rule2));
                        ObjectFlow objFlow = ObjectFlowDesktop.this.ruleSequence.getObjectFlow().get(key);
                        if (objFlow != null) {
                            if (ObjectFlowDesktop.this.editors.get(objFlow) == null || ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)) == null) {
                                ObjectFlowDesktop.this.addGraphMorphismEditor(objFlow, str);
                            }
                            ObjectFlowDesktop.this.editors.get(objFlow).removeAllMappings();
                            ObjectFlowDesktop.this.editors.get(objFlow).updateGraphs();
                            ObjectFlowDesktop.this.editors.get(objFlow).updateGraphics();
                            try {
                                if (ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).isVisible()) {
                                    ObjectFlowDesktop.this.removeFrame(ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)));
                                    ObjectFlowDesktop.this.internalFrames.remove(ObjectFlowDesktop.this.editors.get(objFlow));
                                    ObjectFlowDesktop.this.editors.remove(objFlow);
                                    if (ObjectFlowDesktop.this.internalFrames.isEmpty()) {
                                        ObjectFlowDesktop.this.disconnect.setEnabled(false);
                                    }
                                } else {
                                    ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setIcon(false);
                                    ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setSelected(true);
                                    ObjectFlowDesktop.this.internalFrames.get(ObjectFlowDesktop.this.editors.get(objFlow)).setVisible(true);
                                }
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                            ObjectFlowDesktop.this.ruleSequence.getObjectFlow().remove(key);
                            ObjectFlowDesktop.this.currentObjFlow = null;
                            ObjectFlowDesktop.this.setCurrentObjectFlow();
                        }
                    }
                }
            }
        });
        this.refresh = new JButton("Refresh");
        this.refresh.setEnabled(true);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ObjectFlowDesktop.this.ruleSequence.doesCheckAtGraph() && ObjectFlowDesktop.this.gragra.getBasisGraGra().getGraph() != ObjectFlowDesktop.this.ruleSequence.getGraph()) {
                    int answer = 0;
                    Object[] options = new Object[]{"OK", "Cancel"};
                    if (ObjectFlowDesktop.this.ruleSequence.isObjFlowActive() || ObjectFlowDesktop.this.ruleSequence.isChecked()) {
                        answer = JOptionPane.showOptionDialog(null, "<html><body>Currently selected sequence contains an object flow \nor is already checked at the graph  \"" + ObjectFlowDesktop.this.gragra.getBasisGraGra().getCurrentRuleSequence().getGraph().getName() + "\" \n" + "The object flow resp. results are not more valid after graph reset.", "Reset Graph", -1, 3, null, options, options[0]);
                    }
                    if (answer == 0) {
                        ObjectFlowDesktop.this.ruleSequence.setGraph(ObjectFlowDesktop.this.gragra.getBasisGraGra().getGraph());
                        ObjectFlowDesktop.this.ruleSequence.setCheckAtGraph(true);
                    }
                    ObjectFlowDesktop.this.refresh();
                }
            }
        });
        p3.add(new JLabel("     "));
        p3.add(text);
        p3.add(this.connect);
        p3.add(new JLabel("     "));
        p3.add(this.disconnect);
        p3.add(new JLabel("     "));
        p3.add(this.refresh);
        this.constrainBuild(p, p1, 0, -1, 1, 1, 1, 10, 1.0, 1.0, 10, 5, 5, 5);
        this.constrainBuild(p, p3, 1, -1, 1, 0, 0, 11, 0.0, 0.0, 10, 5, 5, 5);
        this.constrainBuild(p, p2, 2, -1, 1, 1, 1, 10, 1.0, 1.0, 10, 5, 5, 5);
        return p;
    }

    void closeDialog() {
        this.setVisible(false);
    }

    protected void addGraphMorphismEditor(ObjectFlow objFlow, String text) {
        EdGraph right = ((EdRule)this.rule2).getLeft();
        EdGraph left = null;
        String titleStr = "";
        if (objFlow.isGraphExtended()) {
            left = (EdGraph)this.rule1;
            titleStr = "(Host graph: " + left.getName() + ")" + "  output -> input  " + "(LHS of rule: " + ((EdRule)this.rule2).getName() + ")";
        } else {
            left = ((EdRule)this.rule1).getRight();
            titleStr = "(RHS of rule: " + ((EdRule)this.rule1).getName() + ")" + "    OUTPUT      >>      INPUT    " + "(LHS of rule: " + ((EdRule)this.rule2).getName() + ")";
        }
        GraphMorphismEditor gme = this.addGraphMorphismEditor(objFlow, left, right, text);
        if (gme != null) {
            gme.setTitle(titleStr);
            this.editors.put(objFlow, gme);
        }
    }

    private JPanel makeDesktop(Border border) {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(border);
        JLabel l = new JLabel("   ");
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(l.getBackground());
        this.myW = 500;
        this.myH = 500;
        this.desktop.setPreferredSize(new Dimension(this.myW, this.myH));
        this.editors = new Hashtable();
        this.internalFrames = new Hashtable();
        this.internalFrameIcon = null;
        this.internalFrameSize = new Dimension(500, 200);
        this.nextX = 0;
        this.nextY = 0;
        this.panel.add((Component)l, "North");
        this.panel.add((Component)this.desktop, "Center");
        return this.panel;
    }

    public Component getComponent() {
        return this.panel;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    private JPanel makeRuleList(String titleStr, JTable ruleList, JScrollPane scrollRuleList) {
        JLabel l = new JLabel(titleStr);
        scrollRuleList.setPreferredSize(new Dimension(200, 150));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)l, "North");
        p.add((Component)scrollRuleList, "Center");
        return p;
    }

    public void updateRuleList(List<String> rulenames) {
        this.ruleNames.clear();
        if (this.ruleSequence.doesCheckAtGraph() && this.ruleSequence.getGraph() != null) {
            this.ruleNames.add(this.ruleSequence.getGraph().getName());
        }
        this.ruleNames.addAll(rulenames);
        if (this.ruleList1 != null) {
            this.scrollRuleList1.getViewport().remove(this.ruleList1);
        }
        this.ruleList1 = new JTable(this.ruleNames.size(), 1);
        this.scrollRuleList1.getViewport().setView(this.ruleList1);
        this.ruleList1.getSelectionModel().addListSelectionListener(this);
        if (this.ruleList2 != null) {
            this.scrollRuleList2.getViewport().remove(this.ruleList2);
        }
        this.ruleList2 = new JTable(this.ruleNames.size(), 1);
        this.scrollRuleList2.getViewport().setView(this.ruleList2);
        this.ruleList2.getSelectionModel().addListSelectionListener(this);
        int i = 0;
        while (i < this.ruleNames.size()) {
            this.ruleList1.getModel().setValueAt(String.valueOf(i).concat(" ").concat(this.ruleNames.get(i)), i, 0);
            ((DefaultCellEditor)this.ruleList1.getCellEditor(i, 0)).getComponent().setEnabled(false);
            this.ruleList2.getModel().setValueAt(String.valueOf(i).concat(" ").concat(this.ruleNames.get(i)), i, 0);
            ((DefaultCellEditor)this.ruleList2.getCellEditor(i, 0)).getComponent().setEnabled(false);
            ++i;
        }
    }

    public GraphMorphismEditor addGraphMorphismEditor(ObjectFlow objFlow, EdGraph leftGraph, EdGraph rightGraph, String aTitle) {
        OrdinaryMorphism isoLeft = leftGraph.getBasisGraph().isomorphicCopy();
        OrdinaryMorphism isoRight = rightGraph.getBasisGraph().isomorphicCopy();
        if (isoLeft == null || isoRight == null) {
            return null;
        }
        GraphMorphismEditor gmEditor = new GraphMorphismEditor(this.parentFrame);
        EdGraph left = new EdGraph(isoLeft.getTarget());
        left.updateLayoutByIsoMorphism(isoLeft, leftGraph);
        EdGraph right = new EdGraph(isoRight.getTarget());
        right.updateLayoutByIsoMorphism(isoRight, rightGraph);
        OrdinaryMorphism morph = BaseFactory.theFactory().createMorphism(left.getBasisGraph(), right.getBasisGraph());
        ((ContextView)morph.getAttrContext()).changeAllowedMapping(3);
        if (!objFlow.getMapping().isEmpty()) {
            Vector<Object> list = new Vector<Object>();
            Enumeration<Object> keys = objFlow.getMapping().keys();
            while (keys.hasMoreElements()) {
                Object out = keys.nextElement();
                if (out instanceof Node) {
                    Object in = objFlow.getMapping().get(out);
                    try {
                        GraphObject leftobj = isoLeft.getImage((GraphObject)out);
                        GraphObject rightobj = isoRight.getImage((GraphObject)in);
                        if (leftobj == null || rightobj == null) continue;
                        if (leftobj.getType().isParentOf(rightobj.getType())) {
                            morph.addMapping(leftobj, rightobj);
                            continue;
                        }
                        if (!leftobj.getType().isChildOf(rightobj.getType())) continue;
                        morph.addChild2ParentMapping(leftobj, rightobj);
                    }
                    catch (BadMappingException leftobj) {}
                    continue;
                }
                list.add(out);
            }
            int i = 0;
            while (i < list.size()) {
                Object out = list.get(i);
                Object in = objFlow.getMapping().get(out);
                try {
                    GraphObject leftobj = isoLeft.getImage((GraphObject)out);
                    GraphObject rightobj = isoRight.getImage((GraphObject)in);
                    if (leftobj != null && rightobj != null) {
                        morph.addMapping(leftobj, rightobj);
                    }
                }
                catch (BadMappingException badMappingException) {
                    // empty catch block
                }
                ++i;
            }
        }
        gmEditor.setLeftGraph(left);
        gmEditor.setRightGraph(right);
        gmEditor.setMorphism(morph);
        gmEditor.setIsoMorphismLeft(isoLeft);
        gmEditor.setIsoMorphismRight(isoRight);
        gmEditor.setObjectFlow(objFlow);
        if (!objFlow.isEmpty()) {
            gmEditor.updateGraphs();
        }
        gmEditor.setEditMode(115);
        String ofIndx = "(" + String.valueOf(objFlow.getIndexOfOutput()) + "-" + String.valueOf(objFlow.getIndexOfInput()) + ") ";
        JInternalFrame f = new JInternalFrame(String.valueOf(ofIndx) + aTitle, true, true, true, true);
        this.internalFrames.put(gmEditor, f);
        f.addInternalFrameListener(this);
        f.setSize(this.internalFrameSize);
        f.getContentPane().add(gmEditor);
        this.getDesktop().add((Component)f, 0);
        try {
            f.setSelected(true);
            f.setVisible(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        f.setLocation(this.nextX, this.nextY);
        return gmEditor;
    }

    protected void setCurrentObjectFlow() {
        if (this.currentFrame != null && this.currentFrame.isEnabled() && this.currentFrame.isSelected()) {
            Enumeration<GraphMorphismEditor> keys = this.internalFrames.keys();
            while (keys.hasMoreElements()) {
                GraphMorphismEditor gme = keys.nextElement();
                if (this.internalFrames.get(gme) != this.currentFrame) continue;
                this.currentObjFlow = gme.getObjectFlow();
                if (this.currentObjFlow != null) {
                    this.ruleList1.changeSelection(this.currentObjFlow.getIndexOfOutput(), 0, false, false);
                    this.ruleList2.changeSelection(this.currentObjFlow.getIndexOfInput(), 0, false, false);
                    continue;
                }
                this.indx_rule1 = -1;
                this.ruleList1.clearSelection();
                this.rule1 = null;
                this.indx_rule2 = -1;
                this.ruleList2.clearSelection();
                this.rule2 = null;
            }
        }
    }

    public void removeAllFrames() {
        this.internalFrames.clear();
        int i = this.desktop.getAllFrames().length - 1;
        while (i >= 0) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            f.setVisible(false);
            if (f.isIcon()) {
                this.desktop.remove(f.getDesktopIcon());
            } else {
                this.desktop.remove(f);
            }
            --i;
        }
        this.ruleList1.clearSelection();
        this.ruleList2.clearSelection();
        this.rule1 = null;
        this.rule2 = null;
        this.indx_rule1 = -1;
        this.indx_rule2 = -1;
        this.nextX = 0;
        this.nextY = 0;
    }

    public void removeFrame(JInternalFrame f) {
        f.setVisible(false);
        if (f.isIcon()) {
            this.desktop.remove(f.getDesktopIcon());
        } else {
            this.desktop.remove(f);
        }
        this.ruleList1.clearSelection();
        this.ruleList2.clearSelection();
        this.rule1 = null;
        this.rule2 = null;
        this.indx_rule1 = -1;
        this.indx_rule2 = -1;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        this.currentFrame = e.getInternalFrame();
        this.resetListsSelection(this.currentFrame);
    }

    private void resetListsSelection(JInternalFrame f) {
        Enumeration<GraphMorphismEditor> iter1 = this.internalFrames.keys();
        while (iter1.hasMoreElements()) {
            GraphMorphismEditor gme = iter1.nextElement();
            if (this.internalFrames.get(gme) != f) continue;
            Enumeration<ObjectFlow> iter2 = this.editors.keys();
            while (iter2.hasMoreElements()) {
                ObjectFlow of = iter2.nextElement();
                if (this.editors.get(of) != gme) continue;
                int i1 = of.getIndexOfOutput();
                int i2 = of.getIndexOfInput();
                this.ruleList1.changeSelection(i1, 0, false, false);
                this.ruleList2.changeSelection(i2, 0, false, false);
            }
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        Enumeration<GraphMorphismEditor> keys = this.internalFrames.keys();
        while (keys.hasMoreElements()) {
            GraphMorphismEditor gme = keys.nextElement();
            if (this.internalFrames.get(gme) != e.getInternalFrame()) continue;
            this.internalFrames.remove(gme);
        }
        this.currentFrame = null;
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.currentFrame = null;
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        this.currentFrame = e.getInternalFrame();
        this.resetListsSelection(this.currentFrame);
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int indx;
        if (this.currentFrame != null) {
            try {
                this.currentFrame.setSelected(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((indx = ((DefaultListSelectionModel)e.getSource()).getLeadSelectionIndex()) != -1) {
            if (e.getSource() == this.ruleList1.getSelectionModel()) {
                this.list2Clicked = false;
                this.indx_rule1 = indx;
                this.rule1 = this.gragra.getRule(this.ruleNames.get(indx));
                if (this.rule1 == null && indx == 0) {
                    this.rule1 = this.gragra.getGraphOf(this.ruleSequence.getGraph());
                }
                if (this.indx_rule2 <= this.indx_rule1) {
                    this.ruleList2.clearSelection();
                    this.rule2 = null;
                    this.indx_rule2 = -1;
                    this.disconnect.setEnabled(false);
                    this.connect.setEnabled(false);
                } else if (this.tryToShowOF()) {
                    this.connect.setEnabled(false);
                    this.disconnect.setEnabled(true);
                } else {
                    this.connect.setEnabled(true);
                    this.disconnect.setEnabled(false);
                }
            } else if (e.getSource() == this.ruleList2.getSelectionModel()) {
                if (indx > this.indx_rule1) {
                    this.list2Clicked = true;
                    this.indx_rule2 = indx;
                    this.rule2 = this.gragra.getRule(this.ruleNames.get(indx));
                    if (this.tryToShowOF()) {
                        this.connect.setEnabled(false);
                        this.disconnect.setEnabled(true);
                    } else {
                        this.connect.setEnabled(true);
                        this.disconnect.setEnabled(false);
                    }
                } else {
                    this.ruleList2.clearSelection();
                    this.rule2 = null;
                    this.indx_rule2 = -1;
                    this.disconnect.setEnabled(false);
                    this.connect.setEnabled(false);
                }
            }
        }
    }

    protected boolean tryToShowOF() {
        int i = this.ruleList1.getSelectionModel().getLeadSelectionIndex();
        if (i >= 0 && this.ruleList2.getSelectionModel().getLeadSelectionIndex() > i && this.rule1 != null && this.rule2 != null && (this.rule1 instanceof EdGraph || this.rule1 instanceof EdRule) && this.rule2 instanceof EdRule) {
            String key = String.valueOf(this.indx_rule1).concat(":").concat(String.valueOf(this.indx_rule2));
            ObjectFlow objFlow = this.ruleSequence.getObjectFlow().get(key);
            if (objFlow != null) {
                if (this.editors.get(objFlow) == null || this.internalFrames.get(this.editors.get(objFlow)) == null) {
                    String str = "An output object can be connected to an input object";
                    this.addGraphMorphismEditor(objFlow, str);
                    return true;
                }
                try {
                    this.internalFrames.get(this.editors.get(objFlow)).setIcon(false);
                    this.internalFrames.get(this.editors.get(objFlow)).setSelected(true);
                    this.internalFrames.get(this.editors.get(objFlow)).setVisible(true);
                    return true;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

