/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class EdRule
implements XMLObject,
StateEditable {
    protected Rule bRule;
    protected EdTypeSet typeSet;
    protected EdGraph eLeft;
    protected EdGraph eRight;
    protected EdGraGra eGra;
    protected Vector<EdPAC> itsACs;
    protected Vector<EdNAC> itsNACs;
    protected Vector<EdPAC> itsPACs;
    protected boolean badMapping;
    protected String errMsg;
    protected boolean animated;
    protected int animationKind;
    protected boolean editable;
    protected EditUndoManager undoManager;
    protected StateEdit newEdit;
    protected Pair<String, Vector<String>> undoObj;

    public EdRule() {
        this.init(new EdTypeSet());
    }

    protected EdRule(boolean empty) {
        if (!empty) {
            this.init(new EdTypeSet());
        }
        this.editable = true;
    }

    public EdRule(EdTypeSet types) {
        this.init(types);
    }

    private void init(EdTypeSet types) {
        this.bRule = null;
        this.typeSet = types;
        this.eLeft = new EdGraph(this.typeSet);
        this.eRight = new EdGraph(this.typeSet);
        this.initLists();
    }

    private void initLists() {
        this.itsACs = new Vector();
        this.itsNACs = new Vector();
        this.itsPACs = new Vector();
        this.errMsg = "";
        this.animationKind = -1;
        this.editable = true;
    }

    public EdRule(Rule rule) {
        this.bRule = rule;
        this.typeSet = new EdTypeSet(this.bRule.getLeft().getTypeSet());
        this.eLeft = new EdGraph(this.bRule.getLeft(), this.typeSet);
        this.eRight = new EdGraph(this.bRule.getRight(), this.typeSet);
        this.initLists();
        this.createApplConds();
    }

    public EdRule(Rule rule, EdTypeSet types) {
        this.bRule = rule;
        this.typeSet = types;
        this.eLeft = new EdGraph(this.bRule.getLeft(), this.typeSet);
        this.eRight = new EdGraph(this.bRule.getRight(), this.typeSet);
        this.initLists();
        this.createApplConds();
    }

    public void trimToSize() {
        this.itsNACs.trimToSize();
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.elementAt(i).trimToSize();
            ++i;
        }
        this.itsPACs.trimToSize();
        i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.elementAt(i).trimToSize();
            ++i;
        }
        this.itsACs.trimToSize();
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.elementAt(i).trimToSize();
            ++i;
        }
    }

    public void setEditable(boolean b) {
        EdGraph ac;
        this.editable = b;
        this.getLeft().setEditable(b);
        this.getRight().setEditable(b);
        int j = 0;
        while (j < this.getNACs().size()) {
            ac = this.getNACs().elementAt(j);
            ac.setEditable(b);
            ++j;
        }
        j = 0;
        while (j < this.getPACs().size()) {
            ac = this.getPACs().elementAt(j);
            ac.setEditable(b);
            ++j;
        }
        j = 0;
        while (j < this.getNestedACs().size()) {
            ac = (EdNestedApplCond)this.getNestedACs().elementAt(j);
            ((EdNestedApplCond)ac).setEditable(b);
            ++j;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void createApplConds() {
        Enumeration<OrdinaryMorphism> acs = this.bRule.getNestedACs();
        while (acs.hasMoreElements()) {
            OrdinaryMorphism ac = acs.nextElement();
            this.createNestedAC(ac);
        }
        Enumeration<OrdinaryMorphism> nacs = this.bRule.getNACs();
        while (nacs.hasMoreElements()) {
            OrdinaryMorphism nac = nacs.nextElement();
            this.createNAC(nac);
        }
        Enumeration<OrdinaryMorphism> pacs = this.bRule.getPACs();
        while (pacs.hasMoreElements()) {
            OrdinaryMorphism pac = pacs.nextElement();
            this.createPAC(pac);
        }
    }

    public void dispose() {
        while (!this.itsNACs.isEmpty()) {
            this.itsNACs.remove(0).dispose();
        }
        while (!this.itsPACs.isEmpty()) {
            this.itsPACs.remove(0).dispose();
        }
        while (!this.itsACs.isEmpty()) {
            this.itsACs.remove(0).dispose();
        }
        this.eLeft.dispose();
        this.eRight.dispose();
        this.eLeft = null;
        this.eRight = null;
        this.bRule = null;
        this.typeSet = null;
        this.eGra = null;
        if (this.undoObj != null) {
            ((Vector)this.undoObj.second).clear();
        }
        if (this.newEdit != null) {
            this.newEdit.die();
        }
        this.undoManager = null;
    }

    public void finalize() {
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
        this.eLeft.setUndoManager(this.undoManager);
        this.eRight.setUndoManager(this.undoManager);
        int j = 0;
        while (j < this.getNACs().size()) {
            this.getNACs().get(j).setUndoManager(this.undoManager);
            ++j;
        }
        j = 0;
        while (j < this.getPACs().size()) {
            this.getPACs().get(j).setUndoManager(this.undoManager);
            ++j;
        }
        j = 0;
        while (j < this.getNestedACs().size()) {
            this.getNestedACs().get(j).setUndoManager(this.undoManager);
            ++j;
        }
    }

    private boolean undoManagerAddEdit(String presentationName) {
        this.newEdit = new StateEdit(this, presentationName);
        return this.undoManager.addEdit(this.newEdit);
    }

    public void undoManagerEndEdit() {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.undoObj == null) {
            return;
        }
        String addEditKind = (String)this.undoObj.first;
        String kind = "";
        Vector<String> gos = new Vector<String>(((Vector)this.undoObj.second).size());
        gos.addAll((Collection)this.undoObj.second);
        if (addEditKind.equals("MAPPING_CREATE_DELETE")) {
            kind = "MAPPING_DELETE_CREATE";
        } else if (addEditKind.equals("MAPPING_DELETE_CREATE")) {
            kind = "MAPPING_CREATE_DELETE";
        } else if (addEditKind.equals("NAC_MAPPING_CREATE_DELETE")) {
            kind = "NAC_MAPPING_DELETE_CREATE";
        } else if (addEditKind.equals("NAC_MAPPING_DELETE_CREATE")) {
            kind = "NAC_MAPPING_CREATE_DELETE";
        } else if (addEditKind.equals("MATCH_MAPPING_CREATE_DELETE")) {
            kind = "MATCH_MAPPING_DELETE_CREATE";
        } else if (addEditKind.equals("MATCH_MAPPING_DELETE_CREATE")) {
            kind = "MATCH_MAPPING_CREATE_DELETE";
        } else if (addEditKind.equals("MATCH_COMPLETION_MAPPING_CREATE_DELETE")) {
            kind = "MATCH_COMPLETION_MAPPING_DELETE_CREATE";
            gos = this.makeUndoObjectOfMatchCompletionMapping();
        } else if (addEditKind.equals("MATCH_COMPLETION_MAPPING_DELETE_CREATE")) {
            kind = "MATCH_COMPLETION_MAPPING_CREATE_DELETE";
            gos = this.makeUndoObjectOfMatchCompletionMapping();
        }
        if (!kind.equals("")) {
            this.endEdit(gos, kind);
        }
    }

    private void endEdit(Vector<String> gos, String kind) {
        this.undoObj = new Pair<String, Vector<String>>(kind, gos);
        this.undoManager.end(this.newEdit);
    }

    public void undoManagerLastEditDie() {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable()) {
            return;
        }
        this.undoManager.lastEditDie();
    }

    protected void addEdit(EdGraphObject src, EdGraphObject tar, String kind, String presentation) {
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(src.hashCode()));
        v.add(String.valueOf(tar.hashCode()));
        this.undoObj = new Pair(kind, v);
        this.undoManagerAddEdit(presentation);
    }

    public void addCreatedMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        EdGraphObject go;
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.getMorphism() == null) {
            return;
        }
        GraphObject oldImg = null;
        oldImg = this instanceof EdAtomic ? ((EdAtomic)this).getBasisAtomic().getImage(src.getBasisObject()) : this.bRule.getImage(src.getBasisObject());
        if (oldImg != null && (go = this.eRight.findGraphObject(oldImg)) != null) {
            this.addDeletedMappingToUndo(src, go);
        }
        this.addEdit(src, tar, "MAPPING_CREATE_DELETE", "Undo Create Rule Mapping");
    }

    public void addDeletedMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.getMorphism() == null) {
            return;
        }
        if (tar.isNode()) {
            OrdinaryMorphism morph = this.getMorphism();
            this.addDeletedMappingOfInOutEdgesToUndo((EdNode)src, (EdNode)tar, src.getContext(), tar.getContext(), morph, "MAPPING_DELETE_CREATE", "Undo Delete Rule Mapping");
        }
        this.addEdit(src, tar, "MAPPING_DELETE_CREATE", "Undo Delete Rule Mapping");
    }

    public void addCreatedNACMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        EdGraphObject go;
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null) {
            return;
        }
        EdNAC nac = (EdNAC)tar.getContext();
        GraphObject oldImg = nac.getMorphism().getImage(src.getBasisObject());
        if (oldImg != null && (go = nac.findGraphObject(oldImg)) != null) {
            this.addDeletedNACMappingToUndo(src, go);
        }
        this.addEdit(src, tar, "NAC_MAPPING_CREATE_DELETE", "Undo Create NAC Mapping");
    }

    public void addDeletedNACMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null) {
            return;
        }
        if (tar.isNode()) {
            this.addDeletedMappingOfInOutEdgesToUndo((EdNode)src, (EdNode)tar, src.getContext(), tar.getContext(), ((EdNAC)tar.getContext()).getMorphism(), "NAC_MAPPING_DELETE_CREATE", "Undo Delete NAC Mapping");
        }
        this.addEdit(src, tar, "NAC_MAPPING_DELETE_CREATE", "Undo Delete NAC Mapping");
    }

    public void addCreatedPACMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        EdGraphObject go;
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null) {
            return;
        }
        EdPAC pac = (EdPAC)tar.getContext();
        GraphObject oldImg = pac.getMorphism().getImage(src.getBasisObject());
        if (oldImg != null && (go = pac.findGraphObject(oldImg)) != null) {
            this.addDeletedPACMappingToUndo(src, go);
        }
        this.addEdit(src, tar, "PAC_MAPPING_CREATE_DELETE", "Undo Create PAC Mapping");
    }

    public void addDeletedPACMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null) {
            return;
        }
        if (tar.isNode()) {
            this.addDeletedMappingOfInOutEdgesToUndo((EdNode)src, (EdNode)tar, src.getContext(), tar.getContext(), ((EdPAC)tar.getContext()).getMorphism(), "PAC_MAPPING_DELETE_CREATE", "Undo Delete PAC Mapping");
        }
        this.addEdit(src, tar, "PAC_MAPPING_DELETE_CREATE", "Undo Delete PAC Mapping");
    }

    public void addCreatedACMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        EdGraphObject go;
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null) {
            return;
        }
        EdPAC ac = (EdPAC)tar.getContext();
        GraphObject oldImg = ac.getMorphism().getImage(src.getBasisObject());
        if (oldImg != null && (go = ac.findGraphObject(oldImg)) != null) {
            this.addDeletedACMappingToUndo(src, go);
        }
        this.addEdit(src, tar, "AC_MAPPING_CREATE_DELETE", "Undo Create AC Mapping");
    }

    public void addDeletedACMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null) {
            return;
        }
        if (tar.isNode()) {
            this.addDeletedMappingOfInOutEdgesToUndo((EdNode)src, (EdNode)tar, src.getContext(), tar.getContext(), ((EdPAC)tar.getContext()).getMorphism(), "AC_MAPPING_DELETE_CREATE", "Undo Delete AC Mapping");
        }
        this.addEdit(src, tar, "AC_MAPPING_DELETE_CREATE", "Undo Delete AC Mapping");
    }

    private void addDeletedMappingOfInOutEdgesToUndo(EdNode orig, EdNode img, EdGraph origG, EdGraph imgG, OrdinaryMorphism morph, String kind, String msg) {
        Vector<EdArc> inArcs = origG.getIncomingArcs(orig);
        int i = 0;
        while (i < inArcs.size()) {
            Arc imgArc;
            EdArc imgEdArc;
            EdArc origEdArc = inArcs.get(i);
            GraphObject obj = morph.getImage(origEdArc.getBasisArc());
            if (obj != null && (imgEdArc = imgG.findArc(imgArc = (Arc)obj)) != null) {
                this.addEdit(origEdArc, imgEdArc, kind, msg);
            }
            ++i;
        }
        Vector<EdArc> outArcs = origG.getOutgoingArcs(orig);
        int i2 = 0;
        while (i2 < outArcs.size()) {
            Arc imgArc;
            EdArc imgEdArc;
            GraphObject obj;
            EdArc origEdArc = outArcs.get(i2);
            if (!inArcs.contains(origEdArc) && (obj = morph.getImage(origEdArc.getBasisArc())) != null && (imgEdArc = imgG.findArc(imgArc = (Arc)obj)) != null) {
                this.addEdit(origEdArc, imgEdArc, kind, msg);
            }
            ++i2;
        }
    }

    public void addCreatedMatchMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        EdGraphObject go;
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null || this.bRule.getMatch() == null) {
            return;
        }
        GraphObject oldImg = this.bRule.getMatch().getImage(src.getBasisObject());
        if (oldImg != null && (go = this.eGra.getGraphOf(this.bRule.getMatch().getImage()).findGraphObject(oldImg)) != null) {
            this.addDeletedMatchMappingToUndo(src, go);
        }
        this.addEdit(src, tar, "MATCH_MAPPING_CREATE_DELETE", "Undo Create Match Mapping");
    }

    public void addDeletedMatchMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null || this.bRule.getMatch() == null) {
            return;
        }
        this.addEdit(src, tar, "MATCH_MAPPING_DELETE_CREATE", "Undo Delete Match Mapping");
    }

    public void addCreatedMatchMappingToUndo() {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null || this.bRule.getMatch() == null) {
            return;
        }
        String kind = "MATCH_COMPLETION_MAPPING_CREATE_DELETE";
        Vector<String> v = this.makeUndoObjectOfMatchCompletionMapping();
        this.undoObj = new Pair<String, Vector<String>>(kind, v);
        this.undoManagerAddEdit("Undo Create Match Completion Mapping");
    }

    public void addDeletedMatchMappingToUndo() {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.eLeft.isEditable() || this.bRule == null || this.bRule.getMatch() == null) {
            return;
        }
        String kind = "MATCH_COMPLETION_MAPPING_DELETE_CREATE";
        Vector<String> v = this.makeUndoObjectOfMatchCompletionMapping();
        this.undoObj = new Pair<String, Vector<String>>(kind, v);
        this.undoManagerAddEdit("Undo Delete Match Completion Mapping");
    }

    private Vector<String> makeUndoObjectOfMatchCompletionMapping() {
        Vector<String> pairs = new Vector<String>();
        if (this.bRule == null || this.bRule.getMatch() == null) {
            return pairs;
        }
        EdGraph hostgraph = this.eGra.getGraphOf(this.bRule.getMatch().getImage());
        Vector<EdNode> vec = this.eLeft.getNodes();
        int i = 0;
        while (i < vec.size()) {
            EdGraphObject lgo = vec.get(i);
            GraphObject img = this.bRule.getMatch().getImage(lgo.getBasisObject());
            if (img != null) {
                EdGraphObject ggo = hostgraph.findGraphObject(img);
                pairs.add(String.valueOf(lgo.hashCode()));
                pairs.add(String.valueOf(ggo.hashCode()));
            } else {
                pairs.add(String.valueOf(lgo.hashCode()));
                pairs.add("");
            }
            ++i;
        }
        Vector<EdArc> vec1 = this.eLeft.getArcs();
        int i2 = 0;
        while (i2 < vec1.size()) {
            EdGraphObject lgo = vec1.get(i2);
            GraphObject img = this.bRule.getMatch().getImage(lgo.getBasisObject());
            if (img != null) {
                EdGraphObject ggo = hostgraph.findGraphObject(img);
                pairs.add(String.valueOf(lgo.hashCode()));
                pairs.add(String.valueOf(ggo.hashCode()));
            } else {
                pairs.add(String.valueOf(lgo.hashCode()));
                pairs.add("");
            }
            ++i2;
        }
        return pairs;
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        if (this.undoObj != null && this.undoObj.first != null && this.undoObj.second != null) {
            state.put(this, this.undoObj);
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        Object obj = state.get(this);
        if (obj == null || !(obj instanceof Pair)) {
            return;
        }
        String op = (String)((Pair)obj).first;
        if (op.equals("MATCH_COMPLETION_MAPPING_CREATE_DELETE")) {
            EdGraph hostGraph;
            if (this.bRule.getMatch() == null) {
                this.eGra.getBasisGraGra().createMatch(this.bRule);
            }
            if ((hostGraph = this.eGra.getGraphOf(this.bRule.getMatch().getTarget())) != null) {
                String lobjHC;
                Vector vec = (Vector)((Pair)obj).second;
                int i = vec.size() - 2;
                while (i >= 0) {
                    lobjHC = (String)vec.get(i);
                    EdGraphObject lobj = this.eLeft.findGraphObject(lobjHC);
                    this.removeMatchMapping(lobj);
                    i -= 2;
                }
                i = 0;
                while (i < vec.size()) {
                    EdGraphObject graphObj;
                    lobjHC = (String)vec.get(i);
                    String imgHC = (String)vec.get(i + 1);
                    EdGraphObject lobj = this.eLeft.findGraphObject(lobjHC);
                    if (!"".equals(imgHC) && (graphObj = hostGraph.findGraphObject(imgHC)) != null && lobj != null) {
                        this.interactMatch(lobj, graphObj);
                    }
                    i += 2;
                }
            }
        } else if (op.equals("MATCH_COMPLETION_MAPPING_DELETE_CREATE")) {
            EdGraph hostGraph;
            if (this.bRule.getMatch() == null) {
                this.eGra.getBasisGraGra().createMatch(this.bRule);
            }
            if (this.bRule.getMatch() != null && (hostGraph = this.eGra.getGraphOf(this.bRule.getMatch().getTarget())) != null) {
                String lobjHC;
                Vector vec = (Vector)((Pair)obj).second;
                int i = vec.size() - 2;
                while (i >= 0) {
                    lobjHC = (String)vec.get(i);
                    EdGraphObject lobj = this.eLeft.findGraphObject(lobjHC);
                    this.removeMatchMapping(lobj);
                    i -= 2;
                }
                i = 0;
                while (i < vec.size()) {
                    EdGraphObject graphObj;
                    lobjHC = (String)vec.get(i);
                    String imgHC = (String)vec.get(i + 1);
                    EdGraphObject lobj = this.eLeft.findGraphObject(lobjHC);
                    if (!"".equals(imgHC) && (graphObj = hostGraph.findGraphObject(imgHC)) != null && lobj != null) {
                        this.interactMatch(lobj, graphObj);
                    }
                    i += 2;
                }
            }
        } else {
            Vector vec = (Vector)((Pair)obj).second;
            if (!vec.isEmpty() && vec.size() == 2) {
                String objHC = (String)vec.get(0);
                String imgHC = (String)vec.get(1);
                if (op.equals("MAPPING_CREATE_DELETE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    this.propagateRemoveRuleMappingToMultiRule(lObj);
                    this.removeRuleMapping(lObj);
                } else if (op.equals("MAPPING_DELETE_CREATE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    EdGraphObject rObj = this.eRight.findGraphObject(imgHC);
                    if (lObj != null && rObj != null) {
                        this.interactRule(lObj, rObj);
                        this.propagateAddRuleMappingToMultiRule(lObj, rObj);
                    }
                } else if (op.equals("NAC_MAPPING_CREATE_DELETE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    EdGraphObject nacObj = this.findGraphObjectOfNAC(imgHC);
                    if (lObj != null && nacObj != null && nacObj.getContext() != null) {
                        EdNAC nac = (EdNAC)nacObj.getContext();
                        this.removeNACMapping(lObj, nac.getMorphism());
                    }
                } else if (op.equals("NAC_MAPPING_DELETE_CREATE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    EdGraphObject nacObj = this.findGraphObjectOfNAC(imgHC);
                    if (lObj != null && nacObj != null && nacObj.getContext() != null) {
                        EdNAC nac = (EdNAC)nacObj.getContext();
                        this.interactNAC(lObj, nacObj, nac.getMorphism());
                    }
                } else if (op.equals("PAC_MAPPING_CREATE_DELETE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    EdGraphObject pacObj = this.findGraphObjectOfPAC(imgHC);
                    if (lObj != null && pacObj != null && pacObj.getContext() != null) {
                        EdPAC pac = (EdPAC)pacObj.getContext();
                        this.removePACMapping(lObj, pac.getMorphism());
                    }
                } else if (op.equals("PAC_MAPPING_DELETE_CREATE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    EdGraphObject pacObj = this.findGraphObjectOfPAC(imgHC);
                    if (lObj != null && pacObj != null && pacObj.getContext() != null) {
                        EdPAC pac = (EdPAC)pacObj.getContext();
                        this.interactPAC(lObj, pacObj, pac.getMorphism());
                    }
                } else if (op.equals("AC_MAPPING_CREATE_DELETE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    if (lObj == null) {
                        lObj = this.findGraphObjectOfAC(objHC);
                    }
                    EdGraphObject acObj = this.findGraphObjectOfAC(imgHC);
                    if (lObj != null && acObj != null && acObj.getContext() != null) {
                        EdNestedApplCond ac = (EdNestedApplCond)acObj.getContext();
                        this.removeNestedACMapping(lObj, ac.getNestedMorphism());
                    }
                } else if (op.equals("AC_MAPPING_DELETE_CREATE")) {
                    EdGraphObject lObj = this.eLeft.findGraphObject(objHC);
                    if (lObj == null) {
                        lObj = this.findGraphObjectOfAC(objHC);
                    }
                    EdGraphObject acObj = this.findGraphObjectOfAC(imgHC);
                    if (lObj != null && lObj.getContext() != null && acObj != null && acObj.getContext() != null) {
                        EdNestedApplCond ac = (EdNestedApplCond)acObj.getContext();
                        this.interactNestedAC(lObj, acObj, ac.getNestedMorphism());
                    }
                } else if (op.equals("MATCH_MAPPING_CREATE_DELETE")) {
                    if (this.bRule.getMatch() != null) {
                        EdGraphObject lobj = this.eLeft.findGraphObject(objHC);
                        this.removeMatchMapping(lobj);
                    }
                } else if (op.equals("MATCH_MAPPING_DELETE_CREATE")) {
                    if (this.bRule.getMatch() == null) {
                        this.eGra.getBasisGraGra().createMatch(this.bRule);
                    }
                    EdGraph hostGraph = this.eGra.getGraphOf(this.bRule.getMatch().getTarget());
                    EdGraphObject leftObj = this.eLeft.findGraphObject(objHC);
                    EdGraphObject graphObj = hostGraph.findGraphObject(imgHC);
                    this.interactMatch(leftObj, graphObj);
                }
            }
        }
    }

    public void propagateAddRuleMappingToMultiRule(EdGraphObject lobj, EdGraphObject robj) {
        EdRuleScheme rs;
        if (this.bRule instanceof KernelRule && (rs = this.eGra.getRuleScheme(this.bRule)) != null) {
            rs.propagateAddMappingToMultiRule(lobj, robj);
        }
    }

    public void propagateRemoveRuleMappingToMultiRule(EdGraphObject obj) {
        EdRuleScheme rs;
        if (this.bRule instanceof KernelRule && (rs = this.eGra.getRuleScheme(this.bRule)) != null) {
            if (obj.getContext().getBasisGraph() == this.bRule.getLeft()) {
                rs.propagateRemoveMappingToMultiRule(obj, true);
            } else if (obj.getContext().getBasisGraph() == this.bRule.getRight()) {
                rs.propagateRemoveMappingToMultiRule(obj, false);
            }
        }
    }

    protected EdGraphObject findRestoredObjectOfNAC(EdGraphObject go) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.get(i);
            EdGraphObject obj = nac.findRestoredObject(go);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findGraphObjectOfNAC(String goHashCode) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.get(i);
            EdGraphObject obj = nac.findGraphObject(goHashCode);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findRestoredObjectOfPAC(EdGraphObject go) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.get(i);
            EdGraphObject obj = pac.findRestoredObject(go);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findGraphObjectOfPAC(String goHashCode) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.get(i);
            EdGraphObject obj = pac.findGraphObject(goHashCode);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findRestoredObjectOfAC(EdGraphObject go) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsACs.get(i);
            EdGraphObject obj = ac.findRestoredObject(go);
            if (obj != null) {
                return obj;
            }
            obj = ac.findRestoredObjectOfAC(go);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findGraphObjectOfAC(String goHashCode) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsACs.get(i);
            EdGraphObject obj = ac.findGraphObject(goHashCode);
            if (obj != null) {
                return obj;
            }
            obj = ac.findGraphObjectOfAC(goHashCode);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public void unsetBasisRule() {
        this.bRule = null;
    }

    public void clear() {
        this.eLeft.clear();
        this.eRight.clear();
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.elementAt(i).clear();
            ++i;
        }
        this.itsNACs.clear();
        i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.elementAt(i).clear();
            ++i;
        }
        this.itsPACs.clear();
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.elementAt(i).clear();
            ++i;
        }
        this.itsACs.clear();
    }

    public String getName() {
        if (this.bRule != null) {
            return this.bRule.getName();
        }
        return "";
    }

    public Rule getBasisRule() {
        return this.bRule;
    }

    public OrdinaryMorphism getMorphism() {
        if (this instanceof EdAtomic) {
            return ((EdAtomic)this).getMorphism();
        }
        return this.bRule;
    }

    public EdGraph getLeft() {
        return this.eLeft;
    }

    public EdGraph getRight() {
        return this.eRight;
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public void setGraGra(EdGraGra egra) {
        this.eGra = egra;
        if (egra != null) {
            EdGraph ac;
            this.eLeft.setGraGra(egra);
            this.eRight.setGraGra(egra);
            this.typeSet = egra.getTypeSet();
            int i = 0;
            while (i < this.itsNACs.size()) {
                ac = this.itsNACs.elementAt(i);
                ac.setGraGra(egra);
                ac.setTypeSet(egra.getTypeSet());
                ++i;
            }
            i = 0;
            while (i < this.itsPACs.size()) {
                ac = this.itsPACs.elementAt(i);
                ac.setGraGra(egra);
                ac.setTypeSet(egra.getTypeSet());
                ++i;
            }
            i = 0;
            while (i < this.itsACs.size()) {
                ac = this.itsACs.elementAt(i);
                ac.setGraGra(egra);
                ac.setTypeSet(egra.getTypeSet());
                ++i;
            }
        }
    }

    public EdTypeSet getTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
        if (types != null) {
            EdGraph ac;
            this.eLeft.setTypeSet(types);
            this.eRight.setTypeSet(types);
            int i = 0;
            while (i < this.itsNACs.size()) {
                ac = this.itsNACs.elementAt(i);
                ac.setTypeSet(types);
                ++i;
            }
            i = 0;
            while (i < this.itsPACs.size()) {
                ac = this.itsPACs.elementAt(i);
                ac.setTypeSet(types);
                ++i;
            }
            i = 0;
            while (i < this.itsACs.size()) {
                ac = this.itsACs.elementAt(i);
                ac.setTypeSet(types);
                ++i;
            }
            this.typeSet = types;
        }
    }

    public boolean isApplicable() {
        if (this.bRule != null) {
            return this.bRule.isApplicable();
        }
        return true;
    }

    public void setApplicable(boolean applicable) {
        if (this.bRule != null) {
            this.bRule.setApplicable(applicable);
        }
    }

    public void setAnimated(boolean b) {
        this.animated = b;
        if (this.animated) {
            EdNode n;
            this.animationKind = -1;
            Vector<EdNode> nodes = this.eRight.getNodes();
            int i = 0;
            while (i < nodes.size()) {
                n = nodes.get(i);
                if (!this.bRule.getInverseImage(n.getBasisNode()).hasMoreElements() && n.getType().isAnimated()) {
                    this.animationKind = n.getType().getAnimationKind();
                    break;
                }
                ++i;
            }
            if (this.animationKind == -1) {
                i = 0;
                while (i < nodes.size()) {
                    Iterator<Arc> arcs;
                    n = nodes.get(i);
                    if (this.bRule.getInverseImage(n.getBasisNode()).hasMoreElements() && n.getBasisNode().getOutgoingArcsSet().size() == 1 && !this.bRule.getInverseImage((arcs = n.getBasisNode().getOutgoingArcsSet().iterator()).next()).hasMoreElements() && n.getType().isAnimated()) {
                        this.animationKind = n.getType().getAnimationKind();
                        break;
                    }
                    ++i;
                }
            }
            if (this.animationKind == -1) {
                this.animationKind = 11;
            }
            this.eGra.setAnimated(true);
        } else {
            this.animationKind = -1;
            if (this.eGra.isAnimated()) {
                this.eGra.resetAnimated(false);
            }
        }
    }

    public int getAnimationKind() {
        return this.animationKind;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public Vector<EdNode> getAbstractNodesOfRHSToCreate() {
        Vector<EdNode> result = new Vector<EdNode>();
        Vector<EdNode> nodes = this.eRight.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            EdNode n = nodes.get(i);
            if (!this.bRule.getInverseImage(n.getBasisNode()).hasMoreElements() && n.getType().getBasisType().isAbstract()) {
                result.add(n);
            }
            ++i;
        }
        return result;
    }

    public Match getMatch() {
        if (this.bRule != null) {
            return this.bRule.getMatch();
        }
        return null;
    }

    public EdGraphObject getImage(EdGraphObject orig) {
        GraphObject im = this.bRule.getImage(orig.getBasisObject());
        return this.eRight.findGraphObject(im);
    }

    public Vector<EdGraphObject> getOriginal(EdGraphObject image) {
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(2);
        Enumeration<GraphObject> en = this.bRule.getInverseImage(image.getBasisObject());
        while (en.hasMoreElements()) {
            GraphObject or = en.nextElement();
            EdGraphObject go = this.eLeft.findGraphObject(or);
            if (go == null) continue;
            vec.add(go);
        }
        return vec;
    }

    public Vector<String> getAttrConditions() {
        Vector<String> conds = new Vector<String>(1);
        if (this.bRule == null) {
            return conds;
        }
        CondTuple ct = (CondTuple)this.bRule.getAttrContext().getConditions();
        int i = 0;
        while (i < ct.getSize()) {
            conds.add(ct.getCondMemberAt(i).getExprAsText());
            ++i;
        }
        return conds;
    }

    public Object getApplCondByImageGraph(Graph g) {
        EdGraph cond;
        int i = 0;
        while (i < this.itsACs.size()) {
            cond = (EdNestedApplCond)this.itsACs.elementAt(i);
            if (((EdPAC)cond).getMorphism().getImage() == g) {
                return cond;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            cond = this.itsPACs.elementAt(i);
            if (((EdPAC)cond).getMorphism().getImage() == g) {
                return cond;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsNACs.size()) {
            cond = this.itsNACs.elementAt(i);
            if (((EdNAC)cond).getMorphism().getImage() == g) {
                return cond;
            }
            ++i;
        }
        return null;
    }

    public boolean hasNACs() {
        return !this.itsNACs.isEmpty();
    }

    public Vector<EdNAC> getNACs() {
        return this.itsNACs;
    }

    public EdNAC getNAC(int index) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            if (i == index) {
                return this.itsNACs.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public EdNAC getNAC(String nacname) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.elementAt(i);
            if (nac.getName().equals(nacname)) {
                return nac;
            }
            ++i;
        }
        return null;
    }

    public EdNAC getNAC(OrdinaryMorphism morphism) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.elementAt(i);
            if (nac.getMorphism() == morphism) {
                return nac;
            }
            ++i;
        }
        return null;
    }

    public EdNAC createNAC(String nameStr, boolean isIdentic) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdNAC nac = new EdNAC(this.bRule.createNAC(), this.typeSet);
        nac.getBasisGraph().setName(nameStr);
        nac.setName(nameStr);
        nac.setRule(this);
        nac.setGraGra(this.eGra);
        nac.setEditable(this.eLeft.isEditable());
        nac.setUndoManager(this.undoManager);
        if (isIdentic && nac.isEditable()) {
            this.identicNAC(nac);
        }
        this.itsNACs.addElement(nac);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return nac;
    }

    public EdNAC createNAC(OrdinaryMorphism nac) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdNAC eNAC = new EdNAC(nac, this.typeSet);
        eNAC.getBasisGraph().setName(nac.getName());
        eNAC.setName(nac.getName());
        eNAC.setRule(this);
        eNAC.setGraGra(this.eGra);
        eNAC.setUndoManager(this.undoManager);
        this.itsNACs.addElement(eNAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eNAC;
    }

    public EdNAC createNACDuetoRHS(String nameStr) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdNAC eNAC = new EdNAC(this.bRule.createNAC(), this.typeSet);
        eNAC.getBasisGraph().setName(nameStr);
        eNAC.setName(nameStr);
        eNAC.setRule(this);
        eNAC.setGraGra(this.eGra);
        eNAC.setEditable(this.eLeft.isEditable());
        eNAC.setUndoManager(this.undoManager);
        this.makeNACDuetoRHS(eNAC);
        this.itsNACs.addElement(eNAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eNAC;
    }

    public boolean addNAC(EdNAC nac) {
        boolean sameTypes;
        if (this.bRule == null) {
            return false;
        }
        boolean bl = sameTypes = nac.getTypeSet().getBasisTypeSet() == this.typeSet.getBasisTypeSet();
        if ((sameTypes || nac.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) && this.bRule.addNAC(nac.getMorphism())) {
            if (!sameTypes) {
                this.bRule.getLeft().getTypeSet().adaptTypes(nac.getTypeSet().getBasisTypeSet(), false);
                this.typeSet.refreshTypes();
            }
            nac.setRule(this);
            nac.setGraGra(this.eGra);
            nac.setUndoManager(this.undoManager);
            this.itsNACs.addElement(nac);
            if (this.eGra != null) {
                this.eGra.setChanged(true);
            }
            return true;
        }
        return false;
    }

    public void destroyNAC(EdNAC enac) {
        if (this.bRule == null || enac.getMorphism() == null) {
            return;
        }
        enac.getMorphism().deleteObserver(enac);
        this.itsNACs.removeElement(enac);
        this.getBasisRule().destroyNAC(enac.getMorphism());
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
    }

    public void identicNAC(EdNAC enac) {
        OrdinaryMorphism morph = enac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        enac.clear();
        int i = 0;
        while (i < this.eLeft.getNodes().size()) {
            EdNode en = this.eLeft.getNodes().elementAt(i);
            this.identicNode(en, enac, morph);
            ++i;
        }
        int j = 0;
        while (j < this.eLeft.getArcs().size()) {
            EdArc ea = this.eLeft.getArcs().elementAt(j);
            this.identicArc(ea, enac, morph);
            ++j;
        }
        this.updateRule();
        this.updateNAC(enac);
    }

    public void addIdenticToNAC(Vector<EdGraphObject> graphObjects, EdNAC enac) {
        int i = 0;
        while (i < graphObjects.size()) {
            EdGraphObject go = graphObjects.elementAt(i);
            if (go.isNode()) {
                this.identicNode((EdNode)go, enac, enac.getMorphism());
            } else {
                this.identicArc((EdArc)go, enac, enac.getMorphism());
            }
            ++i;
        }
        this.update();
    }

    public EdGraphObject addIdenticToNAC(EdGraphObject graphObject, EdNAC enac) {
        EdGraphObject go = graphObject.isNode() ? this.identicNode((EdNode)graphObject, enac, enac.getMorphism()) : this.identicArc((EdArc)graphObject, enac, enac.getMorphism());
        this.update();
        return go;
    }

    public void makeNACDuetoRHS(EdNAC enac) {
        OrdinaryMorphism morph = enac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        enac.clear();
        this.makeACDuetoRHS(enac, morph);
        this.updateRule();
        this.updateNAC(enac);
    }

    private void makeACDuetoRHS(EdGraph enac, OrdinaryMorphism morph) {
        Vector<EdGraphObject> l;
        HashMap<EdNode, EdNode> map = new HashMap<EdNode, EdNode>();
        int i = 0;
        while (i < this.eRight.getNodes().size()) {
            EdNode enr = this.eRight.getNodes().elementAt(i);
            l = this.getOriginal(enr);
            if (!l.isEmpty()) {
                EdNode en = this.identicNode((EdNode)l.get(0), enac, morph);
                en.setReps(enr.getX(), enr.getY(), enr.isVisible(), false);
                map.put(enr, en);
                int j = 1;
                while (j < l.size()) {
                    EdNode enj = (EdNode)l.get(j);
                    try {
                        this.addCreatedNACMappingToUndo(enj, en);
                        morph.addMapping(enj.getBasisNode(), en.getBasisNode());
                        this.undoManagerEndEdit();
                    }
                    catch (BadMappingException badMappingException) {
                        // empty catch block
                    }
                    ++j;
                }
            } else {
                try {
                    Node bn = enac.getBasisGraph().copyNode(enr.getBasisNode());
                    if (bn.getAttribute() != null) {
                        ((ValueTuple)bn.getAttribute()).unsetValueAsExpr();
                    }
                    EdNode en = enac.addNode(bn, enr.getType());
                    en.setReps(enr.getX(), enr.getY(), enr.isVisible(), false);
                    en.getLNode().setFrozenByDefault(true);
                    enac.addCreatedToUndo(en);
                    enac.undoManagerEndEdit();
                    map.put(enr, en);
                }
                catch (TypeException bn) {
                    // empty catch block
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.eRight.getArcs().size()) {
            EdArc ear = this.eRight.getArcs().elementAt(i);
            l = this.getOriginal(ear);
            if (!l.isEmpty()) {
                EdArc ea = this.identicArc((EdArc)l.get(0), enac, morph);
                ea.setTextOffset(ear.getTextOffset().x, ear.getTextOffset().y);
                if (ear.isLine()) {
                    if (ear.hasAnchor()) {
                        ea.setAnchor(ear.getAnchor());
                        ea.getLArc().setFrozenByDefault(true);
                    }
                } else if (ear.hasAnchor()) {
                    ea.setXY(ear.getX(), ear.getY());
                    ea.setWidth(ear.getWidth());
                    ea.setHeight(ear.getHeight());
                }
                int j = 1;
                while (j < l.size()) {
                    EdArc eaj = (EdArc)l.get(j);
                    try {
                        this.addCreatedNACMappingToUndo(eaj, ea);
                        morph.addMapping(eaj.getBasisArc(), ea.getBasisArc());
                        this.undoManagerEndEdit();
                    }
                    catch (BadMappingException badMappingException) {
                        // empty catch block
                    }
                    ++j;
                }
            } else {
                try {
                    Node bSrc = ((EdNode)map.get(ear.getSource())).getBasisNode();
                    Node bTar = ((EdNode)map.get(ear.getTarget())).getBasisNode();
                    Arc ba = enac.getBasisGraph().copyArc(ear.getBasisArc(), bSrc, bTar);
                    if (ba.getAttribute() != null) {
                        ((ValueTuple)ba.getAttribute()).unsetValueAsExpr();
                    }
                    EdArc ea = enac.addArc(ba, ear.getType());
                    ea.setReps(ear.isDirected(), ear.isVisible(), false);
                    ea.setTextOffset(ear.getTextOffset().x, ear.getTextOffset().y);
                    if (ear.isLine()) {
                        if (ear.hasAnchor()) {
                            ea.setAnchor(ear.getAnchor());
                            ea.getLArc().setFrozenByDefault(true);
                        }
                    } else if (ear.hasAnchor()) {
                        ea.setXY(ear.getX(), ear.getY());
                        ea.setWidth(ear.getWidth());
                        ea.setHeight(ear.getHeight());
                    }
                    enac.addCreatedToUndo(ea);
                    enac.undoManagerEndEdit();
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            ++i;
        }
        map.clear();
        map = null;
    }

    public boolean hasPACs() {
        return !this.itsPACs.isEmpty();
    }

    public Vector<EdPAC> getPACs() {
        return this.itsPACs;
    }

    public EdPAC getPAC(int index) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            if (i == index) {
                return this.itsPACs.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public EdPAC getPAC(String pacname) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.elementAt(i);
            if (pac.getName().equals(pacname)) {
                return pac;
            }
            ++i;
        }
        return null;
    }

    public EdPAC getPAC(OrdinaryMorphism morphism) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.elementAt(i);
            if (pac.getMorphism() == morphism) {
                return pac;
            }
            ++i;
        }
        return null;
    }

    public EdPAC createPAC(String nameStr, boolean isIdentic) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdPAC ePAC = new EdPAC(this.bRule.createPAC(), this.typeSet);
        ePAC.getBasisGraph().setName(nameStr);
        ePAC.setName(nameStr);
        ePAC.setRule(this);
        ePAC.setGraGra(this.eGra);
        ePAC.setEditable(this.eLeft.isEditable());
        ePAC.setUndoManager(this.undoManager);
        if (isIdentic && ePAC.isEditable()) {
            this.identicPAC(ePAC);
        }
        this.itsPACs.addElement(ePAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return ePAC;
    }

    public EdPAC createPAC(OrdinaryMorphism pac) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdPAC ePAC = new EdPAC(pac, this.typeSet);
        ePAC.getBasisGraph().setName(pac.getName());
        ePAC.setName(pac.getName());
        ePAC.setRule(this);
        ePAC.setGraGra(this.eGra);
        ePAC.setUndoManager(this.undoManager);
        this.itsPACs.addElement(ePAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return ePAC;
    }

    public boolean addPAC(EdPAC pac) {
        if (this.bRule == null) {
            return false;
        }
        if (pac.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bRule.addPAC(pac.getMorphism())) {
                Vector<Type> v = pac.getMorphism().getUsedTypes();
                this.bRule.getLeft().getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                pac.setRule(this);
                pac.setGraGra(this.eGra);
                pac.setUndoManager(this.undoManager);
                this.itsPACs.addElement(pac);
                if (this.eGra != null) {
                    this.eGra.setChanged(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void destroyPAC(EdPAC epac) {
        if (this.bRule == null || epac.getMorphism() == null) {
            return;
        }
        epac.getMorphism().deleteObserver(epac);
        this.itsPACs.removeElement(epac);
        this.getBasisRule().destroyPAC(epac.getMorphism());
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
    }

    public void identicPAC(EdPAC epac) {
        OrdinaryMorphism morph = epac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        epac.clear();
        int i = 0;
        while (i < this.eLeft.getNodes().size()) {
            EdNode en = this.eLeft.getNodes().elementAt(i);
            this.identicNode(en, epac, morph);
            ++i;
        }
        int j = 0;
        while (j < this.eLeft.getArcs().size()) {
            EdArc ea = this.eLeft.getArcs().elementAt(j);
            this.identicArc(ea, epac, morph);
            ++j;
        }
        this.updateRule();
        this.updatePAC(epac);
    }

    public void addIdenticToPAC(Vector<EdGraphObject> graphObjects, EdPAC epac) {
        int i = 0;
        while (i < graphObjects.size()) {
            EdGraphObject go = graphObjects.elementAt(i);
            if (go.isNode()) {
                this.identicNode((EdNode)go, epac, epac.getMorphism());
            } else {
                this.identicArc((EdArc)go, epac, epac.getMorphism());
            }
            ++i;
        }
        this.update();
    }

    public EdGraphObject addIdenticToPAC(EdGraphObject graphObject, EdPAC epac) {
        EdGraphObject go = graphObject.isNode() ? this.identicNode((EdNode)graphObject, epac, epac.getMorphism()) : this.identicArc((EdArc)graphObject, epac, epac.getMorphism());
        this.update();
        return go;
    }

    public boolean hasNestedACs() {
        return !this.itsACs.isEmpty();
    }

    public Vector<EdPAC> getNestedACs() {
        return this.itsACs;
    }

    public List<EdNestedApplCond> getEnabledACs() {
        Vector<EdNestedApplCond> list = new Vector<EdNestedApplCond>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsACs.get(i);
            if (ac.getMorphism().isEnabled()) {
                list.add(ac);
            }
            ++i;
        }
        return list;
    }

    public List<EdNestedApplCond> getEnabledNestedACs() {
        Vector<EdNestedApplCond> list = new Vector<EdNestedApplCond>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsACs.get(i);
            if (ac.getMorphism().isEnabled()) {
                list.add(ac);
            }
            list.addAll(ac.getEnabledNestedACs());
            ++i;
        }
        return list;
    }

    public EdPAC getNestedAC(int index) {
        int i = 0;
        while (i < this.itsACs.size()) {
            if (i == index) {
                return this.itsACs.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public EdPAC getNestedAC(String acname) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdPAC ac = this.itsACs.elementAt(i);
            if (ac.getName().equals(acname)) {
                return ac;
            }
            EdNestedApplCond ac1 = ((EdNestedApplCond)ac).getNestedAC(acname);
            if (ac1 != null) {
                return ac1;
            }
            ++i;
        }
        return null;
    }

    public EdPAC getNestedAC(OrdinaryMorphism morphism) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdPAC ac = this.itsACs.elementAt(i);
            if (ac.getMorphism() == morphism) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    public EdNestedApplCond createNestedAC(String nameStr, boolean isIdentic) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdNestedApplCond eAC = new EdNestedApplCond(null, this.bRule.createNestedAC(), this.typeSet);
        eAC.setName(nameStr);
        eAC.setRule(this);
        eAC.setGraGra(this.eGra);
        eAC.setEditable(this.eLeft.isEditable());
        eAC.getBasisGraph().setKind("AC");
        eAC.setUndoManager(this.undoManager);
        eAC.setSourceGraph(this.eLeft);
        if (isIdentic && eAC.isEditable()) {
            this.identicNestedAC(eAC);
        }
        this.itsACs.addElement(eAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eAC;
    }

    public EdNestedApplCond createGACDuetoRHS(String nameStr) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdNestedApplCond eAC = new EdNestedApplCond(null, this.bRule.createNestedAC(), this.typeSet);
        eAC.setName(nameStr);
        eAC.setRule(this);
        eAC.setGraGra(this.eGra);
        eAC.setEditable(this.eLeft.isEditable());
        eAC.getBasisGraph().setKind("AC");
        eAC.setUndoManager(this.undoManager);
        eAC.setSourceGraph(this.eLeft);
        this.makeGACDuetoRHS(eAC);
        this.itsACs.addElement(eAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eAC;
    }

    public EdNestedApplCond createNestedAC(OrdinaryMorphism ac) {
        if (this.bRule == null || !this.editable) {
            return null;
        }
        EdNestedApplCond eAC = new EdNestedApplCond(null, ac, this.typeSet);
        eAC.getBasisGraph().setName(ac.getName());
        eAC.getBasisGraph().setKind("AC");
        eAC.setName(ac.getName());
        eAC.setRule(this);
        eAC.setGraGra(this.eGra);
        eAC.setUndoManager(this.undoManager);
        eAC.setSourceGraph(this.eLeft);
        this.itsACs.addElement(eAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eAC;
    }

    public boolean addNestedAC(EdNestedApplCond ac) {
        if (this.bRule == null) {
            return false;
        }
        if (ac.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bRule.addNestedAC(ac.getMorphism())) {
                Vector<Type> v = ac.getMorphism().getUsedTypes();
                this.bRule.getLeft().getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                ac.getBasisGraph().setKind("AC");
                ac.setRule(this);
                ac.setGraGra(this.eGra);
                ac.setUndoManager(this.undoManager);
                ac.setSourceGraph(this.eLeft);
                this.itsACs.addElement(ac);
                if (this.eGra != null) {
                    this.eGra.setChanged(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void destroyNestedAC(EdNestedApplCond ac) {
        if (this.bRule == null || ac.getMorphism() == null) {
            return;
        }
        ac.getMorphism().deleteObserver(ac);
        this.itsACs.removeElement(ac);
        this.getBasisRule().destroyNestedAC(ac.getMorphism());
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
    }

    public void interactNestedAC(EdGraphObject leftObj, EdGraphObject acObj, NestedApplCond morph) {
        if (this instanceof EdAtomic) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(acObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!";
            return;
        }
        try {
            morph.addMapping(leftObj.getBasisObject(), acObj.getBasisObject());
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\n" + ex.getMessage();
        }
    }

    public void identicNestedAC(EdNestedApplCond ac) {
        if (this instanceof EdAtomic) {
            return;
        }
        OrdinaryMorphism morph = ac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        ac.clear();
        EdGraph srcGraph = ac.getSource() == null ? this.eLeft : ac.getSource();
        int i = 0;
        while (i < srcGraph.getNodes().size()) {
            EdNode en = srcGraph.getNodes().elementAt(i);
            this.identicNode(en, ac, morph);
            ++i;
        }
        int j = 0;
        while (j < srcGraph.getArcs().size()) {
            EdArc ea = srcGraph.getArcs().elementAt(j);
            this.identicArc(ea, ac, morph);
            ++j;
        }
        if (ac.getSource() == this.eLeft) {
            this.updateRule();
        }
        this.updateNestedAC(ac);
    }

    public void addIdenticToNestedAC(Vector<EdGraphObject> graphObjects, EdPAC ac) {
        int i = 0;
        while (i < graphObjects.size()) {
            EdGraphObject go = graphObjects.elementAt(i);
            if (go.isNode()) {
                this.identicNode((EdNode)go, ac, ac.getMorphism());
            } else {
                this.identicArc((EdArc)go, ac, ac.getMorphism());
            }
            ++i;
        }
        this.update();
    }

    public EdGraphObject addIdenticToNestedAC(EdGraphObject graphObject, EdPAC ac) {
        EdGraphObject go = graphObject.isNode() ? this.identicNode((EdNode)graphObject, ac, ac.getMorphism()) : this.identicArc((EdArc)graphObject, ac, ac.getMorphism());
        this.update();
        return go;
    }

    public void makeGACDuetoRHS(EdNestedApplCond egac) {
        if (this instanceof EdAtomic || egac.getSource() != this.eLeft) {
            return;
        }
        OrdinaryMorphism morph = egac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        egac.clear();
        this.makeACDuetoRHS(egac, morph);
        this.updateRule();
        this.updateNestedAC(egac);
    }

    public boolean removeNestedAC(EdPAC ac) {
        if (this instanceof EdAtomic) {
            return false;
        }
        this.itsACs.removeElement(ac);
        this.bRule.removeNestedAC(ac.getMorphism());
        return true;
    }

    private EdNode identicNode(EdNode en, EdGraph eg, OrdinaryMorphism morph) {
        this.badMapping = false;
        this.errMsg = "";
        EdNode cn = null;
        Node bn = null;
        try {
            bn = eg.getBasisGraph().copyNode(en.getBasisNode());
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        if (bn != null) {
            cn = eg.addNode(bn, en.getType());
            cn.setReps(en.getX(), en.getY(), en.isVisible(), false);
            cn.getLNode().setFrozenByDefault(true);
            eg.addCreatedToUndo(cn);
            eg.undoManagerEndEdit();
            try {
                if (morph instanceof Rule) {
                    this.addCreatedMappingToUndo(en, cn);
                } else if (morph instanceof Match) {
                    this.addCreatedMatchMappingToUndo(en, cn);
                } else if (eg.getBasisGraph().isNacGraph()) {
                    this.addCreatedNACMappingToUndo(en, cn);
                } else if (eg.getBasisGraph().isPacGraph()) {
                    this.addCreatedPACMappingToUndo(en, cn);
                } else if (eg.getBasisGraph().isApplCondGraph()) {
                    this.addCreatedACMappingToUndo(en, cn);
                } else {
                    this.addCreatedMappingToUndo(en, cn);
                }
                morph.addMapping(en.getBasisNode(), bn);
                this.undoManagerEndEdit();
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
        return cn;
    }

    private EdArc identicArc(EdArc ea, EdGraph eg, OrdinaryMorphism morph) {
        this.badMapping = false;
        this.errMsg = "";
        EdArc ca = null;
        Arc ba = null;
        GraphObject bSrc = morph.getImage(ea.getBasisArc().getSource());
        GraphObject bTar = morph.getImage(ea.getBasisArc().getTarget());
        try {
            ba = eg.getBasisGraph().copyArc(ea.getBasisArc(), (Node)bSrc, (Node)bTar);
        }
        catch (TypeException e) {
            e.printStackTrace();
        }
        if (ba != null) {
            try {
                ca = eg.addArc(ba, ea.getType());
                ca.setReps(ea.isDirected(), ea.isVisible(), false);
                ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
                if (ea.isLine()) {
                    if (ea.hasAnchor()) {
                        ca.setAnchor(ea.getAnchor());
                        ca.getLArc().setFrozenByDefault(true);
                    }
                } else if (ea.hasAnchor()) {
                    ca.setXY(ea.getX(), ea.getY());
                    ca.setWidth(ea.getWidth());
                    ca.setHeight(ea.getHeight());
                }
                eg.addCreatedToUndo(ca);
                eg.undoManagerEndEdit();
                this.errMsg = "";
                try {
                    if (morph instanceof Rule) {
                        this.addCreatedMappingToUndo(ea, ca);
                    } else if (morph instanceof Match) {
                        this.addCreatedMatchMappingToUndo(ea, ca);
                    } else if (eg.getBasisGraph().isNacGraph()) {
                        this.addCreatedNACMappingToUndo(ea, ca);
                    } else if (eg.getBasisGraph().isPacGraph()) {
                        this.addCreatedPACMappingToUndo(ea, ca);
                    } else if (eg.getBasisGraph().isApplCondGraph()) {
                        this.addCreatedACMappingToUndo(ea, ca);
                    } else {
                        this.addCreatedMappingToUndo(ea, ca);
                    }
                    morph.addMapping(ea.getBasisArc(), ba);
                    this.undoManagerEndEdit();
                }
                catch (BadMappingException ex) {
                    this.badMapping = true;
                    this.errMsg = ex.getMessage();
                }
            }
            catch (TypeException tex) {
                this.badMapping = true;
                this.errMsg = tex.getMessage();
            }
        }
        return ca;
    }

    private EdNode identicNode(EdNode en) {
        this.badMapping = false;
        this.errMsg = "";
        EdRuleScheme rs = this.bRule != null ? this.getGraGra().getRuleScheme(this.bRule) : null;
        EdNode cn = null;
        Node bn = null;
        try {
            bn = this.eRight.getBasisGraph().copyNode(en.getBasisNode());
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        if (bn != null) {
            cn = this.eRight.addNode(bn, en.getType());
            cn.setReps(en.getX(), en.getY(), en.isVisible(), false);
            cn.getLNode().setFrozenByDefault(true);
            this.eRight.addCreatedToUndo(cn);
            this.eRight.undoManagerEndEdit();
            OrdinaryMorphism morph = this.getMorphism();
            try {
                this.addCreatedMappingToUndo(en, cn);
                morph.addMapping(en.getBasisNode(), bn);
                this.undoManagerEndEdit();
                if (rs != null && this.bRule instanceof KernelRule) {
                    rs.propagateAddGraphObjectToMultiRule(cn);
                    this.propagateAddRuleMappingToMultiRule(en, cn);
                }
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
        return cn;
    }

    private EdArc identicArc(EdArc ea) {
        this.badMapping = false;
        this.errMsg = "";
        EdRuleScheme rs = this.bRule != null ? this.getGraGra().getRuleScheme(this.bRule) : null;
        EdArc ca = null;
        Arc ba = null;
        OrdinaryMorphism morph = this.getMorphism();
        GraphObject bSrc = morph.getImage(ea.getBasisArc().getSource());
        GraphObject bTar = morph.getImage(ea.getBasisArc().getTarget());
        try {
            ba = this.eRight.getBasisGraph().copyArc(ea.getBasisArc(), (Node)bSrc, (Node)bTar);
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        if (ba != null) {
            try {
                ca = this.eRight.addArc(ba, ea.getType());
                ca.setReps(ea.isDirected(), ea.isVisible(), false);
                ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
                if (ea.isLine()) {
                    if (ea.hasAnchor()) {
                        ca.setAnchor(ea.getAnchor());
                        ca.getLArc().setFrozenByDefault(true);
                    }
                } else if (ea.hasAnchor()) {
                    ca.setXY(ea.getX(), ea.getY());
                    ca.setWidth(ea.getWidth());
                    ca.setHeight(ea.getHeight());
                }
                this.eRight.addCreatedToUndo(ca);
                this.eRight.undoManagerEndEdit();
                try {
                    this.addCreatedMappingToUndo(ea, ca);
                    morph.addMapping(ea.getBasisArc(), ba);
                    this.undoManagerEndEdit();
                    if (rs != null && this.bRule instanceof KernelRule) {
                        rs.propagateAddGraphObjectToMultiRule(ca);
                        this.propagateAddRuleMappingToMultiRule(ea, ca);
                    }
                }
                catch (BadMappingException ex) {
                    this.badMapping = true;
                    this.errMsg = ex.getMessage();
                }
            }
            catch (TypeException tex) {
                this.badMapping = true;
                this.errMsg = tex.getMessage();
            }
        }
        return ca;
    }

    public boolean canMakeIdenticRule() {
        if (!this.getMorphism().isEmpty()) {
            this.errMsg = "Rule morphism mappings should be removed before.";
            return false;
        }
        if (!this.eRight.getBasisGraph().isEmpty()) {
            this.errMsg = "RHS graph objects should be removed before.";
            return false;
        }
        if (this.bRule instanceof MultiRule && !((MultiRule)this.bRule).getRuleScheme().getKernelRule().getSource().isEmpty()) {
            this.errMsg = "Kernel rule of this RuleScheme should contain empty graphs.";
            return false;
        }
        return true;
    }

    public void identicRule() {
        if (this.eRight.isEditable() && this.canMakeIdenticRule()) {
            this.addLeftToRight(this.eLeft.getNodes(), this.eLeft.getArcs());
            this.updateRule();
        }
    }

    private void addLeftToRight(List<EdNode> nodes, List<EdArc> arcs) {
        int i = 0;
        while (i < nodes.size()) {
            EdNode en = nodes.get(i);
            this.identicNode(en);
            ++i;
        }
        int j = 0;
        while (j < arcs.size()) {
            EdArc ea = arcs.get(j);
            this.identicArc(ea);
            ++j;
        }
    }

    public void addIdenticToRule(Vector<EdGraphObject> graphObjects) {
        if (!this.eRight.isEditable()) {
            return;
        }
        int i = 0;
        while (i < graphObjects.size()) {
            EdGraphObject go = graphObjects.get(i);
            this.addIdentic(go);
            ++i;
        }
        this.updateRule();
    }

    public EdGraphObject addIdentic(EdGraphObject graphObject) {
        EdGraphObject go = null;
        go = graphObject.isNode() ? this.identicNode((EdNode)graphObject) : this.identicArc((EdArc)graphObject);
        return go;
    }

    public List<EdNode> getOwnNodesLeft() {
        Vector<EdNode> list = null;
        if (this.bRule instanceof MultiRule) {
            list = new Vector();
            for (EdNode n : this.eLeft.getNodes()) {
                if (((MultiRule)this.bRule).getEmbeddingLeft().getCodomainObjects().contains(n)) continue;
                list.add(n);
            }
        } else {
            list = this.eLeft.getNodes();
        }
        return list;
    }

    public List<EdNode> getOwnNodesRight() {
        Vector<EdNode> list = null;
        if (this.bRule instanceof MultiRule) {
            list = new Vector();
            for (EdNode n : this.eRight.getNodes()) {
                if (((MultiRule)this.bRule).getEmbeddingRight().getCodomainObjects().contains(n)) continue;
                list.add(n);
            }
        } else {
            list = this.eRight.getNodes();
        }
        return list;
    }

    public List<EdArc> getOwnArcsLeft() {
        Vector<EdArc> list = null;
        if (this.bRule instanceof MultiRule) {
            list = new Vector();
            for (EdArc a : this.eLeft.getArcs()) {
                if (((MultiRule)this.bRule).getEmbeddingLeft().getCodomainObjects().contains(a)) continue;
                list.add(a);
            }
        } else {
            list = this.eLeft.getArcs();
        }
        return list;
    }

    public List<EdArc> getOwnArcsRight() {
        Vector<EdArc> list = null;
        if (this.bRule instanceof MultiRule) {
            list = new Vector();
            for (EdArc a : this.eRight.getArcs()) {
                if (((MultiRule)this.bRule).getEmbeddingRight().getCodomainObjects().contains(a)) continue;
                list.add(a);
            }
        } else {
            list = this.eLeft.getArcs();
        }
        return list;
    }

    public void interactRule(EdGraphObject leftObj, EdGraphObject rightObj) {
        if (!this.editable) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(rightObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!";
            return;
        }
        OrdinaryMorphism morph = this.getMorphism();
        if (morph == null) {
            return;
        }
        try {
            morph.addMapping(leftObj.getBasisObject(), rightObj.getBasisObject());
            this.update();
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\n" + ex.getMessage();
        }
    }

    public void removeRuleMapping(EdGraphObject leftObj) {
        if (!this.editable) {
            return;
        }
        OrdinaryMorphism morph = this.getMorphism();
        if (morph.getImage(leftObj.getBasisObject()) != null) {
            morph.removeMapping(leftObj.getBasisObject());
            this.update();
        }
    }

    public boolean removeRuleMapping(EdGraphObject leftObj, EdGraphObject rightObj) {
        if (leftObj == null || rightObj == null || !this.editable) {
            return false;
        }
        OrdinaryMorphism morph = this.getMorphism();
        if (leftObj.isNode()) {
            if (morph.removeMapping((Node)leftObj.getBasisObject(), (Node)rightObj.getBasisObject())) {
                this.update();
                return true;
            }
        } else if (morph.removeMapping((Arc)leftObj.getBasisObject(), (Arc)rightObj.getBasisObject())) {
            this.update();
            return true;
        }
        return false;
    }

    public void interactNAC(EdGraphObject leftObj, EdGraphObject nacObj, OrdinaryMorphism morph) {
        if (this instanceof EdAtomic) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(nacObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!";
            return;
        }
        try {
            morph.addMapping(leftObj.getBasisObject(), nacObj.getBasisObject());
            this.update();
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\n" + ex.getMessage();
        }
    }

    public void removeNACMapping(EdGraphObject leftObj, OrdinaryMorphism morph) {
        if (this instanceof EdAtomic || !this.editable) {
            return;
        }
        if (morph.getImage(leftObj.getBasisObject()) != null) {
            morph.removeMapping(leftObj.getBasisObject());
            this.update();
        }
    }

    public void removeNACMapping(EdGraphObject leftObj) {
        if (this instanceof EdAtomic || !this.editable) {
            return;
        }
        int i = 0;
        while (i < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.get(i);
            OrdinaryMorphism morph = nac.getMorphism();
            if (morph.getImage(leftObj.getBasisObject()) != null) {
                morph.removeMapping(leftObj.getBasisObject());
            }
            ++i;
        }
        this.update();
    }

    public boolean removeNAC(EdNAC nac) {
        if (this instanceof EdAtomic) {
            return false;
        }
        if (this.bRule.removeNAC(nac.getMorphism())) {
            this.itsNACs.removeElement(nac);
            return true;
        }
        return false;
    }

    public void interactPAC(EdGraphObject leftObj, EdGraphObject pacObj, OrdinaryMorphism morph) {
        if (this instanceof EdAtomic) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (!leftObj.hasSimilarType(pacObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!";
            return;
        }
        try {
            morph.addMapping(leftObj.getBasisObject(), pacObj.getBasisObject());
            this.update();
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\n" + ex.getMessage();
        }
    }

    public void removePACMapping(EdGraphObject leftObj, OrdinaryMorphism morph) {
        if (this instanceof EdAtomic || !this.editable) {
            return;
        }
        if (morph.getImage(leftObj.getBasisObject()) != null) {
            morph.removeMapping(leftObj.getBasisObject());
            this.update();
        }
    }

    public void removeNestedACMapping(EdGraphObject leftObj, NestedApplCond morph) {
        if (this instanceof EdAtomic || !this.editable) {
            return;
        }
        if (morph.getImage(leftObj.getBasisObject()) != null) {
            morph.removeMapping(leftObj.getBasisObject());
            this.update();
        }
    }

    public void removePACMapping(EdGraphObject leftObj) {
        if (this instanceof EdAtomic || !this.editable) {
            return;
        }
        int i = 0;
        while (i < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.get(i);
            OrdinaryMorphism morph = pac.getMorphism();
            if (morph.getImage(leftObj.getBasisObject()) != null) {
                morph.removeMapping(leftObj.getBasisObject());
            }
            ++i;
        }
        this.update();
    }

    public void removeNestedACMapping(EdGraphObject leftObj) {
        if (this instanceof EdAtomic || !this.editable) {
            return;
        }
        int i = 0;
        while (i < this.itsACs.size()) {
            EdPAC pac = this.itsACs.get(i);
            OrdinaryMorphism morph = pac.getMorphism();
            if (morph.getImage(leftObj.getBasisObject()) != null) {
                morph.removeMapping(leftObj.getBasisObject());
            }
            ++i;
        }
        this.update();
    }

    public boolean removePAC(EdPAC pac) {
        if (this instanceof EdAtomic) {
            return false;
        }
        if (this.bRule.removePAC(pac.getMorphism())) {
            this.itsPACs.removeElement(pac);
            return true;
        }
        return false;
    }

    public void autoMatch(Match m) {
        if (m == null) {
            this.errMsg = "Match is NULL.";
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (m.nextCompletion()) {
            if (m.isValid()) {
                this.updateMatch(m, this.eLeft, this.eGra.getGraph());
            } else {
                this.autoMatch(m);
                this.badMapping = true;
                this.errMsg = m.getErrorMsg();
            }
        } else {
            this.badMapping = true;
            this.errMsg = m.getErrorMsg();
        }
    }

    public void interactMatch(EdGraphObject leftObj, EdGraphObject graphObj) {
        Enumeration<GraphObject> origs;
        if (this.bRule.getMatch() == null || !this.editable) {
            return;
        }
        this.badMapping = false;
        this.errMsg = "";
        if (leftObj.getType() != null && !leftObj.hasSimilarType(graphObj)) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\nSource and target objects of the mapping have to have the same type.";
            return;
        }
        MorphCompletionStrategy strategy = this.bRule.getMatch().getCompletionStrategy();
        BitSet activebits = strategy.getProperties();
        if (activebits.get(0) && (origs = this.bRule.getMatch().getInverseImage(graphObj.getBasisObject())).hasMoreElements()) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\nOnly injective mappings are allowed.";
            return;
        }
        try {
            this.bRule.getMatch().addMapping(leftObj.getBasisObject(), graphObj.getBasisObject());
            this.bRule.getMatch().setPartialMorphismCompletion(true);
            if (this.eGra.getGraph() != null) {
                this.updateMatch(this.bRule.getMatch(), this.eLeft, this.eGra.getGraph());
            }
        }
        catch (BadMappingException ex) {
            this.badMapping = true;
            this.errMsg = "Bad mapping!\n" + ex.getMessage();
        }
    }

    public void removeMatchMapping(EdGraphObject leftObj) {
        if (this.bRule == null || this.bRule.getMatch() == null || !this.editable) {
            return;
        }
        if (this.bRule.getMatch().getImage(leftObj.getBasisObject()) != null) {
            this.bRule.getMatch().removeMapping(leftObj.getBasisObject());
            this.bRule.getMatch().removeVariableValue(leftObj.getBasisObject().getAttribute());
            if (this.eGra != null) {
                this.updateMatch(this.bRule.getMatch(), this.eLeft, this.eGra.getGraph());
            }
            this.update();
        }
        if (this.bRule.getMatch().getSize() == 0) {
            this.bRule.getMatch().setPartialMorphismCompletion(false);
        }
    }

    public void destroyMatch() {
        if (this.bRule == null || this.bRule.getMatch() == null) {
            return;
        }
        this.bRule.getMatch().deleteObserver(this.eLeft);
        this.eGra.getBasisGraGra().destroyMatch(this.bRule.getMatch());
        if (this.eGra != null) {
            this.eGra.getGraph().clearMarks();
            int i = 0;
            while (i < this.eLeft.getNodes().size()) {
                EdNode en = this.eLeft.getNodes().elementAt(i);
                this.updateOrig(en);
                ++i;
            }
            int j = 0;
            while (j < this.eLeft.getArcs().size()) {
                EdArc ea = this.eLeft.getArcs().elementAt(j);
                this.updateOrig(ea);
                ++j;
            }
        }
    }

    public void removeMapping(EdGraphObject imageObj, OrdinaryMorphism m) {
        if (imageObj == null || m == null || !this.editable) {
            return;
        }
        Enumeration<GraphObject> originals = m.getInverseImage(imageObj.getBasisObject());
        while (originals.hasMoreElements()) {
            GraphObject original = originals.nextElement();
            m.removeMapping(original);
            this.update();
        }
    }

    public boolean removeMapping(EdGraphObject origObj, EdGraphObject imageObj, OrdinaryMorphism m) {
        if (origObj == null || imageObj == null || m == null || !this.editable) {
            return false;
        }
        if (origObj.isNode()) {
            if (m.removeMapping((Node)origObj.getBasisObject(), (Node)imageObj.getBasisObject())) {
                this.update();
                return true;
            }
        } else if (m.removeMapping((Arc)origObj.getBasisObject(), (Arc)imageObj.getBasisObject())) {
            this.update();
            return true;
        }
        return false;
    }

    public void update() {
        if (this.bRule != null) {
            this.updateRule();
            this.updateNACs();
            this.updatePACs();
            this.updateNestedACs();
            if (this.eGra != null) {
                this.updateMatch(this.bRule.getMatch(), this.eLeft, this.eGra.getGraph());
            }
        } else if (this instanceof EdAtomic) {
            this.updateRule();
        }
    }

    public void updateRule() {
        this.eLeft.clearMarks();
        this.eRight.clearMarks();
        EdNode enL = null;
        EdNode enR = null;
        EdArc eaL = null;
        EdArc eaR = null;
        OrdinaryMorphism bm = this.getMorphism();
        if (bm == null) {
            return;
        }
        Enumeration<GraphObject> domain = bm.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = bm.getImage(bOrig);
            enL = this.eLeft.findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enR = this.eRight.findNode(bImage)) != null) {
                    enR.addMorphismMark(enL.getMorphismMark());
                } else {
                    enL.clearMorphismMark();
                }
            }
            if ((eaL = this.eLeft.findArc(bOrig)) == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaR = this.eRight.findArc(bImage)) != null) {
                eaR.addMorphismMark(eaL.getMorphismMark());
                continue;
            }
            eaL.clearMorphismMark();
        }
    }

    public void updateNAC(EdNAC nacgraph) {
        EdNode enL = null;
        EdNode enNAC = null;
        EdArc eaL = null;
        EdArc eaNAC = null;
        nacgraph.clearMarks();
        Enumeration<GraphObject> domain = nacgraph.getMorphism().getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = nacgraph.getMorphism().getImage(bOrig);
            enL = this.eLeft.findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enNAC = nacgraph.findNode(bImage)) != null) {
                    enNAC.addMorphismMark(enL.getMorphismMark());
                }
            }
            if ((eaL = this.eLeft.findArc(bOrig)) == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaNAC = nacgraph.findArc(bImage)) == null) continue;
            eaNAC.addMorphismMark(eaL.getMorphismMark());
        }
    }

    public void updateNACs() {
        int i = 0;
        while (i < this.itsNACs.size()) {
            EdNAC eNAC = this.itsNACs.elementAt(i);
            this.updateNAC(eNAC);
            ++i;
        }
    }

    public void updatePAC(EdPAC pacgraph) {
        EdNode enL = null;
        EdNode enPAC = null;
        EdArc eaL = null;
        EdArc eaPAC = null;
        pacgraph.clearMarks();
        OrdinaryMorphism pacMorph = pacgraph.getMorphism();
        Enumeration<GraphObject> domain = pacMorph.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = pacMorph.getImage(bOrig);
            enL = this.eLeft.findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enPAC = pacgraph.findNode(bImage)) != null) {
                    enPAC.addMorphismMark(enL.getMorphismMark());
                }
            }
            if ((eaL = this.eLeft.findArc(bOrig)) == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaPAC = pacgraph.findArc(bImage)) == null) continue;
            eaPAC.addMorphismMark(eaL.getMorphismMark());
        }
    }

    public void updatePACs() {
        int i = 0;
        while (i < this.itsPACs.size()) {
            EdPAC ePAC = this.itsPACs.elementAt(i);
            this.updatePAC(ePAC);
            ++i;
        }
    }

    public void updateNestedACs() {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdPAC ac = this.itsACs.get(i);
            this.updateNestedAC((EdNestedApplCond)ac);
            ((EdNestedApplCond)ac).updateNestedACs();
            ++i;
        }
    }

    public void updateNestedAC(EdNestedApplCond ac) {
        EdNode enL = null;
        EdNode enAC = null;
        EdArc eaL = null;
        EdArc eaAC = null;
        if (ac.getSource().getBasisGraph().isApplCondGraph()) {
            ac.getSource().clearMarks();
        }
        ac.clearMarks();
        Enumeration<GraphObject> domain = ac.getMorphism().getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = ac.getMorphism().getImage(bOrig);
            enL = ac.getSource().findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enAC = ac.findNode(bImage)) == null) continue;
                enAC.addMorphismMark(enL.getMorphismMark());
                continue;
            }
            eaL = ac.getSource().findArc(bOrig);
            if (eaL == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaAC = ac.findArc(bImage)) == null) continue;
            eaAC.addMorphismMark(eaL.getMorphismMark());
        }
    }

    private void updateOrig(EdGraphObject leftObj) {
        boolean isOrig = false;
        OrdinaryMorphism bm = this.getMorphism();
        Enumeration<GraphObject> domain = bm.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            if (!leftObj.getBasisObject().equals(bOrig)) continue;
            isOrig = true;
        }
        if (!isOrig) {
            leftObj.clearMorphismMark();
        }
    }

    public void updateMatch() {
        if (this.eGra != null) {
            this.updateMatch(this.bRule.getMatch(), this.eLeft, this.eGra.getGraph());
        }
    }

    private void updateMatch(Match m, EdGraph eOrigGraph, EdGraph eImageGraph) {
        if (eOrigGraph == null || eImageGraph == null) {
            return;
        }
        eImageGraph.clearMarks();
        if (m == null) {
            return;
        }
        EdNode enO = null;
        EdNode enI = null;
        EdArc eaO = null;
        EdArc eaI = null;
        Enumeration<GraphObject> domain = m.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = m.getImage(bOrig);
            enO = eOrigGraph.findNode(bOrig);
            if (enO != null) {
                if (enO.isMorphismMarkEmpty()) {
                    enO.addMorphismMark(enO.getMyKey());
                }
                if ((enI = eImageGraph.findNode(bImage)) == null) continue;
                enI.addMorphismMark(enO.getMorphismMark());
                continue;
            }
            eaO = eOrigGraph.findArc(bOrig);
            if (eaO == null) continue;
            if (eaO.isMorphismMarkEmpty()) {
                eaO.addMorphismMark(eaO.getMyKey());
            }
            if ((eaI = eImageGraph.findArc(bImage)) == null) continue;
            eaI.addMorphismMark(eaO.getMorphismMark());
        }
    }

    public void setMorphismMarks(HashMap<?, ?> marks) {
        EdGraphObject o1;
        GraphObject img;
        EdGraphObject o;
        this.eLeft.setMorphismMarks(marks, true);
        this.eRight.clearMarks();
        Enumeration<EdGraphObject> e = this.eLeft.getNodes().elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            img = this.bRule.getImage(((EdNode)o).getBasisNode());
            if (img == null || (o1 = this.eRight.findGraphObject(img)) == null || o.getMorphismMark().equals("")) continue;
            o1.addMorphismMark(o.getMorphismMark());
        }
        e = this.eLeft.getArcs().elements();
        while (e.hasMoreElements()) {
            o = (EdArc)e.nextElement();
            img = this.bRule.getImage(((EdArc)o).getBasisArc());
            if (img == null || (o1 = this.eRight.findGraphObject(img)) == null || o.getMorphismMark().equals("")) continue;
            o1.addMorphismMark(o.getMorphismMark());
        }
        this.eRight.setMorphismMarks(marks, false);
    }

    public void setMorphismMarks(HashMap<?, ?> marks, EdNAC nacGraph) {
        this.setMorphismMarks(marks);
        if (nacGraph != null) {
            nacGraph.clearMarks();
            OrdinaryMorphism nacMorph = nacGraph.getMorphism();
            Enumeration<GraphObject> e = nacMorph.getCodomain();
            while (e.hasMoreElements()) {
                GraphObject obj = e.nextElement();
                if (!nacMorph.getInverseImage(obj).hasMoreElements()) continue;
                GraphObject objL = nacMorph.getInverseImage(obj).nextElement();
                EdGraphObject goL = this.eLeft.findGraphObject(objL);
                EdGraphObject goN = nacGraph.findGraphObject(obj);
                goN.clearMorphismMark();
                goN.addMorphismMark(goL.getMorphismMark());
            }
            nacGraph.setMorphismMarks(marks, false);
        }
    }

    public void setMorphismMarks(HashMap<?, ?> marks, EdPAC pacGraph) {
        this.setMorphismMarks(marks);
        if (pacGraph != null) {
            pacGraph.clearMarks();
            OrdinaryMorphism pacMorph = pacGraph.getMorphism();
            Enumeration<GraphObject> e = pacMorph.getCodomain();
            while (e.hasMoreElements()) {
                GraphObject obj = e.nextElement();
                if (!pacMorph.getInverseImage(obj).hasMoreElements()) continue;
                GraphObject objL = pacMorph.getInverseImage(obj).nextElement();
                EdGraphObject goL = this.eLeft.findGraphObject(objL);
                EdGraphObject goP = pacGraph.findGraphObject(obj);
                goP.clearMorphismMark();
                goP.addMorphismMark(goL.getMorphismMark());
            }
            pacGraph.setMorphismMarks(marks, false);
        }
    }

    public boolean isBadMapping() {
        return this.badMapping;
    }

    public String getMsg() {
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        return this.errMsg;
    }

    public boolean deleteGraphObjectsOfType(EdType t, boolean addToUndo) {
        List<EdGraphObject> list = this.eLeft.getGraphObjectsOfType(t);
        if (addToUndo) {
            int i = 0;
            while (i < list.size()) {
                EdGraphObject rgo;
                EdGraphObject go = list.get(i);
                if (!(this.getBasisRule().getRuleScheme() != null && this.getBasisRule().getRuleScheme().getKernelRule() != this.bRule && ((MultiRule)this.bRule).isTargetOfEmbeddingLeft(go.getBasisObject()) || (rgo = this.eRight.findGraphObject(this.getBasisRule().getImage(go.getBasisObject()))) == null)) {
                    this.addDeletedMappingToUndo(go, rgo);
                    this.undoManagerEndEdit();
                }
                ++i;
            }
        }
        boolean allDone = true;
        int j = 0;
        while (j < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.get(j);
            if (!nac.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.get(j);
            if (!pac.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsACs.get(j);
            if (!ac.deleteGraphObjectsOfType(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        if (!this.eLeft.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            allDone = false;
        }
        if (!this.eRight.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            allDone = false;
        }
        return allDone;
    }

    public boolean deleteGraphObjectsOfType(EdGraphObject tgo, boolean addToUndo) {
        EdGraphObject rgo;
        EdGraphObject go;
        int i;
        List<EdGraphObject> list = this.eLeft.getGraphObjectsOfType(tgo);
        if (addToUndo) {
            int i2 = 0;
            while (i2 < list.size()) {
                EdGraphObject go2 = list.get(i2);
                EdGraphObject rgo2 = this.eRight.findGraphObject(this.getBasisRule().getImage(go2.getBasisObject()));
                if (rgo2 != null) {
                    this.addDeletedMappingToUndo(go2, rgo2);
                    this.undoManagerEndEdit();
                }
                ++i2;
            }
        }
        boolean allDone = true;
        int j = 0;
        while (j < this.itsNACs.size()) {
            EdNAC nac = this.itsNACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < list.size()) {
                    go = list.get(i);
                    rgo = nac.findGraphObject(nac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.addDeletedNACMappingToUndo(go, rgo);
                        this.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!nac.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsPACs.size()) {
            EdPAC pac = this.itsPACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < list.size()) {
                    go = list.get(i);
                    rgo = pac.findGraphObject(pac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.addDeletedPACMappingToUndo(go, rgo);
                        this.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!pac.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < list.size()) {
                    go = list.get(i);
                    rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.addDeletedACMappingToUndo(go, rgo);
                        this.undoManagerEndEdit();
                    }
                    ++i;
                }
                ac.storeMappingOfGraphObjectsOfType(tgo, (EdGraph)ac);
            }
            if (!ac.deleteGraphObjectsOfType(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        if (!this.eLeft.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
            allDone = false;
        }
        if (!this.eRight.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
            allDone = false;
        }
        return allDone;
    }

    public void setLayoutByIndexFrom(EdRule er) {
        this.setLayoutByIndexFrom(er, false);
    }

    public void setLayoutByIndexFrom(EdRule er, boolean inverse) {
        EdGraph ac;
        int n;
        if (inverse) {
            this.eLeft.setLayoutByIndex(er.getRight(), true);
            this.eRight.setLayoutByIndex(er.getLeft(), true);
        } else {
            this.eLeft.setLayoutByIndex(er.getLeft(), true);
            this.eRight.setLayoutByIndex(er.getRight(), true);
        }
        if (this.itsACs.size() == er.getNestedACs().size()) {
            n = 0;
            while (n < this.itsACs.size()) {
                ac = this.itsACs.get(n);
                ac.setLayoutByIndex(er.getNestedACs().get(n), true);
                ++n;
            }
        } else {
            n = 0;
            while (n < this.itsACs.size()) {
                ac = this.itsACs.get(n);
                ac.setLayoutByIndex(this.getLeft(), true);
                ++n;
            }
        }
        if (this.itsNACs.size() == er.getNACs().size()) {
            n = 0;
            while (n < this.itsNACs.size()) {
                ac = this.itsNACs.get(n);
                ac.setLayoutByIndex(er.getNACs().get(n), true);
                ++n;
            }
        } else {
            n = 0;
            while (n < this.itsNACs.size()) {
                ac = this.itsNACs.get(n);
                ac.setLayoutByIndex(this.getLeft(), true);
                ++n;
            }
        }
        if (this.itsPACs.size() == er.getPACs().size()) {
            n = 0;
            while (n < this.itsPACs.size()) {
                ac = this.itsPACs.get(n);
                ac.setLayoutByIndex(er.getPACs().get(n), true);
                ++n;
            }
        } else {
            n = 0;
            while (n < this.itsPACs.size()) {
                ac = this.itsPACs.get(n);
                ac.setLayoutByIndex(this.getLeft(), true);
                ++n;
            }
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.bRule, this) && this.animated) {
            this.setAnimated(true);
            h.addAttr("animated", "true");
        }
        h.addObject("", this.eLeft, true);
        h.addObject("", this.eRight, true);
        int j = 0;
        while (j < this.itsNACs.size()) {
            h.addObject("", this.itsNACs.elementAt(j), true);
            ++j;
        }
        j = 0;
        while (j < this.itsPACs.size()) {
            h.addObject("", this.itsPACs.elementAt(j), true);
            ++j;
        }
        j = 0;
        while (j < this.itsACs.size()) {
            h.addObject("", this.itsACs.elementAt(j), true);
            ++j;
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        EdGraph ac;
        h.peekObject(this.bRule, this);
        String animatedAttr = h.readAttr("animated");
        if ("true".equals(animatedAttr)) {
            this.setAnimated(true);
        }
        h.enrichObject(this.eLeft);
        h.enrichObject(this.eRight);
        int j = 0;
        while (j < this.itsNACs.size()) {
            ac = this.itsNACs.elementAt(j);
            h.enrichObject(ac);
            ++j;
        }
        j = 0;
        while (j < this.itsPACs.size()) {
            ac = this.itsPACs.elementAt(j);
            h.enrichObject(ac);
            ++j;
        }
        j = 0;
        while (j < this.itsACs.size()) {
            ac = (EdNestedApplCond)this.itsACs.get(j);
            h.enrichObject(ac);
            ++j;
        }
        this.updateRule();
        this.updateNACs();
        this.updatePACs();
        this.updateNestedACs();
    }
}

