/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.info.RuleChangeInfo;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.staticanalysis.NodeEquivalence;

public class GiraphRuleData {
    public final Rule rule;
    public final RuleChangeInfo changeInfo;
    public List<MatchingStep> matchingSteps;
    public List<Node> orderedLhsNodes;
    public List<Node> requiredNodes;
    public Map<Node, NodeEquivalence> requiredNodesEquivalences;

    public GiraphRuleData(Rule rule) throws Exception {
        this.rule = this.preprocessPrule(rule);
        this.changeInfo = new RuleChangeInfo(this.rule);
        this.matchingSteps = this.generateMatchingSteps();
        if (this.matchingSteps == null) {
            throw new RuntimeException("Cannot generate matching data for rule " + rule.getName());
        }
        this.generateOrderedLhsNodes();
    }

    private Rule preprocessPrule(Rule rule) {
        boolean changed;
        Rule multiRule = (Rule)rule.getMultiRules().get(0);
        Rule copy = (Rule)EcoreUtil.copy((EObject)multiRule);
        copy.setName(rule.getName());
        multiRule = null;
        rule = null;
        this.requiredNodes = new ArrayList<Node>();
        for (Node node : copy.getActionNodes(null)) {
            Action action = node.getAction();
            if (action.getType() != Action.Type.REQUIRE) continue;
            this.requiredNodes.add(node);
        }
        this.requiredNodesEquivalences = new HashMap<Node, NodeEquivalence>();
        TreeIterator it = copy.eAllContents();
        while (it.hasNext()) {
            NestedCondition pac;
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Graph) || (pac = copy.getLhs().getPAC(((Graph)obj).getName())) == null) continue;
            List equivalences = NodeEquivalence.computeEquivalences((Graph)pac.getConclusion());
            Iterator iterator = equivalences.iterator();
            while (iterator.hasNext()) {
                NodeEquivalence equi = (NodeEquivalence)iterator.next();
                int i = 0;
                while (i < equi.size()) {
                    if (pac.getMappings().getOrigin((Node)equi.get(i)) != null) {
                        equi.remove(i--);
                    }
                    ++i;
                }
                if (equi.size() <= 1) continue;
                for (Node node : equi) {
                    this.requiredNodesEquivalences.put(node, equi);
                }
            }
        }
        block5: do {
            Action action;
            changed = false;
            for (Node node : copy.getActionNodes(null)) {
                action = node.getAction();
                if (action.getType() != Action.Type.REQUIRE) continue;
                node.setAction(new Action(Action.Type.PRESERVE));
                changed = true;
                break;
            }
            for (Edge edge : copy.getActionEdges(null)) {
                action = edge.getAction();
                if (action.getType() != Action.Type.REQUIRE) continue;
                edge.setAction(new Action(Action.Type.PRESERVE));
                changed = true;
                continue block5;
            }
        } while (changed);
        int i = 0;
        while (i < this.requiredNodes.size()) {
            Node node = this.requiredNodes.get(i);
            if (!node.getGraph().isLhs()) {
                Node lhsNode = ((NestedCondition)node.getGraph().eContainer()).getMappings().getOrigin(node);
                this.requiredNodes.set(i, lhsNode);
                if (this.requiredNodesEquivalences.containsKey(node)) {
                    this.requiredNodesEquivalences.put(lhsNode, this.requiredNodesEquivalences.get(node));
                    this.requiredNodesEquivalences.remove(node);
                }
                for (NodeEquivalence equi : this.requiredNodesEquivalences.values()) {
                    int j = 0;
                    while (j < equi.size()) {
                        if (equi.get(j) == node) {
                            equi.set(j, (Object)lhsNode);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return copy;
    }

    private List<MatchingStep> generateMatchingSteps() {
        Node last;
        ArrayList<Node> nodesToMatch = new ArrayList<Node>((Collection<Node>)this.rule.getLhs().getNodes());
        ArrayList<MatchingStep> result = new ArrayList<MatchingStep>();
        block0: while (!nodesToMatch.isEmpty()) {
            List<MatchingStep> newSteps = this.getLongestMatchingSteps(nodesToMatch);
            Node joinNode = null;
            int i = 0;
            while (i < newSteps.size()) {
                for (MatchingStep matchingStep : result) {
                    if (matchingStep.node != newSteps.get((int)i).node) continue;
                    joinNode = matchingStep.node;
                    break;
                }
                if (joinNode != null) break;
                ++i;
            }
            if (joinNode != null && !result.isEmpty()) {
                ((MatchingStep)result.get((int)(result.size() - 1))).sendBackTo = joinNode;
            }
            for (MatchingStep step : newSteps) {
                step.keepMatchesOf = joinNode;
                result.add(step);
                nodesToMatch.remove(step.node);
                if (step.edge != null) {
                    nodesToMatch.remove(step.edge.getTarget());
                }
                if (step.node != joinNode) continue;
                step.edge = null;
                step.isJoin = true;
                continue block0;
            }
        }
        ArrayList missingEdges = new ArrayList(this.rule.getLhs().getEdges());
        for (MatchingStep step : result) {
            if (step.edge == null) continue;
            missingEdges.remove(step.edge);
        }
        for (Edge edge : missingEdges) {
            MatchingStep matchingStep = (MatchingStep)result.get(result.size() - 1);
            matchingStep.sendBackTo = edge.getSource();
            result.add(new MatchingStep(edge.getSource(), edge, null, edge.getTarget(), false, false, false));
        }
        if (!result.isEmpty() && this.requiredNodes.contains(last = ((MatchingStep)result.get((int)(result.size() - 1))).node)) {
            Node target = null;
            for (MatchingStep matchingStep : result) {
                if (this.requiredNodes.contains(matchingStep.node)) continue;
                target = matchingStep.node;
                break;
            }
            if (target != null) {
                ((MatchingStep)result.get((int)(result.size() - 1))).sendBackTo = target;
                result.add(new MatchingStep(target, null, null, null, false, false, false));
            }
        }
        return result;
    }

    private List<MatchingStep> getLongestMatchingSteps(List<Node> nodes) {
        List<MatchingStep> result = null;
        for (Node start : nodes) {
            List<MatchingStep> matchingSteps = this.getMatchingSteps(this.rule, start);
            if (matchingSteps == null || result != null && matchingSteps.size() <= result.size()) continue;
            result = matchingSteps;
        }
        return result;
    }

    private List<MatchingStep> getMatchingSteps(Rule rule, Node start) {
        ArrayList<MatchingStep> matchingSteps = new ArrayList<MatchingStep>();
        if (start.getOutgoing().isEmpty()) {
            matchingSteps.add(new MatchingStep(start, null, null, null, true, true, false));
        }
        ArrayDeque<Edge> edgeQueue = new ArrayDeque<Edge>();
        edgeQueue.addAll((Collection<Edge>)start.getOutgoing());
        HashSet<Node> lockedNodes = new HashSet<Node>();
        HashSet<Edge> visitedEdges = new HashSet<Edge>();
        while (!edgeQueue.isEmpty()) {
            Edge edge = (Edge)edgeQueue.pop();
            boolean isMatching = lockedNodes.add(edge.getSource());
            Node sendBackTo = null;
            if (lockedNodes.contains(edge.getTarget()) && !edgeQueue.isEmpty()) {
                sendBackTo = ((Edge)edgeQueue.getFirst()).getSource();
            }
            Node verifyEdgeTo = null;
            if (lockedNodes.contains(edge.getTarget())) {
                verifyEdgeTo = edge.getTarget();
            }
            matchingSteps.add(new MatchingStep(edge.getSource(), edge, sendBackTo, verifyEdgeTo, lockedNodes.size() == 1, isMatching, false));
            visitedEdges.add(edge);
            if (edge.getTarget().getOutgoing().isEmpty()) {
                if (!lockedNodes.contains(edge.getTarget())) {
                    sendBackTo = null;
                    if (!edgeQueue.isEmpty()) {
                        sendBackTo = ((Edge)edgeQueue.getFirst()).getSource();
                    }
                    matchingSteps.add(new MatchingStep(edge.getTarget(), null, sendBackTo, null, false, true, false));
                    lockedNodes.add(edge.getTarget());
                }
            } else {
                for (Edge succ : edge.getTarget().getOutgoing()) {
                    if (visitedEdges.contains(succ) || edgeQueue.contains(succ)) continue;
                    edgeQueue.push(succ);
                }
            }
            lockedNodes.add(edge.getSource());
        }
        return matchingSteps;
    }

    private void generateOrderedLhsNodes() {
        this.orderedLhsNodes = new ArrayList<Node>();
        for (MatchingStep step : this.matchingSteps) {
            if (step.node == null || this.orderedLhsNodes.contains(step.node)) continue;
            this.orderedLhsNodes.add(step.node);
        }
        for (NodeEquivalence equi : this.requiredNodesEquivalences.values()) {
            Collections.sort(equi, new Comparator<Node>(){

                @Override
                public int compare(Node x, Node y) {
                    return GiraphRuleData.this.orderedLhsNodes.indexOf(x) - GiraphRuleData.this.orderedLhsNodes.indexOf(y);
                }
            });
        }
    }

    public static class MatchingStep {
        public Node node;
        public Edge edge;
        public Node verifyEdgeTo;
        public Node sendBackTo;
        public Node keepMatchesOf;
        public boolean isStart;
        public boolean isMatching;
        public boolean isJoin;

        public MatchingStep(Node node, Edge edge, Node sendBackTo, Node verifyEdgeTo, boolean isStart, boolean isMatching, boolean isJoin) {
            this.node = node;
            this.edge = edge;
            this.verifyEdgeTo = verifyEdgeTo;
            this.sendBackTo = sendBackTo;
            this.isStart = isStart;
            this.isMatching = isMatching;
            this.isJoin = isJoin;
        }
    }
}

