/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import junit.framework.TestCase;
import org.eclipse.core.text.StringMatcher;

public class StringMatcherTest
extends TestCase {
    public void test_caseSensitive_question_114105() {
        StringMatcher matcher = new StringMatcher("aba?aba", false, false);
        StringMatcherTest.assertTrue((boolean)matcher.match("abaaaba"));
        StringMatcherTest.assertTrue((boolean)matcher.match("abababa"));
        StringMatcherTest.assertTrue((boolean)matcher.match("abacaba"));
        StringMatcherTest.assertTrue((boolean)matcher.match("abaAaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abaaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abbaaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abAAaba"));
    }

    public void test_caseInsensitive_question_114105() {
        StringMatcher matcher = new StringMatcher("aba?aba", true, false);
        StringMatcherTest.assertTrue((boolean)matcher.match("abacaba"));
        StringMatcherTest.assertTrue((boolean)matcher.match("ABAaABA"));
        StringMatcherTest.assertTrue((boolean)matcher.match("ABAAABA"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abaaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("ABAABA"));
        StringMatcherTest.assertFalse((boolean)matcher.match("ABBaaba"));
    }

    public void test_caseSensitive_asterisk_114105() {
        StringMatcher matcher = new StringMatcher("aba*aba", false, false);
        StringMatcherTest.assertTrue((boolean)matcher.match("abaaaba"));
        StringMatcherTest.assertTrue((boolean)matcher.match("abababa"));
        StringMatcherTest.assertTrue((boolean)matcher.match("abaaba"));
        StringMatcherTest.assertTrue((boolean)matcher.match("abaABCaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abAaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abbaaba"));
    }

    public void test_caseInsensitive_asterisk_114105() {
        StringMatcher matcher = new StringMatcher("aba*aba", true, false);
        StringMatcherTest.assertTrue((boolean)matcher.match("abacaba"));
        StringMatcherTest.assertTrue((boolean)matcher.match("ABAABA"));
        StringMatcherTest.assertTrue((boolean)matcher.match("ABAabcaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("abbaaba"));
        StringMatcherTest.assertFalse((boolean)matcher.match("ABBAaba"));
    }
}

