/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.util.XmlConfig;

public class XmlConfigTest
extends TestCase {
    private static final String PLUGIN_ID = "org.eclipse.emf.validation.tests";
    private static final String TEST_ID = "test-include";
    private static final String TEST_NAME = "Test Include";

    private IConfigurationElement getFixture() {
        IExtension[] exts = Platform.getExtensionRegistry().getExtensions(PLUGIN_ID);
        int i = 0;
        while (i < exts.length) {
            if (exts[i].getSimpleIdentifier() != null && exts[i].getSimpleIdentifier().equals(TEST_ID)) {
                return exts[i].getConfigurationElements()[0];
            }
            ++i;
        }
        return null;
    }

    public void test_parseConstraintsWithIncludes() {
        IConfigurationElement constraints = this.getFixture();
        IConfigurationElement newConstraints = null;
        try {
            newConstraints = XmlConfig.parseConstraintsWithIncludes((IConfigurationElement)constraints);
        }
        catch (CoreException e) {
            XmlConfigTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        XmlConfigTest.assertNotSame((Object)constraints, (Object)newConstraints);
        XmlConfigTest.assertEquals((String)constraints.getName(), (String)newConstraints.getName());
        IConfigurationElement[] children = newConstraints.getChildren();
        XmlConfigTest.assertEquals((int)1, (int)children.length);
        XmlConfigTest.assertEquals((String)"constraint", (String)children[0].getName());
        XmlConfigTest.assertEquals((String)TEST_ID, (String)children[0].getAttribute("id"));
        XmlConfigTest.assertEquals((String)"OCL", (String)children[0].getAttribute("lang"));
        XmlConfigTest.assertEquals((String)"1", (String)children[0].getAttribute("statusCode"));
        XmlConfigTest.assertEquals((String)"true", (String)children[0].getValue());
        IConfigurationElement[] grandchildren = children[0].getChildren();
        XmlConfigTest.assertEquals((int)1, (int)grandchildren.length);
        IConfigurationElement message = grandchildren[0];
        XmlConfigTest.assertEquals((String)"message", (String)message.getName());
        XmlConfigTest.assertEquals((String)"This is a message.", (String)message.getValue());
    }

    public void test_constraintLocalization() {
        IConfigurationElement constraints = this.getFixture();
        IConfigurationElement newConstraints = null;
        try {
            newConstraints = XmlConfig.parseConstraintsWithIncludes((IConfigurationElement)constraints);
        }
        catch (CoreException e) {
            XmlConfigTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        IConfigurationElement[] children = newConstraints.getChildren();
        XmlConfigTest.assertTrue((String)"Not enough child elements", (children.length > 0 ? 1 : 0) != 0);
        XmlConfigTest.assertEquals((String)TEST_NAME, (String)children[0].getAttribute("name"));
    }
}

