/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleState;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_LIFECYCLE, LifecycleUtil.class);

    private LifecycleUtil() {
    }

    public static ILifecycleState getLifecycleState(Object object) {
        if (object instanceof ILifecycle.Introspection) {
            return ((ILifecycle.Introspection)object).getLifecycleState();
        }
        return ILifecycleState.ACTIVE;
    }

    public static boolean isActive(Object object) {
        if (object instanceof ILifecycle.Introspection) {
            return ((ILifecycle.Introspection)object).isActive();
        }
        return object != null;
    }

    public static void activate(Object object) throws LifecycleException {
        LifecycleUtil.activate(object, false);
    }

    public static void activate(Object object, boolean useAnnotation) throws LifecycleException {
        if (object instanceof ILifecycle) {
            ((ILifecycle)object).activate();
        } else if (object != null && useAnnotation) {
            LifecycleUtil.invokeAnnotation(object, Activator.class);
        }
    }

    public static Exception activateSilent(Object object) {
        return LifecycleUtil.activateSilent(object, false);
    }

    public static Exception activateSilent(Object object, boolean useAnnotation) {
        try {
            LifecycleUtil.activate(object, useAnnotation);
            return null;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
            return ex;
        }
    }

    public static boolean waitForActive(Object object, long millis) {
        block6: {
            Lifecycle lifecycle;
            block7: {
                try {
                    if (!(object instanceof ILifecycle)) break block6;
                    lifecycle = (Lifecycle)object;
                    if (!lifecycle.isActive()) break block7;
                    return true;
                }
                catch (Exception ex) {
                    throw WrappedException.wrap(ex);
                }
            }
            final CountDownLatch latch = new CountDownLatch(1);
            LifecycleEventAdapter adapter = new LifecycleEventAdapter(){

                protected void onActivated(ILifecycle lifecycle) {
                    latch.countDown();
                }
            };
            try {
                lifecycle.addListener(adapter);
                latch.await(millis, TimeUnit.MILLISECONDS);
            }
            finally {
                lifecycle.removeListener(adapter);
            }
            return lifecycle.isActive();
        }
        return true;
    }

    public static Exception deactivate(Object object) {
        return LifecycleUtil.deactivate(object, false);
    }

    public static Exception deactivate(Object object, boolean useAnnotation) {
        if (object instanceof ILifecycle) {
            return ((ILifecycle)object).deactivate();
        }
        if (object != null && useAnnotation) {
            LifecycleUtil.invokeAnnotation(object, Deactivator.class);
        }
        return null;
    }

    public static void deactivateNoisy(Object object) throws LifecycleException {
        LifecycleUtil.deactivateNoisy(object, false);
    }

    public static void deactivateNoisy(Object object, boolean useAnnotation) throws LifecycleException {
        Exception ex = LifecycleUtil.deactivate(object, useAnnotation);
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex != null) {
            throw new LifecycleException(ex);
        }
    }

    private static <T extends Annotation> void invokeAnnotation(Object object, Class<T> annotationClass) {
        Class<?> c = object.getClass();
        while (c != Object.class) {
            Method[] methods;
            Method[] methodArray = methods = c.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                T annotation;
                Method method = methodArray[n2];
                if (method.getParameterTypes().length == 0 && (annotation = method.getAnnotation(annotationClass)) != null) {
                    boolean propagate;
                    LifecycleUtil.invokeMethod(object, method);
                    boolean bl = propagate = annotationClass == Activator.class ? ((Activator)annotation).propagate() : ((Deactivator)annotation).propagate();
                    if (!propagate) break;
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
    }

    private static Object invokeMethod(Object object, Method method) {
        block6: {
            try {
                return method.invoke(object, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    method.setAccessible(true);
                    return method.invoke(object, null);
                }
                catch (Exception ex) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace(ex);
                    }
                }
            }
            catch (Exception ex) {
                if (!TRACER.isEnabled()) break block6;
                TRACER.trace(ex);
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Activator {
        public boolean propagate() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Deactivator {
        public boolean propagate() default true;
    }
}

