/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.buddies.internal.server.bundle.OM;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddyAddedNotification;
import org.eclipse.net4j.buddies.server.IBuddyAdmin;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class OpenSessionIndication
extends IndicationWithResponse {
    private IAccount account;
    private IBuddy[] buddies;

    protected short getSignalID() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indicating(ExtendedDataInputStream in) throws IOException {
        String userID = in.readString();
        String password = in.readString();
        int size = in.readInt();
        String[] facilityTypes = new String[size];
        int i = 0;
        while (i < size) {
            facilityTypes[i] = in.readString();
            ++i;
        }
        IBuddyAdmin iBuddyAdmin = IBuddyAdmin.INSTANCE;
        synchronized (iBuddyAdmin) {
            this.buddies = IBuddyAdmin.INSTANCE.getBuddies();
            ISession session = IBuddyAdmin.INSTANCE.openSession(this.getProtocol().getChannel(), userID, password, facilityTypes);
            if (session != null) {
                this.account = session.getSelf().getAccount();
            } else {
                OM.LOG.info("User denied: " + userID);
            }
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        ProtocolUtil.writeAccount((ExtendedDataOutputStream)out, (IAccount)this.account);
        if (this.account != null) {
            ArrayList<IChannel> channels = new ArrayList<IChannel>();
            out.writeInt(this.buddies.length);
            IBuddy[] iBuddyArray = this.buddies;
            int n = this.buddies.length;
            int n2 = 0;
            while (n2 < n) {
                IBuddy buddy = iBuddyArray[n2];
                out.writeString(buddy.getUserID());
                ISession buddySession = IBuddyAdmin.INSTANCE.getSession(buddy);
                if (buddySession != null) {
                    channels.add(buddySession.getChannel());
                }
                ++n2;
            }
            for (IChannel channel : channels) {
                try {
                    new BuddyAddedNotification(channel, this.account.getUserID()).send();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }
}

