/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IDBStoreWriter;
import org.eclipse.emf.cdo.server.internal.db.ClassMapping;
import org.eclipse.emf.cdo.server.internal.db.HorizontalMappingStrategy;

public class HorizontalClassMapping
extends ClassMapping {
    public HorizontalClassMapping(HorizontalMappingStrategy mappingStrategy, CDOClass cdoClass) {
        super(mappingStrategy, cdoClass, cdoClass.getAllFeatures());
    }

    public HorizontalMappingStrategy getMappingStrategy() {
        return (HorizontalMappingStrategy)super.getMappingStrategy();
    }

    public void writeRevision(IDBStoreWriter storeWriter, CDORevision revision) {
        super.writeRevision(storeWriter, revision);
        if (revision.getVersion() == 1) {
            CDOID id = revision.getID();
            CDOClass type = revision.getCDOClass();
            this.getMappingStrategy().getObjectTypeCache().putObjectType(storeWriter, id, type);
        }
    }

    protected boolean hasFullRevisionInfo() {
        return true;
    }
}

