/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class Signal
implements Runnable {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, Signal.class);
    private SignalProtocol protocol;
    private int correlationID;
    private BufferInputStream bufferInputStream;
    private BufferOutputStream bufferOutputStream;

    protected Signal() {
    }

    public SignalProtocol getProtocol() {
        return this.protocol;
    }

    protected final int getCorrelationID() {
        return this.correlationID;
    }

    protected final BufferInputStream getBufferInputStream() {
        return this.bufferInputStream;
    }

    protected final BufferOutputStream getBufferOutputStream() {
        return this.bufferOutputStream;
    }

    protected InputStream wrapInputStream(InputStream in) {
        try {
            return this.protocol.wrapInputStream(in);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    protected OutputStream wrapOutputStream(OutputStream out) {
        try {
            return this.protocol.wrapOutputStream(out);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    protected void finishInputStream(InputStream in) {
        try {
            this.protocol.finishInputStream(in);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    protected void finishOutputStream(OutputStream out) {
        try {
            this.protocol.finishOutputStream(out);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public final void run() {
        String threadName = null;
        try {
            try {
                if (OM.SET_SIGNAL_THREAD_NAME) {
                    threadName = this.getClass().getSimpleName();
                    Thread.currentThread().setName(threadName);
                }
                this.runSync();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                if (threadName != null) {
                    Thread.currentThread().setName(String.valueOf(threadName) + "(FINISHED)");
                }
            }
        }
        finally {
            if (threadName != null) {
                Thread.currentThread().setName(String.valueOf(threadName) + "(FINISHED)");
            }
        }
    }

    protected void runSync() throws Exception {
        try {
            try {
                this.execute(this.bufferInputStream, this.bufferOutputStream);
            }
            catch (EOFException ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace((Throwable)ex);
                }
                throw new TimeoutException("Timeout");
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        finally {
            this.getProtocol().stopSignal(this);
        }
    }

    protected abstract short getSignalID();

    protected abstract void execute(BufferInputStream var1, BufferOutputStream var2) throws Exception;

    void setProtocol(SignalProtocol protocol) {
        this.protocol = protocol;
    }

    void setCorrelationID(int correlationID) {
        this.correlationID = correlationID;
    }

    void setBufferInputStream(BufferInputStream inputStream) {
        this.bufferInputStream = inputStream;
    }

    void setBufferOutputStream(BufferOutputStream outputStream) {
        this.bufferOutputStream = outputStream;
    }
}

