/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.channel;

import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.util.concurrent.IWorkSerializer;
import org.eclipse.net4j.util.concurrent.QueueWorkerWorkSerializer;
import org.eclipse.net4j.util.concurrent.SynchronousWorkSerializer;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
extends Lifecycle
implements InternalChannel {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CHANNEL, Channel.class);
    private int channelID;
    private IChannelMultiplexer channelMultiplexer;
    private short channelIndex = Short.MIN_VALUE;
    private ExecutorService receiveExecutor;
    private IBufferHandler receiveHandler;
    private IWorkSerializer receiveSerializer;
    private Queue<IBuffer> sendQueue;

    @Override
    public int getChannelID() {
        return this.channelID;
    }

    @Override
    public void setChannelID(int channelID) {
        this.channelID = channelID;
    }

    @Override
    public IChannelMultiplexer getChannelMultiplexer() {
        return this.channelMultiplexer;
    }

    @Override
    public void setChannelMultiplexer(IChannelMultiplexer channelMultiplexer) {
        this.channelMultiplexer = channelMultiplexer;
    }

    @Override
    public short getChannelIndex() {
        return this.channelIndex;
    }

    @Override
    public void setChannelIndex(short channelIndex) {
        if (channelIndex == Short.MIN_VALUE) {
            throw new IllegalArgumentException("channelIndex == INVALID_CHANNEL_ID");
        }
        this.channelIndex = channelIndex;
    }

    @Override
    public ExecutorService getReceiveExecutor() {
        return this.receiveExecutor;
    }

    @Override
    public void setReceiveExecutor(ExecutorService receiveExecutor) {
        this.receiveExecutor = receiveExecutor;
    }

    @Override
    public IBufferHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    @Override
    public void setReceiveHandler(IBufferHandler receiveHandler) {
        this.receiveHandler = receiveHandler;
    }

    @Override
    public Queue<IBuffer> getSendQueue() {
        return this.sendQueue;
    }

    @Override
    public void close() {
        this.deactivate();
    }

    @Override
    public void sendBuffer(IBuffer buffer) {
        this.handleBuffer(buffer);
    }

    @Override
    public void handleBuffer(IBuffer buffer) {
        BufferState state = buffer.getState();
        if (state != BufferState.PUTTING) {
            OM.LOG.warn("Ignoring buffer in state == " + (Object)((Object)state) + ": " + this);
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Handling buffer from client: {0} --> {1}", new Object[]{buffer, this});
        }
        if (this.sendQueue == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Ignoring buffer because sendQueue == null: " + this);
            }
            buffer.release();
        } else {
            this.sendQueue.add(buffer);
            this.channelMultiplexer.multiplexChannel(this);
        }
    }

    @Override
    public void handleBufferFromMultiplexer(IBuffer buffer) {
        if (this.receiveHandler != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Handling buffer from multiplexer: {0} --> {1}", new Object[]{buffer, this});
            }
            this.receiveSerializer.addWork((Runnable)new ReceiverWork(buffer));
        } else {
            buffer.release();
        }
    }

    public String toString() {
        return MessageFormat.format("Channel[{0}]", this.channelIndex);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.channelIndex != Short.MIN_VALUE, "channelIndex == NO_CHANNEL");
        this.checkState(this.channelMultiplexer, "channelMultiplexer");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.sendQueue = new ConcurrentLinkedQueue<IBuffer>();
        class ChannelReceiveSerializer
        extends QueueWorkerWorkSerializer {
            ChannelReceiveSerializer() {
            }

            protected String getThreadName() {
                return "ReceiveSerializer" + Channel.this.channelIndex;
            }
        }
        this.receiveSerializer = this.receiveExecutor == null ? new SynchronousWorkSerializer() : new ChannelReceiveSerializer();
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.receiveHandler);
        this.receiveHandler = null;
        this.channelMultiplexer.removeChannel(this);
        if (this.receiveSerializer != null) {
            this.receiveSerializer.dispose();
            this.receiveSerializer = null;
        }
        if (this.sendQueue != null) {
            this.sendQueue.clear();
            this.sendQueue = null;
        }
        super.doDeactivate();
    }

    private final class ReceiverWork
    implements Runnable {
        private final IBuffer buffer;

        private ReceiverWork(IBuffer buffer) {
            this.buffer = buffer;
        }

        public void run() {
            if (Channel.this.receiveHandler != null) {
                Channel.this.receiveHandler.handleBuffer(this.buffer);
            } else {
                this.buffer.release();
            }
        }
    }
}

