/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.om.monitor.MonitorUtil;
import org.eclipse.net4j.util.om.monitor.MonitoredJob;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class LongRunningAction
extends SafeAction {
    private IWorkbenchPage page;
    private int totalWork;

    public LongRunningAction(IWorkbenchPage page) {
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, String toolTipText, ImageDescriptor image) {
        super(text, toolTipText, image);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, ImageDescriptor image) {
        super(text, image);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, String toolTipText) {
        super(text, toolTipText);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, int style) {
        super(text, style);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text) {
        super(text);
        this.page = page;
    }

    public LongRunningAction() {
    }

    public LongRunningAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public LongRunningAction(String text, int style) {
        super(text, style);
    }

    public LongRunningAction(String text, String toolTipText, ImageDescriptor image) {
        super(text, toolTipText, image);
    }

    public LongRunningAction(String text, String toolTipText) {
        super(text, toolTipText);
    }

    public LongRunningAction(String text) {
        super(text);
    }

    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    public IWorkbenchPage getPage() {
        if (this.page != null) {
            return this.page;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.page != null) {
            return this.page.getWorkbenchWindow();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public Shell getShell() {
        return this.getWorkbenchWindow().getShell();
    }

    protected final int getTotalWork() {
        return this.totalWork;
    }

    protected final void setTotalWork(int totalWork) {
        this.totalWork = totalWork;
    }

    protected final void cancel() {
        this.totalWork = 0;
    }

    protected final void safeRun() throws Exception {
        this.totalWork = -1;
        this.preRun();
        if (this.totalWork != 0) {
            new MonitoredJob(this.getBundleID(), this.getText()){

                protected void run() throws Exception {
                    try {
                        MonitorUtil.begin((int)LongRunningAction.this.totalWork);
                        LongRunningAction.this.doRun();
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        throw ex;
                    }
                }
            }.schedule();
        }
    }

    protected void preRun() throws Exception {
    }

    protected String getBundleID() {
        return "org.eclipse.net4j.util.ui";
    }

    protected abstract void doRun() throws Exception;

    protected final void checkCancelation(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

