/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.transaction.TransactionRolledbackException;
import org.eclipse.net4j.internal.jms.BytesMessageImpl;
import org.eclipse.net4j.internal.jms.ConnectionImpl;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.MapMessageImpl;
import org.eclipse.net4j.internal.jms.MessageConsumerImpl;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.MessageProducerImpl;
import org.eclipse.net4j.internal.jms.NotYetImplementedException;
import org.eclipse.net4j.internal.jms.ObjectMessageImpl;
import org.eclipse.net4j.internal.jms.QueueBrowserImpl;
import org.eclipse.net4j.internal.jms.QueueImpl;
import org.eclipse.net4j.internal.jms.StreamMessageImpl;
import org.eclipse.net4j.internal.jms.TemporaryQueueImpl;
import org.eclipse.net4j.internal.jms.TemporaryTopicImpl;
import org.eclipse.net4j.internal.jms.TextMessageImpl;
import org.eclipse.net4j.internal.jms.TopicImpl;
import org.eclipse.net4j.internal.jms.TopicSubscriberImpl;
import org.eclipse.net4j.internal.jms.bundle.OM;
import org.eclipse.net4j.internal.jms.protocol.JMSAcknowledgeRequest;
import org.eclipse.net4j.internal.jms.protocol.JMSClientMessageRequest;
import org.eclipse.net4j.internal.jms.protocol.JMSCommitRequest;
import org.eclipse.net4j.internal.jms.protocol.JMSRecoverRequest;
import org.eclipse.net4j.internal.jms.protocol.JMSRegisterConsumerRequest;
import org.eclipse.net4j.internal.jms.protocol.JMSRollbackRequest;
import org.eclipse.net4j.internal.jms.util.DestinationUtil;
import org.eclipse.net4j.internal.jms.util.MessageUtil;
import org.eclipse.net4j.util.lifecycle.QueueWorker;
import org.eclipse.net4j.util.lifecycle.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
extends QueueWorker<MessageConsumerImpl>
implements Session {
    private ConnectionImpl connection;
    private int id;
    private boolean transacted;
    private int acknowledgeMode;
    private Map<Long, MessageConsumerImpl> consumers = new HashMap<Long, MessageConsumerImpl>();
    private List<MessageImpl> messages = new ArrayList<MessageImpl>();
    private Set<MessageProducerImpl> producers = new HashSet<MessageProducerImpl>();

    public SessionImpl(ConnectionImpl connection, int id, boolean transacted, int acknowledgeMode) throws JMSException {
        this.connection = connection;
        this.id = id;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        try {
            this.activate();
        }
        catch (Exception ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public int getID() {
        return this.id;
    }

    public boolean getTransacted() {
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public MessageListener getMessageListener() {
        return null;
    }

    public void setMessageListener(MessageListener listener) {
        throw new UnsupportedOperationException();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        DestinationImpl dest = DestinationUtil.convert(destination);
        MessageProducerImpl producer = new MessageProducerImpl(this, dest);
        this.producers.add(producer);
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        DestinationImpl dest = DestinationUtil.convert(destination);
        long consumerID = this.registerConsumer(dest, messageSelector, noLocal, false);
        MessageConsumerImpl consumer = new MessageConsumerImpl(this, consumerID, dest, messageSelector);
        this.consumers.put(consumerID, consumer);
        return consumer;
    }

    public Queue createQueue(String queueName) {
        return new QueueImpl(queueName);
    }

    public TemporaryQueue createTemporaryQueue() {
        return new TemporaryQueueImpl();
    }

    public QueueBrowser createBrowser(Queue queue) {
        return new QueueBrowserImpl(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return new QueueBrowserImpl(queue, messageSelector);
    }

    public Topic createTopic(String topicName) {
        return new TopicImpl(topicName);
    }

    public TemporaryTopic createTemporaryTopic() {
        return new TemporaryTopicImpl();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicImpl dest = (TopicImpl)DestinationUtil.convert((Destination)topic);
        long consumerID = this.registerConsumer(dest, messageSelector, noLocal, true);
        TopicSubscriberImpl subscriber = new TopicSubscriberImpl(this, consumerID, dest, name, messageSelector, noLocal);
        this.consumers.put(consumerID, subscriber);
        return subscriber;
    }

    public void unsubscribe(String name) {
        throw new NotYetImplementedException();
    }

    public Message createMessage() {
        return new MessageImpl();
    }

    public StreamMessage createStreamMessage() {
        return new StreamMessageImpl();
    }

    public BytesMessage createBytesMessage() {
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() {
        return new MapMessageImpl();
    }

    public ObjectMessage createObjectMessage() {
        return this.createObjectMessage(null);
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return new ObjectMessageImpl(object);
    }

    public TextMessage createTextMessage() {
        return this.createTextMessage(null);
    }

    public TextMessage createTextMessage(String text) {
        return new TextMessageImpl(text);
    }

    public void recover() throws JMSException {
        this.ensureNotTransacted();
        try {
            this.stop();
            new JMSRecoverRequest(this.connection.getChannel(), this.id).send();
            this.start();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        this.ensureTransacted();
        List<MessageImpl> list = this.messages;
        synchronized (list) {
            try {
                String[] messageIDs = (String[])new JMSCommitRequest(this.connection.getChannel(), this.id, this.messages).send();
                if (messageIDs == null) {
                    throw new TransactionRolledbackException("Transaction rolled back by JMS server");
                }
                int i = 0;
                while (i < messageIDs.length) {
                    this.messages.get(i).setJMSMessageID(messageIDs[i]);
                    ++i;
                }
                this.messages.clear();
            }
            catch (JMSException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JMSException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        this.ensureTransacted();
        List<MessageImpl> list = this.messages;
        synchronized (list) {
            try {
                if (!((Boolean)new JMSRollbackRequest(this.connection.getChannel(), this.id).send()).booleanValue()) {
                    throw new JMSException("JMS server failed to rolled back transaction");
                }
                this.messages.clear();
            }
            catch (JMSException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JMSException(ex.getMessage());
            }
        }
    }

    public void close() {
        this.deactivate();
    }

    public void run() {
        throw new UnsupportedOperationException();
    }

    public long registerConsumer(DestinationImpl destination, String messageSelector, boolean noLocal, boolean durable) throws JMSException {
        try {
            return (Long)new JMSRegisterConsumerRequest(this.connection.getChannel(), this.id, destination, messageSelector, noLocal, durable).send();
        }
        catch (Exception ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message) throws JMSException {
        if (this.getTransacted()) {
            List<MessageImpl> list = this.messages;
            synchronized (list) {
                if (message instanceof MessageImpl) {
                    this.messages.add(MessageUtil.copy(message));
                } else {
                    this.messages.add(MessageUtil.convert(message));
                }
            }
        }
        try {
            MessageImpl impl = MessageUtil.convert(message);
            JMSClientMessageRequest request = new JMSClientMessageRequest(this.connection.getChannel(), impl);
            String messageID = (String)request.send(this.connection.getSendTimeout());
            if (messageID == null) {
                throw new JMSException("Message not accepted by JMS server");
            }
            message.setJMSMessageID(messageID);
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public boolean acknowledgeMessages(MessageConsumerImpl consumer) {
        try {
            new JMSAcknowledgeRequest(this.connection.getChannel(), this.id).send();
            return true;
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return true;
        }
    }

    public void handleServerMessage(long consumerID, MessageImpl message) {
        message.setReceivingSession(this);
        MessageConsumerImpl consumer = this.consumers.get(consumerID);
        if (consumer == null) {
            OM.LOG.warn("Consumer " + consumerID + " not found. Discarding message.");
            return;
        }
        consumer.handleServerMessage(message);
    }

    protected String getThreadName() {
        return "jms-session";
    }

    protected void work(Worker.WorkContext context, MessageConsumerImpl consumer) {
        consumer.dispatchMessage();
    }

    private void ensureTransacted() throws IllegalStateException {
        if (!this.transacted) {
            throw new IllegalStateException("Session " + this.id + " not transacted");
        }
    }

    private void ensureNotTransacted() throws IllegalStateException {
        if (this.transacted) {
            throw new IllegalStateException("Session " + this.id + " transacted");
        }
    }

    private void start() {
    }

    private void stop() {
    }
}

