/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.ddl.DBField;
import org.eclipse.net4j.internal.db.ddl.DBIndex;
import org.eclipse.net4j.spi.db.DBSchema;
import org.eclipse.net4j.spi.db.DBSchemaElement;

public class DBTable
extends DBSchemaElement
implements IDBTable {
    private DBSchema schema;
    private String name;
    private List<DBField> fields = new ArrayList<DBField>();
    private List<DBIndex> indices = new ArrayList<DBIndex>();

    public DBTable(DBSchema schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public DBSchema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public DBField addField(String name, DBType type) {
        return this.addField(name, type, -1, -1, false);
    }

    public DBField addField(String name, DBType type, boolean notNull) {
        return this.addField(name, type, -1, -1, notNull);
    }

    public DBField addField(String name, DBType type, int precision) {
        return this.addField(name, type, precision, -1, false);
    }

    public DBField addField(String name, DBType type, int precision, boolean notNull) {
        return this.addField(name, type, precision, -1, notNull);
    }

    public DBField addField(String name, DBType type, int precision, int scale) {
        return this.addField(name, type, precision, scale, false);
    }

    public DBField addField(String name, DBType type, int precision, int scale, boolean notNull) {
        this.schema.assertUnlocked();
        if (this.getField(name) != null) {
            throw new DBException("DBField exists: " + name);
        }
        DBField field = new DBField(this, name, type, precision, scale, notNull, this.fields.size());
        this.fields.add(field);
        return field;
    }

    public DBField getField(String name) {
        for (DBField field : this.fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public DBField getField(int index) {
        return this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public DBField[] getFields() {
        return this.fields.toArray(new DBField[this.fields.size()]);
    }

    public DBIndex addIndex(IDBIndex.Type type, IDBField ... fields) {
        this.schema.assertUnlocked();
        DBIndex index = new DBIndex(this, type, fields, this.indices.size());
        this.indices.add(index);
        return index;
    }

    public int getIndexCount() {
        return this.indices.size();
    }

    public DBIndex[] getIndices() {
        return this.indices.toArray(new DBIndex[this.indices.size()]);
    }

    public IDBIndex getPrimaryKeyIndex() {
        for (IDBIndex iDBIndex : this.indices) {
            if (iDBIndex.getType() != IDBIndex.Type.PRIMARY_KEY) continue;
            return iDBIndex;
        }
        return null;
    }

    public String getFullName() {
        return this.name;
    }

    public String sqlInsert() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getName());
        builder.append(" VALUES (");
        int i = 0;
        while (i < this.fields.size()) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("?");
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }
}

