/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions.numbers;

import org.eclipse.emf.query.conditions.DataTypeCondition;
import org.eclipse.emf.query.conditions.numbers.NumberAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberCondition<N extends Number>
extends DataTypeCondition<N> {
    public static RelationalOperator EQUAL_TO = RelationalOperator.EQUAL_TO;
    public static RelationalOperator NOT_EQUAL_TO = RelationalOperator.NOT_EQUAL_TO;
    public static RelationalOperator LESS_THAN = RelationalOperator.LESS_THAN;
    public static RelationalOperator LESS_THAN_OR_EQUAL_TO = RelationalOperator.LESS_THAN_OR_EQUAL_TO;
    public static RelationalOperator GREATER_THAN = RelationalOperator.GREATER_THAN;
    public static RelationalOperator GREATER_THAN_OR_EQUAL_TO = RelationalOperator.GREATER_THAN_OR_EQUAL_TO;
    public static RelationalOperator BETWEEN = RelationalOperator.BETWEEN;
    protected N upperBound;
    protected boolean upperInclusive;
    protected N lowerBound;
    protected boolean lowerInclusive;
    protected RelationalOperator operator;

    public NumberCondition(N number) {
        this((RelationalOperator)((Object)number), EQUAL_TO, (NumberAdapter<RelationalOperator>)NumberAdapter.getDefault());
    }

    public NumberCondition(N number, NumberAdapter<? extends N> adapter) {
        this((N)number, (N)BETWEEN, adapter);
    }

    public NumberCondition(N number, RelationalOperator operator) {
        this((RelationalOperator)((Object)number), operator, (NumberAdapter<RelationalOperator>)NumberAdapter.getDefault());
    }

    public NumberCondition(N number, RelationalOperator operator, NumberAdapter<? extends N> adapter) {
        super(number, adapter);
        switch (operator) {
            case EQUAL_TO: {
                this.lowerBound = number;
                this.lowerInclusive = true;
                this.upperBound = number;
                this.upperInclusive = true;
                break;
            }
            case NOT_EQUAL_TO: {
                this.lowerBound = number;
                this.lowerInclusive = false;
                this.upperBound = number;
                this.upperInclusive = false;
                break;
            }
            case LESS_THAN: {
                this.upperBound = number;
                this.upperInclusive = false;
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                this.upperBound = number;
                this.upperInclusive = true;
                break;
            }
            case GREATER_THAN: {
                this.lowerBound = number;
                this.lowerInclusive = false;
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                this.lowerBound = number;
                this.lowerInclusive = true;
            }
        }
        this.operator = operator;
    }

    public NumberCondition(N lowerBound, N upperBound) {
        this(lowerBound, true, upperBound, true, NumberAdapter.getDefault());
    }

    public NumberCondition(N lowerBound, N upperBound, NumberAdapter<? extends N> adapter) {
        this((N)lowerBound, true, (N)upperBound, true, adapter);
    }

    public NumberCondition(N lowerBound, boolean lowerInclusive, N upperBound, boolean upperInclusive) {
        this(lowerBound, lowerInclusive, upperBound, upperInclusive, NumberAdapter.getDefault());
    }

    public NumberCondition(N lowerBound, boolean lowerInclusive, N upperBound, boolean upperInclusive, NumberAdapter<? extends N> adapter) {
        super(lowerBound, adapter);
        this.lowerBound = lowerBound;
        this.lowerInclusive = lowerInclusive;
        this.upperBound = upperBound;
        this.upperInclusive = upperInclusive;
        this.operator = BETWEEN;
    }

    public static <N extends Number> NumberCondition<N> equals(N number) {
        return new NumberCondition<RelationalOperator>((RelationalOperator)((Object)number), EQUAL_TO);
    }

    public static <N extends Number> NumberCondition<N> notEquals(N number) {
        return new NumberCondition<RelationalOperator>((RelationalOperator)((Object)number), NOT_EQUAL_TO);
    }

    public static <N extends Number> NumberCondition<N> lessThan(N number) {
        return new NumberCondition<RelationalOperator>((RelationalOperator)((Object)number), LESS_THAN);
    }

    public static <N extends Number> NumberCondition<N> lessThanOrEquals(N number) {
        return new NumberCondition<RelationalOperator>((RelationalOperator)((Object)number), LESS_THAN_OR_EQUAL_TO);
    }

    public static <N extends Number> NumberCondition<N> greaterThan(N number) {
        return new NumberCondition<RelationalOperator>((RelationalOperator)((Object)number), GREATER_THAN);
    }

    public static <N extends Number> NumberCondition<N> greaterThanOrEquals(N number) {
        return new NumberCondition<RelationalOperator>((RelationalOperator)((Object)number), GREATER_THAN_OR_EQUAL_TO);
    }

    public static <N extends Number> NumberCondition<N> between(N lowerBound, N upperBound) {
        return NumberCondition.between(lowerBound, true, upperBound, true);
    }

    public static <N extends Number> NumberCondition<N> between(N lowerBound, boolean lowerInclusive, N upperBound, boolean upperInclusive) {
        return new NumberCondition<N>(lowerBound, lowerInclusive, upperBound, upperInclusive);
    }

    public boolean isSatisfied(Byte byteNumber) {
        return this.isSatisfied((byte)byteNumber);
    }

    public boolean isSatisfied(byte byteValue) {
        return byteValue >= ((Number)this.lowerBound).byteValue() && byteValue <= ((Number)this.upperBound).byteValue();
    }

    public boolean isSatisfied(Double doubleNumber) {
        return this.isSatisfied((double)doubleNumber);
    }

    public boolean isSatisfied(double doubleValue) {
        return doubleValue >= ((Number)this.lowerBound).doubleValue() && doubleValue <= ((Number)this.upperBound).doubleValue();
    }

    public boolean isSatisfied(Float floatNumber) {
        return this.isSatisfied(floatNumber.floatValue());
    }

    public boolean isSatisfied(float floatValue) {
        return floatValue >= ((Number)this.lowerBound).floatValue() && floatValue <= ((Number)this.upperBound).floatValue();
    }

    public boolean isSatisfied(Integer intNumber) {
        return this.isSatisfied((int)intNumber);
    }

    public boolean isSatisfied(int intValue) {
        return intValue >= ((Number)this.lowerBound).intValue() && intValue <= ((Number)this.upperBound).intValue();
    }

    public boolean isSatisfied(Long longNumber) {
        return this.isSatisfied((long)longNumber);
    }

    public boolean isSatisfied(long longValue) {
        return longValue >= ((Number)this.lowerBound).longValue() && longValue <= ((Number)this.upperBound).longValue();
    }

    public boolean isSatisfied(Short shortNumber) {
        return this.isSatisfied((short)shortNumber);
    }

    public boolean isSatisfied(short shortValue) {
        return shortValue >= ((Number)this.lowerBound).shortValue() && shortValue <= ((Number)this.upperBound).shortValue();
    }

    @Override
    public boolean isSatisfied(Object object) {
        return this.operator.isSatisfied(this, (Number)this.adapter.adapt(object));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteValue
    extends NumberCondition<Byte> {
        public ByteValue(Byte number) {
            this(number, NumberAdapter.ByteAdapter.DEFAULT);
        }

        public ByteValue(Byte number, NumberAdapter.ByteAdapter adapter) {
            this(number, number, adapter);
        }

        public ByteValue(Byte lowerBound, Byte upperBound) {
            this(lowerBound, upperBound, NumberAdapter.ByteAdapter.DEFAULT);
        }

        public ByteValue(Byte lowerBound, Byte upperBound, NumberAdapter.ByteAdapter adapter) {
            super(lowerBound, upperBound, adapter);
        }

        @Override
        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.ByteAdapter)this.adapter).byteValue(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleValue
    extends NumberCondition<Double> {
        public DoubleValue(Double number) {
            this(number, NumberAdapter.DoubleAdapter.DEFAULT);
        }

        public DoubleValue(Double number, NumberAdapter.DoubleAdapter adapter) {
            this(number, number, adapter);
        }

        public DoubleValue(Double lowerBound, Double upperBound) {
            this(lowerBound, upperBound, NumberAdapter.DoubleAdapter.DEFAULT);
        }

        public DoubleValue(Double lowerBound, Double upperBound, NumberAdapter.DoubleAdapter adapter) {
            super(lowerBound, upperBound, adapter);
        }

        @Override
        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.DoubleAdapter)this.adapter).doubleValue(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatValue
    extends NumberCondition<Float> {
        public FloatValue(Float number) {
            this(number, NumberAdapter.FloatAdapter.DEFAULT);
        }

        public FloatValue(Float number, NumberAdapter.FloatAdapter adapter) {
            this(number, number, adapter);
        }

        public FloatValue(Float lowerBound, Float upperBound) {
            this(lowerBound, upperBound, NumberAdapter.FloatAdapter.DEFAULT);
        }

        public FloatValue(Float lowerBound, Float upperBound, NumberAdapter.FloatAdapter adapter) {
            super(lowerBound, upperBound, adapter);
        }

        @Override
        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.FloatAdapter)this.adapter).floatValue(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerValue
    extends NumberCondition<Integer> {
        public IntegerValue(Integer number) {
            this(number, NumberAdapter.IntegerAdapter.DEFAULT);
        }

        public IntegerValue(Integer number, NumberAdapter.IntegerAdapter adapter) {
            this(number, number, adapter);
        }

        public IntegerValue(Integer lowerBound, Integer upperBound) {
            this(lowerBound, upperBound, NumberAdapter.IntegerAdapter.DEFAULT);
        }

        public IntegerValue(Integer lowerBound, Integer upperBound, NumberAdapter.IntegerAdapter adapter) {
            super(lowerBound, upperBound, adapter);
        }

        @Override
        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.IntegerAdapter)this.adapter).intValue(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongValue
    extends NumberCondition<Long> {
        public LongValue(Long number) {
            this(number, NumberAdapter.LongAdapter.DEFAULT);
        }

        public LongValue(Long number, NumberAdapter.LongAdapter adapter) {
            this(number, number, adapter);
        }

        public LongValue(Long lowerBound, Long upperBound) {
            this(lowerBound, upperBound, NumberAdapter.LongAdapter.DEFAULT);
        }

        public LongValue(Long lowerBound, Long upperBound, NumberAdapter.LongAdapter adapter) {
            super(lowerBound, upperBound, adapter);
        }

        @Override
        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.LongAdapter)this.adapter).longValue(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelationalOperator {
        EQUAL_TO{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return ((Comparable)((Object)((Number)((NumberCondition)cond).value))).compareTo(number) == 0;
            }
        }
        ,
        NOT_EQUAL_TO{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return ((Comparable)((Object)((Number)((NumberCondition)cond).value))).compareTo(number) != 0;
            }
        }
        ,
        LESS_THAN{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return ((Comparable)((Object)((Number)((NumberCondition)cond).value))).compareTo(number) > 0;
            }
        }
        ,
        LESS_THAN_OR_EQUAL_TO{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return ((Comparable)((Object)((Number)((NumberCondition)cond).value))).compareTo(number) >= 0;
            }
        }
        ,
        GREATER_THAN{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return ((Comparable)((Object)((Number)((NumberCondition)cond).value))).compareTo(number) < 0;
            }
        }
        ,
        GREATER_THAN_OR_EQUAL_TO{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return ((Comparable)((Object)((Number)((NumberCondition)cond).value))).compareTo(number) <= 0;
            }
        }
        ,
        BETWEEN{

            @Override
            <N extends Number> boolean isSatisfied(NumberCondition<N> cond, N number) {
                return (cond.lowerInclusive ? ((Comparable)cond.lowerBound).compareTo(number) <= 0 : ((Comparable)cond.lowerBound).compareTo(number) < 0) && (cond.upperInclusive ? ((Comparable)cond.upperBound).compareTo(number) >= 0 : ((Comparable)cond.upperBound).compareTo(number) > 0);
            }
        };


        abstract <N extends Number> boolean isSatisfied(NumberCondition<N> var1, N var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortValue
    extends NumberCondition<Short> {
        public ShortValue(Short number) {
            this(number, NumberAdapter.ShortAdapter.DEFAULT);
        }

        public ShortValue(Short number, NumberAdapter.ShortAdapter adapter) {
            this(number, number, adapter);
        }

        public ShortValue(Short lowerBound, Short upperBound) {
            this(lowerBound, upperBound, NumberAdapter.ShortAdapter.DEFAULT);
        }

        public ShortValue(Short lowerBound, Short upperBound, NumberAdapter.ShortAdapter adapter) {
            super(lowerBound, upperBound, adapter);
        }

        @Override
        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.ShortAdapter)this.adapter).shortValue(object));
        }
    }
}

