/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class InitializeCopyOverrideCommand
extends AbstractCommand {
    protected MappingDomain mappingDomain;
    protected InitializeCopyCommand initializeCommand;

    public InitializeCopyOverrideCommand(MappingDomain domain, InitializeCopyCommand initializeCommand) {
        super(initializeCommand.doGetLabel(), initializeCommand.doGetDescription());
        this.mappingDomain = domain;
        this.initializeCommand = initializeCommand;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        Object copyType;
        Object ownerType;
        String ownerName;
        EObject owner = this.initializeCommand.getOwner();
        EObject copy = this.initializeCommand.getCopy();
        CopyCommand.Helper copyHelper = this.initializeCommand.getCopyHelper();
        ArrayList<EObject> copyChildren = new ArrayList<EObject>();
        Iterator ownerChildren = this.mappingDomain.getChildren(owner).iterator();
        while (ownerChildren.hasNext()) {
            EObject copyChild;
            Object copyChildObject = ownerChildren.next();
            if (!(copyChildObject instanceof EObject) || (copyChild = copyHelper.getCopy((EObject)copyChildObject)) == null) continue;
            copyChildren.add(copyChild);
        }
        if (!copyChildren.isEmpty()) {
            Command addCommand = AddCommand.create((EditingDomain)this.mappingDomain, (Object)copy, null, copyChildren);
            if (addCommand.canExecute()) {
                addCommand.execute();
            } else {
                addCommand.dispose();
                return;
            }
        }
        if ((ownerName = this.mappingDomain.getName(owner)) != null) {
            this.mappingDomain.setName(copy, this.mappingDomain.getOutputName(ownerName));
        }
        if ((ownerType = this.mappingDomain.getTypeClassifier(owner)) != null && (copyType = this.mappingDomain.getOutputTypeClassifier(ownerType)) != null) {
            this.mappingDomain.setTypeClassifier(copy, copyType);
        }
    }

    public void undo() {
    }

    public void redo() {
    }

    public Collection getResult() {
        return Collections.singleton(this.initializeCommand.getCopy());
    }

    public Collection getAffectedObjects() {
        return Collections.singleton(this.initializeCommand.getCopy());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingDomain: " + this.mappingDomain + ")");
        result.append(" (owner: " + this.initializeCommand.getOwner() + ")");
        result.append(" (copy: " + this.initializeCommand.getCopy() + ")");
        return result.toString();
    }
}

