/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPackageRegistryImpl
extends HashMap<String, Object>
implements EPackage.Registry {
    private static final long serialVersionUID = 1L;
    protected EPackage.Registry delegateRegistry;
    protected static Map<ClassLoader, EPackage.Registry> classLoaderToRegistryMap = new WeakHashMap<ClassLoader, EPackage.Registry>();

    public static EPackage.Registry createGlobalRegistry() {
        try {
            String className = System.getProperty("org.eclipse.emf.ecore.EPackage.Registry.INSTANCE");
            if (className == null) {
                if (EcorePlugin.getDefaultRegistryImplementation() != null) {
                    return EcorePlugin.getDefaultRegistryImplementation();
                }
                if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                    return new Delegator();
                }
                return new EPackageRegistryImpl();
            }
            return (EPackage.Registry)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
            return new EPackageRegistryImpl();
        }
    }

    public EPackageRegistryImpl() {
    }

    public EPackageRegistryImpl(EPackage.Registry delegateRegistry) {
        this.delegateRegistry = delegateRegistry;
    }

    @Override
    public EPackage getEPackage(String nsURI) {
        Object ePackage = this.get(nsURI);
        if (ePackage instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            if (result.getNsURI() == null) {
                this.initialize(result);
            }
            return result;
        }
        if (ePackage instanceof EPackage.Descriptor) {
            EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
            EPackage result = ePackageDescriptor.getEPackage();
            if (result != null) {
                this.put(nsURI, result);
                this.initialize(result);
            }
            return result;
        }
        return this.delegatedGetEPackage(nsURI);
    }

    @Override
    public EFactory getEFactory(String nsURI) {
        Object ePackage = this.get(nsURI);
        if (ePackage instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            if (result.getNsURI() == null) {
                this.initialize(result);
            }
            return result.getEFactoryInstance();
        }
        if (ePackage instanceof EPackage.Descriptor) {
            EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
            EFactory result = ePackageDescriptor.getEFactory();
            return result;
        }
        return this.delegatedGetEFactory(nsURI);
    }

    protected void initialize(EPackage ePackage) {
    }

    protected EPackage delegatedGetEPackage(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEPackage(nsURI);
        }
        return null;
    }

    protected EFactory delegatedGetEFactory(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEFactory(nsURI);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.delegateRegistry != null && this.delegateRegistry.containsKey(key);
    }

    public static synchronized EPackage.Registry getRegistry(ClassLoader classLoader) {
        EPackage.Registry result = classLoaderToRegistryMap.get(classLoader);
        if (result == null && classLoader != null) {
            result = new EPackageRegistryImpl(EPackageRegistryImpl.getRegistry(classLoader.getParent()));
            classLoaderToRegistryMap.put(classLoader, result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Delegator
    implements EPackage.Registry {
        protected EPackage.Registry delegateRegistry(ClassLoader classLoader) {
            return EPackageRegistryImpl.getRegistry(classLoader);
        }

        protected EPackage.Registry delegateRegistry() {
            return this.delegateRegistry(Thread.currentThread().getContextClassLoader());
        }

        @Override
        public EPackage getEPackage(String key) {
            return this.delegateRegistry().getEPackage(key);
        }

        @Override
        public EFactory getEFactory(String key) {
            return this.delegateRegistry().getEFactory(key);
        }

        @Override
        public int size() {
            return this.delegateRegistry().size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegateRegistry().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegateRegistry().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegateRegistry().containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.delegateRegistry().get(key);
        }

        @Override
        public Object put(String key, Object value) {
            Class<?> valueClass = value.getClass();
            if (valueClass == EPackageImpl.class) {
                return this.delegateRegistry().put(key, value);
            }
            String valueClassName = valueClass.getName();
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = result.getParent();
            while (classLoader != null) {
                try {
                    Class<?> loadedClass = classLoader.loadClass(valueClassName);
                    if (loadedClass != valueClass) break;
                    result = classLoader;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break;
                }
                classLoader = classLoader.getParent();
            }
            return this.delegateRegistry(result).put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.delegateRegistry().remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.delegateRegistry().clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegateRegistry().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegateRegistry().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegateRegistry().entrySet();
        }
    }
}

