/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.InternalCDOFeatureDelta;
import org.eclipse.emf.internal.cdo.transaction.AbstractSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.collection.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSavepointImpl
extends AbstractSavepoint {
    private Map<CDOID, CDOResource> newResources = new HashMap<CDOID, CDOResource>();
    private Map<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
    private Map<CDOID, CDORevision> baseNewObjects = new HashMap<CDOID, CDORevision>();
    private Map<CDOID, CDOObject> dirtyObjects = new HashMap<CDOID, CDOObject>();
    private Map<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>(){
        private static final long serialVersionUID = 1L;

        @Override
        public CDOObject put(CDOID key, CDOObject object) {
            CDOSavepointImpl.this.sharedDetachedObjects.add(key);
            CDOSavepointImpl.this.dirtyObjects.remove(key);
            CDOSavepointImpl.this.baseNewObjects.remove(key);
            CDOSavepointImpl.this.newObjects.remove(key);
            CDOSavepointImpl.this.newResources.remove(key);
            CDOSavepointImpl.this.revisionDeltas.remove(key);
            return super.put(key, object);
        }
    };
    private ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = new ConcurrentHashMap<CDOID, CDORevisionDelta>();
    private Set<CDOID> sharedDetachedObjects;
    private boolean isDirty;

    public CDOSavepointImpl(InternalCDOTransaction transaction, CDOSavepointImpl lastSavepoint) {
        super(transaction, lastSavepoint);
        this.isDirty = transaction.isDirty();
        this.sharedDetachedObjects = this.getPreviousSavepoint() == null ? new HashSet<CDOID>() : lastSavepoint.getSharedDetachedObjects();
    }

    public void clear() {
        this.newResources.clear();
        this.newObjects.clear();
        this.dirtyObjects.clear();
        this.revisionDeltas.clear();
        this.baseNewObjects.clear();
        this.detachedObjects.clear();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public Map<CDOID, CDOResource> getNewResources() {
        return this.newResources;
    }

    public Map<CDOID, CDOObject> getNewObjects() {
        return this.newObjects;
    }

    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.detachedObjects;
    }

    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.dirtyObjects;
    }

    public Set<CDOID> getSharedDetachedObjects() {
        return this.sharedDetachedObjects;
    }

    public ConcurrentMap<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return this.revisionDeltas;
    }

    public Map<CDOID, CDORevision> getBaseNewObjects() {
        return this.baseNewObjects;
    }

    public Map<CDOID, CDOObject> getAllDirtyObjects() {
        if (this.getPreviousSavepoint() == null) {
            return this.getDirtyObjects();
        }
        MultiMap.ListBased dirtyObjects = new MultiMap.ListBased();
        CDOSavepointImpl savepoint = this;
        while (savepoint != null) {
            dirtyObjects.getDelegates().add(savepoint.getDirtyObjects());
            savepoint = savepoint.getPreviousSavepoint();
        }
        return dirtyObjects;
    }

    public Map<CDOID, CDOObject> getAllNewObjects() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getNewObjects());
        }
        if (this.getSharedDetachedObjects().size() == 0) {
            MultiMap.ListBased newObjects = new MultiMap.ListBased();
            CDOSavepointImpl savepoint = this;
            while (savepoint != null) {
                newObjects.getDelegates().add(savepoint.getNewObjects());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return newObjects;
        }
        HashMap<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
        CDOSavepointImpl savepoint = this;
        while (savepoint != null) {
            for (Map.Entry<CDOID, CDOObject> entry : savepoint.getNewObjects().entrySet()) {
                if (this.getSharedDetachedObjects().contains(entry.getKey())) continue;
                newObjects.put(entry.getKey(), entry.getValue());
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return newObjects;
    }

    public Map<CDOID, CDOResource> getAllNewResources() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getNewResources());
        }
        if (this.getSharedDetachedObjects().size() == 0) {
            MultiMap.ListBased newResources = new MultiMap.ListBased();
            CDOSavepointImpl savepoint = this;
            while (savepoint != null) {
                newResources.getDelegates().add(savepoint.getNewResources());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return newResources;
        }
        HashMap<CDOID, CDOResource> newResources = new HashMap<CDOID, CDOResource>();
        CDOSavepointImpl savepoint = this;
        while (savepoint != null) {
            for (Map.Entry<CDOID, CDOResource> entry : savepoint.getNewResources().entrySet()) {
                if (this.getSharedDetachedObjects().contains(entry.getKey())) continue;
                newResources.put(entry.getKey(), entry.getValue());
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return newResources;
    }

    public Map<CDOID, CDORevision> getAllBaseNewObjects() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getBaseNewObjects());
        }
        MultiMap.ListBased newObjects = new MultiMap.ListBased();
        CDOSavepointImpl savepoint = this;
        while (savepoint != null) {
            newObjects.getDelegates().add(savepoint.getBaseNewObjects());
            savepoint = savepoint.getPreviousSavepoint();
        }
        return newObjects;
    }

    public Map<CDOID, CDORevisionDelta> getAllRevisionDeltas() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getRevisionDeltas());
        }
        HashMap<CDOID, CDORevisionDelta> revisionDeltas = new HashMap<CDOID, CDORevisionDelta>();
        CDOSavepointImpl savepoint = (CDOSavepointImpl)this.getFirstSavePoint();
        while (savepoint != null) {
            for (Map.Entry entry : savepoint.getRevisionDeltas().entrySet()) {
                if (((CDOID)entry.getKey()).isTemporary() || this.getSharedDetachedObjects().contains(entry.getKey())) continue;
                CDORevisionDeltaImpl revisionDelta = (CDORevisionDeltaImpl)revisionDeltas.get(entry.getKey());
                if (revisionDelta == null) {
                    revisionDeltas.put((CDOID)entry.getKey(), CDORevisionDeltaUtil.copy((CDORevisionDelta)((CDORevisionDelta)entry.getValue())));
                    continue;
                }
                for (CDOFeatureDelta delta : ((CDORevisionDelta)entry.getValue()).getFeatureDeltas()) {
                    revisionDelta.addFeatureDelta(((InternalCDOFeatureDelta)delta).copy());
                }
            }
            savepoint = savepoint.getNextSavepoint();
        }
        return Collections.unmodifiableMap(revisionDeltas);
    }

    public Map<CDOID, CDOObject> getAllDetachedObjects() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getDetachedObjects());
        }
        HashMap<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>();
        CDOSavepointImpl savepoint = this;
        while (savepoint != null) {
            for (Map.Entry<CDOID, CDOObject> entry : savepoint.getDetachedObjects().entrySet()) {
                if (entry.getKey().isTemporary()) continue;
                detachedObjects.put(entry.getKey(), entry.getValue());
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return detachedObjects;
    }

    public void recalculateSharedDetachedObjects() {
        this.sharedDetachedObjects.clear();
        CDOSavepointImpl savepoint = this;
        while (savepoint != null) {
            for (CDOID id : savepoint.getDetachedObjects().keySet()) {
                this.sharedDetachedObjects.add(id);
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
    }

    @Override
    public CDOSavepointImpl getPreviousSavepoint() {
        return (CDOSavepointImpl)super.getPreviousSavepoint();
    }

    @Override
    public CDOSavepointImpl getNextSavepoint() {
        return (CDOSavepointImpl)super.getNextSavepoint();
    }

    public void setPreviousSavepoint(CDOSavepointImpl previousSavepoint) {
        super.setPreviousSavepoint(previousSavepoint);
    }

    public void setNextSavepoint(CDOSavepointImpl nextSavepoint) {
        super.setNextSavepoint(nextSavepoint);
    }

    @Override
    public void rollback() {
        this.getUserTransaction().rollback(this);
    }
}

