/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.net4j.util.io.IORuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFUtil {
    private static final String ECORE_ENCODING = "ASCII";

    private EMFUtil() {
    }

    public static ResourceSet newResourceSet(Resource.Factory resourceFactory) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        return resourceSet;
    }

    public static ResourceSet newXMIResourceSet(EPackage ... ePackages) {
        ResourceSet resourceSet = EMFUtil.newResourceSet((Resource.Factory)new XMIResourceFactoryImpl());
        if (ePackages != null && ePackages.length != 0) {
            EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
            EPackage[] ePackageArray = ePackages;
            int n = ePackages.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage = ePackageArray[n2];
                packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                ++n2;
            }
        }
        return resourceSet;
    }

    public static ResourceSet newEcoreResourceSet(EPackage.Registry packageRegistry) {
        ResourceSet resourceSet = EMFUtil.newResourceSet((Resource.Factory)new EcoreResourceFactoryImpl());
        resourceSet.setPackageRegistry(packageRegistry);
        return resourceSet;
    }

    public static ResourceSet newEcoreResourceSet() {
        return EMFUtil.newEcoreResourceSet(EPackage.Registry.INSTANCE);
    }

    public static EObject load(String fileName, ResourceSet resourceSet) {
        Resource resource = resourceSet.getResource(URI.createFileURI((String)fileName), true);
        return (EObject)resource.getContents().get(0);
    }

    public static EObject loadXMI(String fileName, EPackage ... ePackages) {
        ResourceSet resourceSet = EMFUtil.newXMIResourceSet(ePackages);
        return EMFUtil.load(fileName, resourceSet);
    }

    public static EObject loadXMI(String fileName, EPackage.Registry packageRegistry) {
        ResourceSet resourceSet = EMFUtil.newXMIResourceSet(new EPackage[0]);
        resourceSet.setPackageRegistry(packageRegistry);
        return EMFUtil.load(fileName, resourceSet);
    }

    public static EObject loadEcore(String fileName, EPackage.Registry packageRegistry) {
        return EMFUtil.load(fileName, EMFUtil.newEcoreResourceSet(packageRegistry));
    }

    public static EObject loadEcore(String fileName) {
        return EMFUtil.load(fileName, EMFUtil.newEcoreResourceSet());
    }

    public static void save(String fileName, EObject root, ResourceSet resourceSet) {
        Resource resource = resourceSet.createResource(URI.createFileURI((String)fileName));
        EObject copy = EcoreUtil.copy((EObject)root);
        resource.getContents().add((Object)copy);
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public static void saveXMI(String fileName, EObject root) {
        EMFUtil.save(fileName, root, EMFUtil.newXMIResourceSet(new EPackage[0]));
    }

    public static void saveEcore(String fileName, EObject root) {
        EMFUtil.save(fileName, root, EMFUtil.newEcoreResourceSet());
    }

    public static int countAllContents(EObject eObject) {
        int count = 0;
        TreeIterator it = eObject.eAllContents();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public static List<EClass> getPersistentClasses(EPackage ePackage) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            result.add((EClass)classifier);
        }
        return result;
    }

    public static List<EStructuralFeature> getPersistentFeatures(EList<EStructuralFeature> eFeatures) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : eFeatures) {
            if (feature.isTransient() || feature == EcorePackage.eINSTANCE.getEClass_ESuperTypes() || feature == EcorePackage.eINSTANCE.getETypedElement_EType() || feature == EcorePackage.eINSTANCE.getEOperation_EExceptions()) continue;
            result.add(feature);
        }
        return result;
    }

    public static boolean isDynamicEPackage(Object value) {
        return value.getClass() == EPackageImpl.class;
    }

    public static boolean isMany(EStructuralFeature eFeature) {
        return eFeature.isMany();
    }

    public static boolean isReference(EStructuralFeature eFeature) {
        return eFeature instanceof EReference;
    }

    public static boolean isContainment(EStructuralFeature eFeature) {
        if (EMFUtil.isReference(eFeature)) {
            EReference ref = (EReference)eFeature;
            return ref.isContainment();
        }
        return false;
    }

    public static EPackage ePackageFromString(String ecore) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(ecore.getBytes(ECORE_ENCODING));
            XMIResourceImpl resource = new XMIResourceImpl();
            resource.load((InputStream)stream, null);
            return (EPackage)resource.getContents().get(0);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public static String ePackageToString(EPackage ePackage, EPackage.Registry packageRegistry) {
        Class<EMFUtil> clazz = EMFUtil.class;
        synchronized (EMFUtil.class) {
            XMIResourceFactoryImpl resourceFactory = new XMIResourceFactoryImpl();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
            resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("*", resourceFactory);
            Resource packageResource = EMFUtil.createPackageResource(resourceSet, ePackage);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                packageResource.save((OutputStream)stream, null);
                String string = stream.toString(ECORE_ENCODING);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return string;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }

    private static Resource createPackageResource(ResourceSetImpl resourceSet, EPackage ePackage) {
        URI uri = URI.createURI((String)ePackage.getNsURI());
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)ePackage);
        return resource;
    }

    public static void fixEClassifiers(EPackageImpl ePackage) {
        int id = 0;
        for (EClassifierImpl eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            eClassifier.setClassifierID(id++);
        }
        for (EClassifierImpl eClassifier : ePackage.getEClassifiers()) {
            if (eClassifier.getClassifierID() != -1 || !(eClassifier instanceof EEnum)) continue;
            eClassifier.setClassifierID(id++);
        }
        for (EClassifierImpl eClassifier : ePackage.getEClassifiers()) {
            if (eClassifier.getClassifierID() != -1 || !(eClassifier instanceof EDataType)) continue;
            eClassifier.setClassifierID(id++);
        }
    }
}

