/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocolFactory;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.spi.server.ContainerRepositoryProvider;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOServerUtil {
    private CDOServerUtil() {
    }

    public static IRepository createRepository(String name, IStore store, Map<String, String> props) {
        Repository.Default repository = new Repository.Default();
        repository.setName(name);
        repository.setStore(store);
        repository.setProperties(props);
        return repository;
    }

    public static void prepareContainer(IManagedContainer container, IRepositoryProvider repositoryProvider) {
        container.registerFactory((IFactory)new CDOServerProtocolFactory(repositoryProvider));
    }

    public static void prepareContainer(IManagedContainer container) {
        CDOServerUtil.prepareContainer(container, new ContainerRepositoryProvider(container));
    }

    public static void addRepository(IManagedContainer container, IRepository repository) {
        container.putElement("org.eclipse.emf.cdo.server.repositories", "default", repository.getName(), (Object)repository);
        LifecycleUtil.activate((Object)repository);
    }

    public static IRepository getRepository(IManagedContainer container, String name) {
        return RepositoryFactory.get(container, name);
    }

    public static Element getRepositoryConfig(String repositoryName) throws ParserConfigurationException, SAXException, IOException {
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo.server.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(configFile);
        NodeList elements = document.getElementsByTagName("repository");
        int i = 0;
        while (i < elements.getLength()) {
            Element element;
            String name;
            Node node = elements.item(i);
            if (node instanceof Element && ObjectUtil.equals((Object)(name = (element = (Element)node).getAttribute("name")), (Object)repositoryName)) {
                return element;
            }
            ++i;
        }
        throw new IllegalStateException("Repository config not found: " + repositoryName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class RepositoryReadAccessValidator
    implements IRepository.ReadAccessHandler {
        @Override
        public void handleRevisionsBeforeSending(ISession session, CDORevision[] revisions, List<CDORevision> additionalRevisions) throws RuntimeException {
            ArrayList<String> violations = new ArrayList<String>();
            CDORevision[] cDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CDORevision revision = cDORevisionArray[n2];
                String violation = this.validate(session, revision);
                if (violation != null) {
                    violations.add(violation);
                }
                ++n2;
            }
            if (!violations.isEmpty()) {
                this.throwException(session, violations);
            }
            Iterator<CDORevision> it = additionalRevisions.iterator();
            while (it.hasNext()) {
                CDORevision revision = it.next();
                String violation = this.validate(session, revision);
                if (violation == null) continue;
                OM.LOG.info("Revision can not be delivered to " + session + ": " + violation);
                it.remove();
            }
        }

        protected void throwException(ISession session, List<String> violations) throws RuntimeException {
            StringBuilder builder = new StringBuilder();
            builder.append("Revisions can not be delivered to ");
            builder.append(session);
            builder.append(":");
            for (String violation : violations) {
                builder.append("\n- ");
                builder.append(violation);
            }
            this.throwException(builder.toString());
        }

        protected void throwException(String message) throws RuntimeException {
            throw new IllegalStateException(message);
        }

        protected abstract String validate(ISession var1, CDORevision var2);
    }
}

