/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.internal.id;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.spi.common.AbstractCDOID;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.OMTracer;

public class CDOIDHibernateImpl
extends AbstractCDOID
implements CDOIDHibernate {
    public static final int HB_ID_TYPE_SERIALIZABLE = 0;
    public static final int HB_ID_TYPE_LONG = 1;
    public static final int HB_ID_TYPE_STRING = 2;
    private ContextTracer tracer;
    private static final long serialVersionUID = 1L;
    private Serializable id;
    private String entityName;

    public OMTracer getTracer() {
        return this.tracer.getDelegate();
    }

    public void setTracer(OMTracer tracer) {
        this.tracer = new ContextTracer(tracer, CDOIDHibernateImpl.class);
    }

    protected int getIDType() {
        return 0;
    }

    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    public CDOClassRef getClassRef() {
        return null;
    }

    public CDOIDObject asLegacy(CDOClassRef classRef) {
        return new Legacy(classRef);
    }

    public void read(ExtendedDataInput in) throws IOException {
        this.readId(in);
        if (this.tracer != null && this.tracer.isEnabled()) {
            this.tracer.format("Read id={0}", new Object[]{this.id});
        }
        this.entityName = in.readString();
        if (this.tracer != null && this.tracer.isEnabled()) {
            this.tracer.format("Read entityName={0}", new Object[]{this.entityName});
        }
    }

    public void write(ExtendedDataOutput out) throws IOException {
        if (this.tracer != null && this.tracer.isEnabled()) {
            this.tracer.format("Writing id type={0}", new Object[]{this.getIDType()});
        }
        out.writeInt(this.getIDType());
        if (this.tracer != null && this.tracer.isEnabled()) {
            this.tracer.format("Writing id={0}", new Object[]{this.id});
        }
        this.writeId(out);
        if (this.tracer != null && this.tracer.isEnabled()) {
            this.tracer.format("Writing entityName={0}", new Object[]{this.entityName});
        }
        out.writeString(this.entityName);
    }

    protected void readId(ExtendedDataInput in) throws IOException {
        this.id = (Serializable)in.readObject();
    }

    protected void writeId(ExtendedDataOutput out) throws IOException {
        out.writeObject((Object)this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CDOIDHibernate) {
            return ObjectUtil.equals((Object)this.id, (Object)((CDOIDHibernate)obj).getId()) && ObjectUtil.equals((Object)this.entityName, (Object)((CDOIDHibernate)obj).getEntityName());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode() + this.entityName.hashCode();
    }

    public String toString() {
        return MessageFormat.format("HBM-{0}-{1}", this.entityName, this.id);
    }

    public static final class Legacy
    extends CDOIDHibernateImpl {
        private static final long serialVersionUID = 1L;
        private CDOClassRef classRef;

        public Legacy() {
        }

        public Legacy(CDOClassRef classRef) {
            if (classRef == null) {
                throw new IllegalArgumentException("classRef == null");
            }
            this.classRef = classRef;
        }

        public CDOID.Type getType() {
            return CDOID.Type.LEGACY_OBJECT;
        }

        public CDOClassRef getClassRef() {
            return this.classRef;
        }

        public void setClassRef(CDOClassRef classRef) {
            this.classRef = classRef;
        }

        public Legacy asLegacy(CDOClassRef classRef) {
            return this;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "(" + this.classRef + ")";
        }
    }
}

