/*
 * Decompiled with CFR 0.152.
 */
package temporal.mod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import temporal.Temporal;
import temporal.TemporalPackage;
import temporal.VersionHolder;
import temporal.mod.TemporalBaseEObjectImpl;
import temporal.mod.TemporalEStoreHandler;
import temporal.mod.TemporalEStoreImpl;

public class TemporalCopier
extends HashMap {
    protected final Date copyDate;
    protected boolean resolveProxies = true;

    protected TemporalCopier(Date copyDate) {
        this.copyDate = copyDate;
    }

    protected TemporalCopier(Date copyDate, boolean resolveProxies) {
        this.resolveProxies = resolveProxies;
        this.copyDate = copyDate;
    }

    protected void copyReferences() {
        for (Map.Entry entry : this.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            EClass eClass = eObject.eClass();
            int j = 0;
            int size = eClass.getFeatureCount();
            while (j < size) {
                block9: {
                    EStructuralFeature eStructuralFeature;
                    block10: {
                        eStructuralFeature = eClass.getEStructuralFeature(j);
                        if (TemporalEStoreHandler.isFeatureFromTemporalBaseClass(eObject, eStructuralFeature) || !eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) break block9;
                        if (!(eStructuralFeature instanceof EReference)) break block10;
                        EReference eReference = (EReference)eStructuralFeature;
                        if (!eReference.isContainment() && !eReference.isContainer()) {
                            this.copyReference(eReference, eObject, copyEObject);
                        }
                        break block9;
                    }
                    if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) break block9;
                    FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                    FeatureMap copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                    int copyFeatureMapSize = copyFeatureMap.size();
                    int k = 0;
                    int featureMapSize = featureMap.size();
                    while (k < featureMapSize) {
                        block8: {
                            block11: {
                                Object copyReferencedEObject;
                                EStructuralFeature feature;
                                block12: {
                                    feature = featureMap.getEStructuralFeature(k);
                                    if (!(feature instanceof EReference)) break block11;
                                    Object referencedEObject = featureMap.getValue(k);
                                    copyReferencedEObject = this.get(referencedEObject);
                                    if (copyReferencedEObject != null || referencedEObject == null) break block12;
                                    EReference reference = (EReference)feature;
                                    if (reference.isContainment() || reference.getEOpposite() != null) break block8;
                                    copyReferencedEObject = referencedEObject;
                                }
                                if (!copyFeatureMap.add(feature, copyReferencedEObject)) {
                                    int l = 0;
                                    while (l < copyFeatureMapSize) {
                                        if (copyFeatureMap.getEStructuralFeature(l) == feature && copyFeatureMap.getValue(l) == copyReferencedEObject) {
                                            copyFeatureMap.move(copyFeatureMap.size() - 1, l);
                                            --copyFeatureMapSize;
                                            break block8;
                                        }
                                        ++l;
                                    }
                                }
                                break block8;
                            }
                            copyFeatureMap.add((Object)((FeatureMap.Entry)featureMap.get(k)));
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    boolean isBidirectional = eReference.getEOpposite() != null;
                    int index = 0;
                    Iterator k = this.resolveProxies ? source.iterator() : source.basicIterator();
                    while (k.hasNext()) {
                        Object referencedEObject = null;
                        referencedEObject = k.next();
                        Object copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (!isBidirectional) {
                                target.addUnique(index, referencedEObject);
                                ++index;
                                continue;
                            }
                            if (!(referencedEObject instanceof Temporal)) continue;
                            assert (((Temporal)referencedEObject).isContinuity());
                            System.err.println("---------------copying bidirectional ref..");
                            System.err.println("---------------what conditions make this happen??");
                            target.addUnique(index, referencedEObject);
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            int position = target.indexOf(copyReferencedEObject);
                            if (position == -1) {
                                target.addUnique(index, copyReferencedEObject);
                            } else if (index != position) {
                                target.move(index, copyReferencedEObject);
                            }
                        } else {
                            target.addUnique(index, copyReferencedEObject);
                        }
                        ++index;
                    }
                }
            } else {
                Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (referencedEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else {
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (eReference.getEOpposite() == null) {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                        } else if (referencedEObject instanceof Temporal) {
                            assert (((Temporal)referencedEObject).isContinuity());
                            System.err.println("---------------copying bidirectional ref..");
                            System.err.println("---------------what conditions make this happen??");
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                        }
                    } else {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                    }
                }
            }
        }
    }

    protected Collection copyAll(Collection eObjects) {
        ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
        Iterator i = eObjects.iterator();
        while (i.hasNext()) {
            result.add(this.copy((EObject)i.next()));
        }
        return result;
    }

    protected EObject copy(EObject eObject) {
        EObject copyEObject = (EObject)this.get(eObject);
        if (copyEObject != null) {
            return copyEObject;
        }
        copyEObject = this.createCopy(eObject);
        this.put(eObject, copyEObject);
        ((TemporalEStoreImpl)((TemporalBaseEObjectImpl)eObject).eStore()).setBypass(true);
        ((TemporalEStoreImpl)((TemporalBaseEObjectImpl)copyEObject).eStore()).setBypass(true);
        this.copyTemporalAttributes((Temporal)eObject, (Temporal)copyEObject);
        TemporalCopier.attachVersionToContinuity((Temporal)eObject, (Temporal)copyEObject);
        this.addVersionToContainer((Temporal)eObject, (Temporal)copyEObject);
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (!TemporalEStoreHandler.isFeatureFromTemporalBaseClass(eObject, eStructuralFeature) && eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, eObject, copyEObject);
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment()) {
                        this.copyContainment(eReference, eObject, copyEObject);
                    } else if (eReference.getEOpposite() != null) {
                        this.copyBidirectional(eReference, eObject);
                    }
                }
            }
            ++i;
        }
        this.copyProxyURI(eObject, copyEObject);
        return copyEObject;
    }

    protected void copyProxyURI(EObject eObject, EObject copyEObject) {
        if (eObject.eIsProxy()) {
            ((InternalEObject)copyEObject).eSetProxyURI(((InternalEObject)eObject).eProxyURI());
        }
    }

    protected EObject createCopy(EObject eObject) {
        return EcoreUtil.create((EClass)this.getTarget(eObject.eClass()));
    }

    protected EClass getTarget(EClass eClass) {
        return eClass;
    }

    protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature;
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    target.addAll(this.copyAll(source));
                    InternalEObject continuityContainer = (InternalEObject)eObject;
                    int containerFeatureID = ((InternalEObject)source.get(0)).eContainerFeatureID();
                    int i = 0;
                    while (i < target.size()) {
                        Object copyChildEObject = target.get(i);
                        if (copyChildEObject instanceof Temporal) {
                            Temporal continuity = ((Temporal)copyChildEObject).continuity();
                            ((TemporalEStoreImpl)((InternalEObject)copyEObject).eStore()).set((InternalEObject)copyEObject, (EStructuralFeature)eReference, i, continuity);
                            ((InternalEObject)copyChildEObject).eBasicSetContainer(continuityContainer, containerFeatureID, null);
                        }
                        ++i;
                    }
                }
            } else {
                EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                EObject copyChildEObject = childEObject == null ? null : this.copy(childEObject);
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)copyChildEObject);
                if (copyChildEObject instanceof Temporal) {
                    InternalEObject continuityContainer = (InternalEObject)eObject;
                    int containerFeatureID = ((InternalEObject)childEObject).eContainerFeatureID();
                    EObject continuity = childEObject;
                    ((TemporalEStoreImpl)((InternalEObject)copyEObject).eStore()).set((InternalEObject)copyEObject, (EStructuralFeature)eReference, -1, continuity);
                    ((InternalEObject)copyChildEObject).eBasicSetContainer(continuityContainer, containerFeatureID, null);
                }
            }
        }
    }

    protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eAttribute)) {
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
                FeatureMap featureMap = (FeatureMap)eObject.eGet((EStructuralFeature)eAttribute);
                int i = 0;
                int size = featureMap.size();
                while (i < size) {
                    Object value;
                    EStructuralFeature feature = featureMap.getEStructuralFeature(i);
                    if (feature instanceof EReference && ((EReference)feature).isContainment() && (value = featureMap.getValue(i)) != null) {
                        this.copy((EObject)value);
                    }
                    ++i;
                }
            } else if (eAttribute.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eAttribute);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eAttribute));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    target.addAll(source);
                }
            } else {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eAttribute), eObject.eGet((EStructuralFeature)eAttribute));
            }
        }
    }

    protected void copyBidirectional(EReference eReference, EObject eObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                for (EObject itemEObject : source) {
                    assert (itemEObject instanceof Temporal);
                    EObject referencedEObject = (EObject)this.get(itemEObject);
                    if (referencedEObject != null) continue;
                    this.copyOpposite((Temporal)itemEObject);
                }
            } else {
                EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                if (childEObject != null) {
                    assert (childEObject instanceof Temporal);
                    EObject referencedEObject = (EObject)this.get(childEObject);
                    if (referencedEObject == null) {
                        this.copyOpposite((Temporal)childEObject);
                    }
                }
            }
        }
    }

    protected void copyOpposite(Temporal childTemporal) {
        assert (childTemporal.isContinuity());
        Temporal temporalObjectAtNow = childTemporal.currentVersion();
        if (temporalObjectAtNow == null || !temporalObjectAtNow.isDateWithinVersion(this.copyDate)) {
            this.copy(childTemporal);
        } else {
            System.err.println("------------ FYI: skiping creating version.");
            System.err.println("------------ what causes this condition???");
        }
    }

    private void copyTemporalAttributes(Temporal continuity, Temporal newVersion) {
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_Continuity(), false);
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_Date(), continuity.getDate());
        TemporalEStoreHandler.setTouchedAttributes(newVersion, TemporalEStoreHandler.getTouchedAttributes(continuity));
        TemporalEStoreHandler.setTouchedAttributes(continuity, null);
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_VersionHolderContainment(), null);
        newVersion.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_VersionHolder(), null);
        continuity.eSet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_Date(), this.copyDate);
    }

    private void addVersionToContainer(Temporal continuity, Temporal newVersion) {
        InternalEObject continuityContainer = (InternalEObject)continuity.eContainer();
        if (continuityContainer != null) {
            this.copy((EObject)continuityContainer);
        } else {
            Resource resource = continuity.eResource();
            if (resource != null) {
                resource.getContents().add((Object)newVersion);
            }
        }
    }

    private static void attachVersionToContinuity(Temporal continuity, Temporal newVersion) {
        VersionHolder vh = (VersionHolder)continuity.eGet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_VersionHolder());
        EList versions = vh.getVersions();
        assert (continuity.isContinuity());
        assert (!versions.contains((Object)newVersion));
        assert (versions.contains((Object)continuity));
        int indexOfContinuity = vh.getIndexOfContinuity();
        versions.set(indexOfContinuity, (Object)newVersion);
        assert (versions.contains((Object)newVersion));
        assert (!versions.contains((Object)continuity));
        int versionCount = versions.size();
        Date newDateOfContinuity = continuity.getDate();
        int insertIndex = versionCount;
        int i = 0;
        while (i < versionCount) {
            Temporal cur = (Temporal)versions.get(i);
            if (newDateOfContinuity.after(cur.getDate())) {
                insertIndex = i;
                break;
            }
            ++i;
        }
        vh.setIndexOfContinuity(insertIndex);
        versions.add(insertIndex, (Object)continuity);
        assert (versions.contains((Object)newVersion));
        assert (versions.contains((Object)continuity));
        assert (newVersion.eGet((EStructuralFeature)TemporalPackage.eINSTANCE.getTemporal_VersionHolder()) == vh);
    }

    private void resetBypassFlags() {
        for (Map.Entry entry : this.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            ((TemporalEStoreImpl)((TemporalBaseEObjectImpl)eObject).eStore()).setBypass(false);
            ((TemporalEStoreImpl)((TemporalBaseEObjectImpl)copyEObject).eStore()).setBypass(false);
        }
    }

    public static Temporal createVersion(Temporal continuity, Date copyDate) {
        if (!continuity.isContinuity()) {
            throw new UnsupportedOperationException();
        }
        TemporalCopier copier = new TemporalCopier(copyDate);
        Temporal copy = (Temporal)copier.copy(continuity);
        copier.copyReferences();
        copier.resetBypassFlags();
        return copy;
    }

    protected void fixContainments() {
        for (Map.Entry entry : this.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            EClass eClass = eObject.eClass();
            int j = 0;
            int size = eClass.getFeatureCount();
            while (j < size) {
                EReference eReference;
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
                if (!TemporalEStoreHandler.isFeatureFromTemporalBaseClass(eObject, eStructuralFeature) && eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && eStructuralFeature instanceof EReference && ((eReference = (EReference)eStructuralFeature).isContainment() || eReference.isContainer())) {
                    this.fixContainment(eReference, eObject, copyEObject);
                }
                ++j;
            }
        }
    }

    protected void fixContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    ArrayList<EObject> x = new ArrayList<EObject>();
                    Iterator k = this.resolveProxies ? source.iterator() : source.basicIterator();
                    while (k.hasNext()) {
                        EObject obj = (EObject)k.next();
                        if (!(obj instanceof Temporal)) continue;
                        x.add(obj);
                    }
                    for (EObject obj : x) {
                        target.add((Object)obj);
                    }
                }
            } else {
                Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (referencedEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else {
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (eReference.getEOpposite() == null) {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                        } else if (referencedEObject instanceof Temporal) {
                            assert (((Temporal)referencedEObject).isContinuity());
                            System.err.println("---------------copying bidirectional ref..");
                            System.err.println("---------------what conditions make this happen??");
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                        }
                    } else {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                    }
                }
            }
        }
    }
}

