/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.issues.library;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.teneo.samples.issues.library.Book;
import org.eclipse.emf.teneo.samples.issues.library.BookCategory;
import org.eclipse.emf.teneo.samples.issues.library.Library;
import org.eclipse.emf.teneo.samples.issues.library.LibraryPackage;
import org.eclipse.emf.teneo.samples.issues.library.Writer;

public class LibraryFactory
extends EFactoryImpl {
    public static final LibraryFactory eINSTANCE = LibraryFactory.init();

    public static LibraryFactory init() {
        try {
            LibraryFactory theLibraryFactory = (LibraryFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/teneo/samples/issues/supinterfaces");
            if (theLibraryFactory != null) {
                return theLibraryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new LibraryFactory();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBook();
            }
            case 1: {
                return this.createLibrary();
            }
            case 2: {
                return this.createWriter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createBookCategoryFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createBookCategoryObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertBookCategoryToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertBookCategoryObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Book createBook() {
        Book book = new Book();
        return book;
    }

    public Library createLibrary() {
        Library library = new Library();
        return library;
    }

    public Writer createWriter() {
        Writer writer = new Writer();
        return writer;
    }

    public BookCategory createBookCategoryFromString(EDataType eDataType, String initialValue) {
        BookCategory result = BookCategory.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertBookCategoryToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public BookCategory createBookCategoryObjectFromString(EDataType eDataType, String initialValue) {
        return this.createBookCategoryFromString((EDataType)LibraryPackage.Literals.BOOK_CATEGORY, initialValue);
    }

    public String convertBookCategoryObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertBookCategoryToString((EDataType)LibraryPackage.Literals.BOOK_CATEGORY, instanceValue);
    }

    public LibraryPackage getLibraryPackage() {
        return (LibraryPackage)this.getEPackage();
    }

    @Deprecated
    public static LibraryPackage getPackage() {
        return LibraryPackage.eINSTANCE;
    }
}

