/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.sample.sunBooks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BookCategoryType1 implements Enumerator
{
    MAGAZINE_LITERAL(0, "magazine", "magazine"),
    NOVEL_LITERAL(1, "novel", "novel"),
    FICTION_LITERAL(2, "fiction", "fiction"),
    OTHER_LITERAL(3, "other", "other");

    public static final int MAGAZINE = 0;
    public static final int NOVEL = 1;
    public static final int FICTION = 2;
    public static final int OTHER = 3;
    private static final BookCategoryType1[] VALUES_ARRAY;
    public static final List<BookCategoryType1> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BookCategoryType1[]{MAGAZINE_LITERAL, NOVEL_LITERAL, FICTION_LITERAL, OTHER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BookCategoryType1 get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookCategoryType1 result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookCategoryType1 getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookCategoryType1 result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookCategoryType1 get(int value) {
        switch (value) {
            case 0: {
                return MAGAZINE_LITERAL;
            }
            case 1: {
                return NOVEL_LITERAL;
            }
            case 2: {
                return FICTION_LITERAL;
            }
            case 3: {
                return OTHER_LITERAL;
            }
        }
        return null;
    }

    private BookCategoryType1(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

