/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCenterPart
extends Canvas {
    protected Image buffer;
    private double[] baseCenterCurve;

    public AbstractCenterPart(Composite parent) {
        super(parent, 0x340000);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                AbstractCenterPart.this.doubleBufferedPaint(event.gc);
            }
        };
        this.addPaintListener(paintListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractCenterPart.this.buffer != null) {
                    AbstractCenterPart.this.buffer.dispose();
                    AbstractCenterPart.this.buffer = null;
                }
                AbstractCenterPart.this.removePaintListener(paintListener);
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        this.baseCenterCurve = null;
    }

    public abstract void doPaint(GC var1);

    protected void drawLine(GC gc, ModelContentMergeTabItem leftItem, ModelContentMergeTabItem rightItem) {
        int rightY;
        int leftY;
        if (leftItem == null || rightItem == null) {
            return;
        }
        Rectangle drawingBounds = this.getBounds();
        RGB color = ModelContentMergeViewer.getColor(leftItem.getCurveColor());
        if (rightItem.getCurveColor() != leftItem.getCurveColor() && rightItem.getCurveColor() != "changed.color") {
            color = ModelContentMergeViewer.getColor(rightItem.getCurveColor());
        }
        int rightX = drawingBounds.width;
        if (System.getProperty("os.name").contains("Windows")) {
            leftY = leftItem.getCurveY() + 5;
            rightY = rightItem.getCurveY() + 5;
        } else {
            leftY = leftItem.getCurveY() + 5 + leftItem.getVerticalOffset();
            rightY = rightItem.getCurveY() + 5 + rightItem.getVerticalOffset();
        }
        int lineWidth = leftItem.getCurveSize();
        gc.setForeground(new Color((Device)this.getDisplay(), color));
        gc.setLineWidth(lineWidth);
        gc.setLineStyle(1);
        int[] points = this.getCenterCurvePoints(0, leftY, rightX, rightY);
        int i = 1;
        while (i < points.length) {
            gc.drawLine(0 + i - 1, points[i - 1], 0 + i, points[i]);
            ++i;
        }
    }

    protected List<DiffElement> retainVisibleDiffs(List<ModelContentMergeTabItem> leftVisible, List<ModelContentMergeTabItem> rightVisible) {
        ArrayList<DiffElement> visibleDiffs = new ArrayList<DiffElement>(leftVisible.size() + rightVisible.size());
        for (ModelContentMergeTabItem left : leftVisible) {
            visibleDiffs.add(left.getDiff());
        }
        for (ModelContentMergeTabItem right : rightVisible) {
            visibleDiffs.add(right.getDiff());
        }
        return visibleDiffs;
    }

    void doubleBufferedPaint(GC dest) {
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.buffer != null) {
            Rectangle bufferBounds = this.buffer.getBounds();
            if (bufferBounds.width != size.x || bufferBounds.height != size.y) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }
        if (this.buffer == null) {
            this.buffer = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.buffer);
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawLine(0, 0, 0, this.getBounds().height);
        gc.drawLine(this.getBounds().width - 1, 0, this.getBounds().width - 1, this.getBounds().height);
        try {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.buffer, 0, 0);
    }

    private void buildBaseCenterCurve(int width) {
        double doubleWidth = width;
        this.baseCenterCurve = new double[34];
        int i = 0;
        while (i < 34) {
            double r = (double)i / doubleWidth;
            this.baseCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.baseCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.baseCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }
}

