/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernateFeatureMapEntry;
import org.eclipse.emf.teneo.hibernate.resource.HibernateResource;
import org.eclipse.emf.teneo.mapping.elist.PersistableFeatureMap;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.hibernate.Session;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.spi.PersistentCollection;

public class HibernatePersistableFeatureMap
extends PersistableFeatureMap
implements ExtensionPoint {
    private static final long serialVersionUID = -1916994464446630140L;
    private static Log log = LogFactory.getLog(HibernatePersistableFeatureMap.class);

    public HibernatePersistableFeatureMap(InternalEObject owner, EStructuralFeature feature, List<FeatureMap.Entry> list) {
        super(owner, feature, list);
        if (this.isLoaded()) {
            for (FeatureMap.Entry entry : this.getDelegate()) {
                HibernateFeatureMapEntry fme = (HibernateFeatureMapEntry)entry;
                if (fme.belongsToFeatureMap((FeatureMap.Internal)this)) continue;
                fme.setFeatureMap((FeatureMap.Internal)this);
            }
        }
    }

    protected Class<? extends FeatureMap.Entry> determineElementType() {
        return HibernateFeatureMapEntry.class;
    }

    protected FeatureMap.Entry createEntry(EStructuralFeature eStructuralFeature, Object value) {
        HibernateFeatureMapEntry entry = new HibernateFeatureMapEntry();
        entry.setFeatureValue(eStructuralFeature, value, (FeatureMap.Internal)this);
        return entry;
    }

    protected FeatureMap.Entry replaceEntry(Object entry) {
        if (entry instanceof HibernateFeatureMapEntry && ((HibernateFeatureMapEntry)entry).belongsToFeatureMap((FeatureMap.Internal)this)) {
            return (HibernateFeatureMapEntry)entry;
        }
        FeatureMap.Entry emfEntry = (FeatureMap.Entry)entry;
        HibernateFeatureMapEntry fme = new HibernateFeatureMapEntry();
        fme.setFeatureValue(emfEntry.getEStructuralFeature(), emfEntry.getValue(), (FeatureMap.Internal)this);
        return fme;
    }

    public boolean isInitialized() {
        return ((PersistentCollection)this.delegate).wasInitialized();
    }

    public boolean isLoaded() {
        if (this.delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)this.delegate).wasInitialized()) {
            if (this.isLoading()) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persistentlist already initialized, probably eagerly loaded: " + this.getLogString()));
            }
            try {
                this.setIsLoading(true);
                this.doLoad();
                this.setIsLoaded(true);
            }
            finally {
                this.setIsLoading(false);
            }
        }
        return super.isLoaded();
    }

    protected synchronized void doLoad() {
        AssertUtil.assertTrue((String)("EList " + this.logString), (!this.isLoaded() ? 1 : 0) != 0);
        SessionWrapper sessionWrapper = null;
        boolean controlsSession = false;
        boolean err = true;
        try {
            Object[] objs;
            Resource res = this.owner.eResource();
            if (res != null && res instanceof HibernateResource) {
                sessionWrapper = ((HibernateResource)res).getSessionWrapper();
                if (res.isLoaded()) {
                    if (!sessionWrapper.isTransactionActive()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Reconnecting session to read a lazy collection, Featuremap: " + this.logString));
                        }
                        controlsSession = true;
                        sessionWrapper.beginTransaction();
                        sessionWrapper.setFlushModeManual();
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Resource session is still active, using it");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Featuremap uses session from resource, " + this.logString));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"EList is not loaded in session context");
            }
            Object[] objectArray = objs = this.delegate.toArray();
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                InternalEObject eobj;
                Object element = objectArray[n2];
                HibernateFeatureMapEntry fme = (HibernateFeatureMapEntry)element;
                fme.setFeatureMap((FeatureMap.Internal)this);
                if (fme.getEStructuralFeature() instanceof EReference && ((EReference)fme.getEStructuralFeature()).isContainment() && (eobj = (InternalEObject)fme.getValue()) != null) {
                    EContainerRepairControl.setContainer((InternalEObject)this.owner, (InternalEObject)eobj, (EStructuralFeature)fme.getEStructuralFeature());
                    if (res != null && res instanceof StoreResource && fme.getEStructuralFeature() instanceof EReference) {
                        ((StoreResource)res).addToContentOrAttach((InternalEObject)fme.getValue(), (EReference)fme.getEStructuralFeature());
                    }
                }
                ++n2;
            }
            err = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded " + objs.length + " from backend store for " + this.logString));
            }
        }
        finally {
            if (controlsSession) {
                if (err) {
                    sessionWrapper.rollbackTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                } else {
                    sessionWrapper.commitTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                }
            }
        }
    }

    public void replaceDelegate(List<FeatureMap.Entry> newDelegate) {
        if (newDelegate instanceof PersistentList) {
            AssertUtil.assertTrue((String)("This elist " + this.logString + " contains a different list than the " + " passed list"), (boolean)((PersistentList)newDelegate).isWrapper((Object)this.delegate));
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentBag) {
            AssertUtil.assertTrue((String)("This elist " + this.logString + " contains a different list than the " + " passed list"), (boolean)((PersistentBag)newDelegate).isWrapper((Object)this.delegate));
            super.replaceDelegate(newDelegate);
        } else {
            throw new HbMapperException("Type " + newDelegate.getClass().getName() + " can not be " + " used as a replacement for elist " + this.logString);
        }
    }

    public boolean isPersistencyWrapped() {
        return this.delegate instanceof PersistentCollection;
    }

    protected FeatureMap.Entry delegateRemove(int index) {
        FeatureMap.Entry old = super.delegateRemove(index);
        if (old.getEStructuralFeature() instanceof EReference && this.getDelegate() instanceof PersistentList) {
            PersistentList pl = (PersistentList)this.getDelegate();
            EReference eref = (EReference)old.getEStructuralFeature();
            if (eref.isContainment()) {
                ((Session)pl.getSession()).delete(old.getValue());
            }
        }
        return old;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

