/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.pannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FetchType implements Enumerator
{
    LAZY(0, "LAZY", "LAZY"),
    EAGER(1, "EAGER", "EAGER"),
    EXTRA(2, "EXTRA", "EXTRA");

    public static final int LAZY_VALUE = 0;
    public static final int EAGER_VALUE = 1;
    public static final int EXTRA_VALUE = 2;
    private static final FetchType[] VALUES_ARRAY;
    public static final List<FetchType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FetchType[]{LAZY, EAGER, EXTRA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FetchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FetchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FetchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FetchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FetchType get(int value) {
        switch (value) {
            case 0: {
                return LAZY;
            }
            case 1: {
                return EAGER;
            }
            case 2: {
                return EXTRA;
            }
        }
        return null;
    }

    private FetchType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

