/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.property;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class EAttributePropertyHandler
implements Getter,
Setter,
PropertyAccessor {
    private static final long serialVersionUID = 8953817672640618007L;
    private static Log log = LogFactory.getLog(EAttributePropertyHandler.class);
    protected final EAttribute eAttribute;
    protected final Class<?> instanceClass;
    private boolean handleUnsetAsNull = false;
    private boolean convertUnsetToNull = false;
    private boolean isObjectClass = false;

    public EAttributePropertyHandler(EAttribute eAttribute) {
        this.eAttribute = eAttribute;
        this.instanceClass = eAttribute.getEType().getInstanceClass();
        if (eAttribute.getEType().getInstanceClassName() != null) {
            this.isObjectClass = eAttribute.getEType().getInstanceClassName().contains(".");
        }
        AssertUtil.assertTrue((String)(String.valueOf(eAttribute.getName()) + " is a many feature which is not handled by this accessor "), (!eAttribute.isMany() ? 1 : 0) != 0);
        log.debug((Object)("Created getter/setter for " + StoreUtil.toString((EStructuralFeature)eAttribute)));
    }

    public EAttribute getEAttribute() {
        return this.eAttribute;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        EObject eobj;
        if ((this.handleUnsetAsNull || this.convertUnsetToNull) && !(eobj = (EObject)owner).eIsSet((EStructuralFeature)this.eAttribute) && this.eAttribute.isUnsettable()) {
            return null;
        }
        return ((EObject)owner).eGet((EStructuralFeature)this.eAttribute);
    }

    public Object getForInsert(Object arg0, Map arg1, SessionImplementor arg2) throws HibernateException {
        return this.get(arg0);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return this.eAttribute.getEType().getInstanceClass();
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        Class<?> valClass;
        EObject eobj = (EObject)target;
        if (value == null) {
            if (this.handleUnsetAsNull && this.eAttribute.isUnsettable()) {
                eobj.eUnset((EStructuralFeature)this.eAttribute);
            } else if (this.isObjectClass || this.eAttribute instanceof EEnum) {
                eobj.eSet((EStructuralFeature)this.eAttribute, value);
            }
            return;
        }
        Object curValue = this.get(target);
        if (curValue != null && curValue.equals(value)) {
            return;
        }
        if (curValue == value) {
            return;
        }
        Object setValue = value != null && this.instanceClass != null && value.getClass() != this.instanceClass ? ((valClass = value.getClass()) == Integer[].class ? this.convert((Integer[])value) : (valClass == Byte[].class ? this.convert((Byte[])value) : (valClass == Boolean[].class ? this.convert((Boolean[])value) : (valClass == Double[].class ? this.convert((Double[])value) : (valClass == Float[].class ? this.convert((Float[])value) : (valClass == Long[].class ? this.convert((Long[])value) : (valClass == Short[].class ? this.convert((Short[])value) : this.convert(value)))))))) : value;
        eobj.eSet((EStructuralFeature)this.eAttribute, setValue);
    }

    private Object convert(Integer[] arr) {
        if (this.instanceClass != int[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting " + this.instanceClass.getName() + " as instance class but it is: " + arr.getClass().getName()));
            }
            return arr;
        }
        int[] res = new int[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    private Object convert(Boolean[] arr) {
        if (this.instanceClass != boolean[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting " + this.instanceClass.getName() + " as instance class but it is: " + arr.getClass().getName()));
            }
            return arr;
        }
        boolean[] res = new boolean[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    private Object convert(Byte[] arr) {
        if (this.instanceClass != byte[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting " + this.instanceClass.getName() + " as instance class but it is: " + arr.getClass().getName()));
            }
            return arr;
        }
        byte[] res = new byte[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    private Object convert(Double[] arr) {
        if (this.instanceClass != double[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting " + this.instanceClass.getName() + " as instance class but it is: " + arr.getClass().getName()));
            }
            return arr;
        }
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    private Object convert(Float[] arr) {
        if (this.instanceClass != float[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting " + this.instanceClass.getName() + " as instance class but it is: " + arr.getClass().getName()));
            }
            return arr;
        }
        float[] res = new float[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i].floatValue();
            ++i;
        }
        return res;
    }

    private Object convert(Long[] arr) {
        if (this.instanceClass != long[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting [] as instance class but it is: " + this.instanceClass.getName()));
            }
            return arr;
        }
        long[] res = new long[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    private Object convert(Short[] arr) {
        if (this.instanceClass != short[].class) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting short[] as instance class but it is: " + this.instanceClass.getName()));
            }
            return arr;
        }
        short[] res = new short[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    private Object convert(Object arr) {
        if (!(arr == null || this.instanceClass == null || this.instanceClass.isPrimitive() && arr.getClass().isPrimitive())) {
            log.debug((Object)("Expecting " + this.instanceClass.getName() + " as instance class but it is: " + arr.getClass().getName()));
        }
        return arr;
    }

    public void setPersistenceOptions(PersistenceOptions po) {
        this.handleUnsetAsNull = po.getHandleUnsetAsNull();
        this.convertUnsetToNull = po.getConvertUnsetToNull();
    }
}

