/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImageButton
extends Label
implements MouseTrackListener,
MouseMoveListener,
MouseListener {
    private final Image image;
    private final Image grayImage;
    private boolean inImage;

    public ImageButton(Composite parent, Image image) {
        this(parent, image, new Image((Device)parent.getDisplay(), image, 2));
    }

    public ImageButton(Composite parent, Image image, Image grayImage) {
        super(parent, 0);
        this.image = image;
        this.grayImage = grayImage;
        this.setImage(grayImage);
        this.addMouseTrackListener(this);
        this.addMouseMoveListener(this);
        this.addMouseListener(this);
    }

    public void mouseEnter(MouseEvent e) {
        this.mouseMove(e);
    }

    public void mouseExit(MouseEvent e) {
        this.mouseMove(e);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        Rectangle bounds = this.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        this.inImage = bounds.contains(e.x, e.y);
        if (this.inImage) {
            this.setImage(this.image);
        } else {
            this.setImage(this.grayImage);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (this.inImage) {
            this.widgetSelected();
        }
    }

    protected void checkSubclass() {
    }

    protected void widgetSelected() {
    }
}

