/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.EtypesFactory;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Dependency;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.Impact;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamMode;
import org.eclipse.emf.cdo.lm.StreamSpec;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyFactory;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.LMNamingStrategy;
import org.eclipse.emf.cdo.lm.internal.client.LMResourceSetConfiguration;
import org.eclipse.emf.cdo.lm.internal.client.SystemManager;
import org.eclipse.emf.cdo.lm.internal.client.TimeStamp;
import org.eclipse.emf.cdo.lm.internal.client.bundle.OM;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.lm.util.LMMerger;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewCommitInfoListener;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.CDOPermissionUpdater;
import org.eclipse.emf.spi.cdo.CDOPermissionUpdater2;
import org.eclipse.emf.spi.cdo.CDOPermissionUpdater3;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.TMPUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OSGiUtil;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class SystemDescriptor
implements ISystemDescriptor {
    public static final SystemDescriptor NO_SYSTEM = new SystemDescriptor();
    private static final String KEY_SYSTEM_DESCRIPTOR = ISystemDescriptor.class.getName();
    private static final String KEY_MODULE_NAME = "org.eclipse.emf.cdo.lm.client.ModuleName";
    private static final String PROP_BASELINE_INDEX = "baseline.index";
    private static final String JVM_ACCEPTOR_TYPE = "jvm";
    private static final String JVM_ACCEPTOR_NAME = "local";
    private final IListener systemListener = new CDOViewCommitInfoListener(){

        public void notifyCommitInfo(CDOCommitInfo commitInfo) {
            commitInfo.forEachRevisionDelta(revisionDelta -> {
                EClass eClass = revisionDelta.getEClass();
                if (eClass == LMPackage.Literals.SYSTEM) {
                    this.forEachListDelta((CDORevisionDelta)revisionDelta, LMPackage.Literals.SYSTEM__MODULES, o -> SystemManager.INSTANCE.fireModuleCreatedEvent(SystemDescriptor.this, (Module)o), id -> SystemManager.INSTANCE.fireModuleDeletedEvent(SystemDescriptor.this, (CDOID)id));
                } else if (eClass == LMPackage.Literals.MODULE) {
                    this.forEachListDelta((CDORevisionDelta)revisionDelta, LMPackage.Literals.MODULE__STREAMS, o -> SystemManager.INSTANCE.fireBaselineCreatedEvent(SystemDescriptor.this, (Baseline)((Stream)o)), null);
                } else if (eClass == LMPackage.Literals.STREAM) {
                    this.forEachListDelta((CDORevisionDelta)revisionDelta, LMPackage.Literals.STREAM__CONTENTS, o -> SystemManager.INSTANCE.fireBaselineCreatedEvent(SystemDescriptor.this, (Baseline)o), null);
                    CDOSetFeatureDelta maintenanceBranchDelta = (CDOSetFeatureDelta)revisionDelta.getFeatureDelta((EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_BRANCH);
                    if (maintenanceBranchDelta != null) {
                        CDOID streamID = revisionDelta.getID();
                        Stream stream = (Stream)SystemDescriptor.this.systemView.getObject(streamID);
                        String value = (String)maintenanceBranchDelta.getValue();
                        CDOBranchRef newBranch = value == null ? null : new CDOBranchRef(value);
                        SystemManager.INSTANCE.fireStreamBranchChangedEvent(SystemDescriptor.this, stream, newBranch);
                    }
                }
            });
        }

        private void forEachListDelta(CDORevisionDelta revisionDelta, EReference feature, Consumer<CDOObject> additionConsumer, Consumer<CDOID> removalConsumer) {
            CDOListFeatureDelta listDelta = (CDOListFeatureDelta)revisionDelta.getFeatureDelta((EStructuralFeature)feature);
            if (listDelta != null) {
                for (CDOFeatureDelta listChange : listDelta.getListChanges()) {
                    CDOID id;
                    CDOAddFeatureDelta delta;
                    if (additionConsumer != null && listChange instanceof CDOAddFeatureDelta) {
                        delta = (CDOAddFeatureDelta)listChange;
                        id = (CDOID)delta.getValue();
                        CDOObject newObject = SystemDescriptor.this.systemView.getObject(id);
                        additionConsumer.accept(newObject);
                        continue;
                    }
                    if (removalConsumer == null || !(listChange instanceof CDORemoveFeatureDelta)) continue;
                    delta = (CDORemoveFeatureDelta)listChange;
                    id = (CDOID)delta.getValue();
                    removalConsumer.accept(id);
                }
            }
        }
    };
    private final CDORepository systemRepository;
    private final String systemName;
    private CDOView systemView;
    private System system;
    private String error;
    private ISystemDescriptor.State state = ISystemDescriptor.State.Closed;
    private final Map<String, CDORepository> moduleRepositories = new HashMap<String, CDORepository>();

    private SystemDescriptor() {
        this.systemRepository = null;
        this.systemName = null;
    }

    public SystemDescriptor(CDORepository systemRepository, String systemName) {
        CheckUtil.checkArg((Object)systemRepository, (String)"systemRepository");
        CheckUtil.checkArg((Object)systemName, (String)"systemName");
        this.systemRepository = systemRepository;
        this.systemName = systemName;
    }

    @Override
    public CDORepository getSystemRepository() {
        return this.systemRepository;
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public System getSystem() {
        return this.system;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public ISystemDescriptor.State getState() {
        return this.state;
    }

    @Override
    public boolean isOpen() {
        return this.system != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        boolean opened = false;
        System newSystem = null;
        SystemDescriptor systemDescriptor = this;
        synchronized (systemDescriptor) {
            if (this.state == ISystemDescriptor.State.Closed) {
                try {
                    this.state = ISystemDescriptor.State.Opening;
                    this.system = null;
                    CDOSession systemSession = this.systemRepository.acquireSession();
                    systemSession.properties().put((Object)KEY_SYSTEM_DESCRIPTOR, (Object)this);
                    CDOSession.Options options = systemSession.options();
                    options.setPermissionUpdater(this.createPermissionUpdater(options));
                    this.systemView = systemSession.openView();
                    this.systemView.addListener(this.systemListener);
                    CDOResource resource = this.systemView.getResource("/system");
                    newSystem = this.system = (System)resource.getContents().get(0);
                    this.state = ISystemDescriptor.State.Open;
                }
                catch (Error | RuntimeException ex) {
                    this.state = ISystemDescriptor.State.Closed;
                    LifecycleUtil.deactivate((Object)this.systemView);
                    this.systemView = null;
                    throw ex;
                }
                opened = true;
            }
        }
        if (opened) {
            SystemManager.INSTANCE.fireDescriptorStateEvent(this, newSystem, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean closed = false;
        System oldSystem = null;
        SystemDescriptor systemDescriptor = this;
        synchronized (systemDescriptor) {
            if (this.isOpen()) {
                this.state = ISystemDescriptor.State.Closing;
                oldSystem = this.system;
                try {
                    for (CDORepository moduleRepository : this.moduleRepositories.values()) {
                        CDOSession moduleSession = moduleRepository.getSession();
                        if (moduleSession != null) {
                            IRegistry properties = moduleSession.properties();
                            properties.remove((Object)KEY_SYSTEM_DESCRIPTOR);
                            properties.remove((Object)KEY_MODULE_NAME);
                        }
                        moduleRepository.disconnect();
                    }
                    CDOSession systemSession = this.systemView.getSession();
                    systemSession.properties().remove((Object)KEY_SYSTEM_DESCRIPTOR);
                    this.systemView.removeListener(this.systemListener);
                    this.systemView.close();
                    this.systemRepository.releaseSession();
                }
                finally {
                    this.system = null;
                    this.systemView = null;
                    this.state = ISystemDescriptor.State.Closed;
                }
                closed = true;
            }
        }
        if (closed) {
            SystemManager.INSTANCE.fireDescriptorStateEvent(this, oldSystem, false);
        }
    }

    @Override
    public int compareTo(ISystemDescriptor o) {
        if (this == NO_SYSTEM || o == NO_SYSTEM) {
            throw new IllegalStateException();
        }
        return this.systemName.compareTo(o.getSystemName());
    }

    public String toString() {
        return this.systemName == null ? "NO_SYSTEM" : this.systemName;
    }

    @Override
    public <E extends ModelElement, R> R modify(E element, Function<E, R> modifier, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        EObject result;
        block8: {
            result = null;
            if (element.cdoView() != this.systemView) {
                element = (ModelElement)this.systemView.getObject(element);
            }
            CDOSession session = this.systemView.getSession();
            CDOTransaction transaction = session.openTransaction();
            try {
                try {
                    ModelElement transactionalElement = (ModelElement)transaction.getObject(element);
                    result = (EObject)modifier.apply(transactionalElement);
                    CDOCommitInfo commitInfo = transaction.commit(monitor);
                    long commitTime = commitInfo.getTimeStamp();
                    if (!this.systemView.waitForUpdate(commitTime, 10000L)) {
                        throw new TimeoutRuntimeException("System view did not receive the update of commit " + commitTime);
                    }
                    if (result instanceof CDOObject) {
                        EObject object;
                        result = object = this.systemView.getObject((EObject)((CDOObject)result));
                    }
                }
                catch (OperationCanceledException ex) {
                    transaction.rollback();
                    transaction.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                transaction.close();
                throw throwable;
            }
            transaction.close();
        }
        return (R)result;
    }

    @Override
    public <R> R modify(Function<System, R> modifier, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.modify(this.system, modifier, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getModuleNames() {
        SystemDescriptor systemDescriptor = this;
        synchronized (systemDescriptor) {
            return this.moduleRepositories.keySet().toArray(new String[this.moduleRepositories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDORepository[] getModuleRepositories() {
        SystemDescriptor systemDescriptor = this;
        synchronized (systemDescriptor) {
            return this.moduleRepositories.values().toArray(new CDORepository[this.moduleRepositories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDORepository getModuleRepository(String moduleName) {
        CDORepository moduleRepository;
        SystemDescriptor systemDescriptor = this;
        synchronized (systemDescriptor) {
            moduleRepository = this.moduleRepositories.get(moduleName);
            if (moduleRepository == null) {
                moduleRepository = this.connectModuleRepository(moduleName);
                this.moduleRepositories.put(moduleName, moduleRepository);
            }
        }
        return moduleRepository;
    }

    private CDORepository connectModuleRepository(String moduleName) {
        String label = "_LM_Module_" + this.systemName + "_" + moduleName;
        CDORepository moduleRepository = CDOExplorerUtil.getRepositoryManager().getRepositoryByLabel(label);
        if (moduleRepository == null) {
            moduleRepository = this.createModuleRepository(moduleName, label);
        }
        moduleRepository.connect();
        CDOSession moduleSession = moduleRepository.getSession();
        if (moduleSession != null) {
            IRegistry properties = moduleSession.properties();
            properties.put((Object)KEY_SYSTEM_DESCRIPTOR, (Object)this);
            properties.put((Object)KEY_MODULE_NAME, (Object)moduleName);
        }
        return moduleRepository;
    }

    private CDORepository createModuleRepository(String moduleName, String label) {
        Properties properties = this.initModuleRepositoryProperties();
        properties.setProperty("label", label);
        properties.setProperty("name", moduleName);
        properties.setProperty("keywords", "org.eclipse.emf.cdo.lm.Module");
        IPasswordCredentials credentials = this.systemRepository.getCredentials();
        return CDOExplorerUtil.getRepositoryManager().addRepository(properties, credentials);
    }

    private Properties initModuleRepositoryProperties() {
        String systemRepositoryType = this.systemRepository.getType();
        if ("remote".equals(systemRepositoryType)) {
            return this.systemRepository.getProperties();
        }
        if (JVM_ACCEPTOR_NAME.equals(systemRepositoryType)) {
            IManagedContainer container = this.systemRepository.getContainer();
            Net4jUtil.getAcceptor((IManagedContainer)container, (String)JVM_ACCEPTOR_TYPE, (String)JVM_ACCEPTOR_NAME);
            Properties properties = new Properties();
            properties.setProperty("type", "remote");
            properties.setProperty("connectorType", JVM_ACCEPTOR_TYPE);
            properties.setProperty("connectorDescription", JVM_ACCEPTOR_NAME);
            Properties systemRepositoryProperties = this.systemRepository.getProperties();
            boolean securityDisabled = systemRepositoryProperties.get("securityDisabled") != Boolean.FALSE;
            properties.setProperty("authenticating", Boolean.toString(!securityDisabled));
            return properties;
        }
        throw new IllegalStateException("Illegal system repository type: " + systemRepositoryType);
    }

    private CDOPermissionUpdater createPermissionUpdater(CDOSession.Options options) {
        final CDOPermissionUpdater oldPermissionUpdater = options.getPermissionUpdater();
        if (oldPermissionUpdater instanceof CDOPermissionUpdater3) {
            final CDOPermissionUpdater3 oldPermissionUpdater3 = (CDOPermissionUpdater3)oldPermissionUpdater;
            return new CDOPermissionUpdater3(){

                public Map<CDORevision, CDOPermission> updatePermissions(InternalCDOSession session, Map<CDOBranchPoint, Set<InternalCDORevision>> revisions, CDOCommitInfo commitInfo) {
                    SystemDescriptor.this.updateModulePermissions();
                    return oldPermissionUpdater3.updatePermissions(session, revisions, commitInfo);
                }
            };
        }
        if (oldPermissionUpdater instanceof CDOPermissionUpdater2) {
            final CDOPermissionUpdater2 oldPermissionUpdater2 = (CDOPermissionUpdater2)oldPermissionUpdater;
            return new CDOPermissionUpdater2(){

                public Map<CDORevision, CDOPermission> updatePermissions(InternalCDOSession session, Set<InternalCDORevision> revisions) {
                    SystemDescriptor.this.updateModulePermissions();
                    return oldPermissionUpdater2.updatePermissions(session, revisions);
                }

                public Map<CDORevision, CDOPermission> updatePermissions(InternalCDOSession session, Set<InternalCDORevision> revisions, CDOCommitInfo commitInfo) {
                    SystemDescriptor.this.updateModulePermissions();
                    return oldPermissionUpdater2.updatePermissions(session, revisions, commitInfo);
                }
            };
        }
        return new CDOPermissionUpdater(){

            public Map<CDORevision, CDOPermission> updatePermissions(InternalCDOSession session, Set<InternalCDORevision> revisions) {
                SystemDescriptor.this.updateModulePermissions();
                return oldPermissionUpdater.updatePermissions(session, revisions);
            }
        };
    }

    private void updateModulePermissions() {
        CDORepository[] cDORepositoryArray = this.getModuleRepositories();
        int n = cDORepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDORepository moduleRepository = cDORepositoryArray[n2];
            try {
                this.withModuleSession(moduleRepository, (CDOSession session) -> {
                    Map map = ((InternalCDOSession)session).updatePermissions();
                });
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public boolean withModuleSession(String moduleName, Consumer<CDOSession> consumer) {
        CDORepository moduleRepository = this.getModuleRepository(moduleName);
        return this.withModuleSession(moduleRepository, consumer);
    }

    @Override
    public boolean withModuleSession(CDORepository moduleRepository, Consumer<CDOSession> consumer) {
        CDOSession session = moduleRepository.acquireSession();
        if (session != null) {
            try {
                consumer.accept(session);
            }
            finally {
                moduleRepository.releaseSession();
            }
            return true;
        }
        return false;
    }

    @Override
    public ModuleDefinition extractModuleDefinition(Baseline baseline) {
        String moduleName = baseline.getModule().getName();
        if (baseline instanceof FixedBaseline) {
            FixedBaseline fixedBaseline = (FixedBaseline)baseline;
            ModuleDefinition moduleDefinition = ModulesFactory.eINSTANCE.createModuleDefinition();
            moduleDefinition.setName(moduleName);
            moduleDefinition.setVersion(fixedBaseline.getVersion());
            for (Dependency dependency : fixedBaseline.getDependencies()) {
                Module target = dependency.getTarget();
                if (target == null) continue;
                moduleDefinition.getDependencies().add((Object)ModulesFactory.eINSTANCE.createDependencyDefinition(target.getName(), dependency.getVersionRange()));
            }
            return moduleDefinition;
        }
        return this.extractModuleDefinitionModuleDefinition((FloatingBaseline)baseline, 0L, moduleName);
    }

    @Override
    public ModuleDefinition extractModuleDefinition(FloatingBaseline baseline, long timeStamp) {
        String moduleName = baseline.getModule().getName();
        return this.extractModuleDefinitionModuleDefinition(baseline, timeStamp, moduleName);
    }

    private ModuleDefinition extractModuleDefinitionModuleDefinition(FloatingBaseline baseline, long timeStamp, String moduleName) {
        ModuleDefinition[] result = new ModuleDefinition[1];
        this.withModuleSession(moduleName, (CDOSession session) -> {
            try (CDOView view = null;){
                CDOBranchRef branchRef = baseline.getBranch();
                CDOBranch branch = branchRef.resolve(session.getBranchManager());
                view = session.openView(branch, timeStamp);
                moduleDefinitionArray[0] = this.extractModuleDefinition(view);
            }
        });
        return result[0];
    }

    @Override
    public ModuleDefinition extractModuleDefinition(CDOView view) {
        String moduleDefinitionPath = this.system.getProcess().getModuleDefinitionPath();
        try {
            CDOResource moduleDefinitionResource = view.getResource(moduleDefinitionPath);
            ModuleDefinition moduleDefinition = (ModuleDefinition)moduleDefinitionResource.getContents().get(0);
            return (ModuleDefinition)EcoreUtil.copy((EObject)moduleDefinition);
        }
        catch (CDOResourceNodeNotFoundException ex) {
            return null;
        }
    }

    public Map<String, CDOView> configureModuleResourceSet(CDOView view) throws ISystemDescriptor.ResolutionException {
        ModuleDefinition rootDefinition = this.extractModuleDefinition(view);
        if (rootDefinition != null) {
            Assembly assembly = AssemblyFactory.eINSTANCE.createAssembly();
            try {
                this.resolveDependencies(rootDefinition, assembly, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProvisionException ex) {
                OM.LOG.error((Throwable)ex);
                return null;
            }
            ResourceSet resourceSet = view.getResourceSet();
            return this.configureModuleResourceSet(resourceSet, assembly);
        }
        return null;
    }

    private Map<String, CDOView> configureModuleResourceSet(ResourceSet resourceSet, Assembly assembly) {
        HashMap<String, CDOView> moduleViews = new HashMap<String, CDOView>();
        assembly.forEachDependency(module -> {
            CDOView view = LMResourceSetConfiguration.openView(this, module, resourceSet);
            if (view != null) {
                moduleViews.put(module.getName(), view);
            }
        });
        return moduleViews;
    }

    @Override
    public Assembly resolve(ModuleDefinition rootDefinition, Baseline rootBaseline, IProgressMonitor monitor) throws ISystemDescriptor.ResolutionException {
        Assembly assembly = AssemblyFactory.eINSTANCE.createAssembly();
        assembly.setSystemName(this.systemName);
        String rootModuleName = rootDefinition.getName();
        Version rootModuleVersion = rootDefinition.getVersion();
        CDOBranchPointRef rootBranchPoint = rootBaseline.getBranchPoint();
        AssemblyModule rootModule = AssemblyFactory.eINSTANCE.createAssemblyModule();
        rootModule.setAssembly(assembly);
        rootModule.setName(rootModuleName);
        rootModule.setVersion(rootModuleVersion);
        rootModule.setBranchPoint(rootBranchPoint);
        rootModule.setRoot(true);
        SystemDescriptor.addAnnotation(rootModule, rootBaseline, rootDefinition);
        try {
            this.resolveDependencies(rootDefinition, assembly, monitor);
        }
        catch (ProvisionException ex) {
            OM.LOG.error((Throwable)ex);
            return null;
        }
        return assembly;
    }

    private void resolveDependencies(ModuleDefinition rootDefinition, Assembly assembly, IProgressMonitor monitor) throws ISystemDescriptor.ResolutionException, ProvisionException {
        ArrayList<FixedBaseline> baselines = new ArrayList<FixedBaseline>();
        ArrayList ius = new ArrayList();
        this.system.forEachBaseline(baseline -> {
            FixedBaseline fixedBaseline;
            String moduleName;
            if (baseline instanceof FixedBaseline && !Objects.equals(moduleName = (fixedBaseline = (FixedBaseline)baseline).getModule().getName(), rootDefinition.getName())) {
                String baselineIndex = Integer.toString(baselines.size());
                baselines.add(fixedBaseline);
                ModuleDefinition moduleDefinition2 = this.extractModuleDefinition((Baseline)fixedBaseline);
                MetadataFactory.InstallableUnitDescription iuDescription = SystemDescriptor.createIUDescription(moduleDefinition2);
                iuDescription.setProperty(PROP_BASELINE_INDEX, baselineIndex);
                IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription);
                ius.add(iu);
            }
        });
        File agentLocation = TMPUtil.createTempFolder((String)"lm-p2-");
        IProvisioningAgent provisioningAgent = null;
        try {
            agentLocation.mkdirs();
            provisioningAgent = SystemDescriptor.createProvisioningAgent(agentLocation);
            IProfileRegistry profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
            IProfile profile = profileRegistry.addProfile("TEMP", null);
            IInstallableUnit rootIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)SystemDescriptor.createIUDescription(rootDefinition));
            IPlanner planner = (IPlanner)provisioningAgent.getService(IPlanner.SERVICE_NAME);
            IProfileChangeRequest profileChangeRequest = planner.createChangeRequest(profile);
            profileChangeRequest.add(rootIU);
            profileChangeRequest.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", StringUtil.TRUE);
            final CollectionResult metadata = new CollectionResult(ius);
            ProvisioningContext provisioningContext = new ProvisioningContext(provisioningAgent){

                public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
                    return metadata;
                }
            };
            IProvisioningPlan provisioningPlan = planner.getProvisioningPlan(profileChangeRequest, provisioningContext, monitor);
            IStatus status = provisioningPlan.getStatus();
            if (!status.isOK()) {
                throw SystemDescriptor.createResolutionException(status, rootIU, baselines);
            }
            IQueryable futureState = provisioningPlan.getFutureState();
            IQueryResult matches = futureState.query(QueryUtil.createIUQuery(null, (VersionRange)VersionRange.emptyRange), monitor);
            for (IInstallableUnit iu : matches) {
                FixedBaseline baseline2 = SystemDescriptor.getBaseline(iu, baselines);
                if (baseline2 == null) continue;
                AssemblyModule assemblyModule = AssemblyFactory.eINSTANCE.createAssemblyModule();
                assemblyModule.setAssembly(assembly);
                assemblyModule.setName(baseline2.getModule().getName());
                assemblyModule.setVersion(baseline2.getVersion());
                assemblyModule.setBranchPoint(baseline2.getBranchPoint());
                SystemDescriptor.addAnnotation(assemblyModule, (Baseline)baseline2, null);
            }
        }
        finally {
            if (provisioningAgent != null) {
                provisioningAgent.stop();
            }
            if (agentLocation.isDirectory()) {
                IOUtil.delete((File)agentLocation);
            }
        }
        assembly.sortModules();
    }

    @Override
    public Module createModule(String name, StreamSpec streamSpec, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.createModule(name, null, streamSpec, monitor);
    }

    @Override
    public Module createModule(String name, ModuleType type, StreamSpec streamSpec, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.modify(system -> {
            Stream stream = streamSpec.createStream();
            stream.setAllowedChanges(Impact.MAJOR);
            Module module = LMFactory.eINSTANCE.createModule();
            module.setName(name);
            module.setType(type);
            module.getStreams().add((Object)stream);
            system.getModules().add((Object)module);
            SystemDescriptor.setCommitComment((CDOObject)system, "Add module '" + name + "' and stream '" + stream.getName() + "'");
            return module;
        }, monitor);
    }

    @Override
    public void deleteModule(Module module, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, ISystemDescriptor.ModuleDeletionException {
        CDOView view = module.cdoView();
        String moduleName = module.getName();
        List result = view.queryXRefs((CDOObject)module, new EReference[]{LMPackage.Literals.DEPENDENCY__TARGET});
        if (!result.isEmpty()) {
            throw new ISystemDescriptor.ModuleDeletionException(moduleName, result);
        }
        this.modify(module, m -> {
            SystemDescriptor.setCommitComment((CDOObject)m, "Delete module '" + moduleName + "'");
            EcoreUtil.remove((EObject)m);
            return null;
        }, monitor);
    }

    @Override
    public Stream createStream(Module module, Drop base, StreamSpec streamSpec, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.modify(module, m -> {
            Stream stream = streamSpec.createStream();
            stream.setBase(base);
            stream.setStartTimeStamp(base.getBranchPoint().getTimeStamp());
            m.getStreams().add((Object)stream);
            SystemDescriptor.setCommitComment((CDOObject)m, "Add stream '" + stream.getName() + "'");
            return stream;
        }, monitor);
    }

    @Override
    public Drop createDrop(Stream stream, DropType dropType, long timeStamp, String label, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.modify(stream, s -> {
            Version lastVersion;
            int lastMicro;
            Drop lastRelease;
            ModuleDefinition moduleDefinition = this.extractModuleDefinition((FloatingBaseline)s, timeStamp);
            String moduleName = moduleDefinition.getName();
            Version moduleVersion = moduleDefinition.getVersion();
            int major = (Integer)moduleVersion.getSegment(0);
            int minor = (Integer)moduleVersion.getSegment(1);
            int micro = (Integer)moduleVersion.getSegment(2);
            int streamMajor = s.getMajorVersion();
            int streamMinor = s.getMinorVersion();
            if (major != streamMajor || minor != streamMinor) {
                throw new CDOException(MessageFormat.format("Module definition version {0} is inconsistent with the stream version {1}.{2}", moduleVersion, streamMajor, streamMinor));
            }
            if (dropType.isRelease() && (lastRelease = s.getLastRelease()) != null && micro <= (lastMicro = ((Integer)(lastVersion = lastRelease.getVersion()).getSegment(2)).intValue())) {
                throw new CDOException(MessageFormat.format("Module definition version {0} is not greater than the last released version {1}", moduleVersion, lastVersion));
            }
            String qualifier = TimeStamp.toString(timeStamp);
            moduleVersion = Version.createOSGi((int)major, (int)minor, (int)micro, (String)qualifier);
            Drop drop = LMFactory.eINSTANCE.createDrop();
            drop.setType(dropType);
            drop.setLabel(label);
            drop.setVersion(moduleVersion);
            CDOBranchPointRef branchPoint = s.getBranchPoint(timeStamp);
            drop.setBranchPoint(branchPoint);
            this.addDependencies(moduleDefinition, (FixedBaseline)drop);
            s.insertContent((Baseline)drop);
            if (dropType.isRelease()) {
                this.withModuleSession(moduleName, (CDOSession session) -> {
                    if (s.getMode() == StreamMode.DEVELOPMENT) {
                        CDOBranch developmentBranch = s.getDevelopmentBranch().resolve(session.getBranchManager());
                        CDOBranch maintenanceBranch = developmentBranch.createBranch(String.valueOf(streamMajor) + "." + streamMinor + "-maintenance", timeStamp);
                        s.setMaintenanceBranch(new CDOBranchRef(maintenanceBranch));
                        s.setMaintenanceTimeStamp(timeStamp);
                    }
                });
            }
            SystemDescriptor.setCommitComment((CDOObject)s, "Add " + dropType.getName().toLowerCase() + " '" + label + "' to stream '" + stream.getName() + "'");
            return drop;
        }, monitor);
    }

    @Override
    public Change createChange(Stream stream, FixedBaseline base, String label, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        String branchName = LMNamingStrategy.getChangeBranchName(label);
        return this.modify(stream, s -> {
            Change change = LMFactory.eINSTANCE.createChange();
            change.setBase(base);
            change.setLabel(label);
            s.insertContent((Baseline)change);
            String moduleName = s.getModule().getName();
            this.withModuleSession(moduleName, (CDOSession session) -> {
                CDOBranchPoint baseBranchPoint = (base == null ? stream.getBranch().getPointRef(java.lang.System.currentTimeMillis()) : base.getBranchPoint()).resolve(session.getBranchManager());
                CDOBranch changeBranch = baseBranchPoint.getBranch().createBranch(branchName, baseBranchPoint.getTimeStamp());
                change.setBranch(new CDOBranchRef(changeBranch));
            });
            SystemDescriptor.setCommitComment((CDOObject)s, "Add change '" + change.getName() + "' to stream '" + stream.getName() + "'");
            return change;
        }, monitor);
    }

    @Override
    public void renameChange(Change change, String newLabel, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        String branchName = LMNamingStrategy.getChangeBranchName(newLabel);
        this.modify(change, c -> {
            String oldLabel = c.getLabel();
            String moduleName = c.getModule().getName();
            this.withModuleSession(moduleName, (CDOSession session) -> {
                CDOBranchRef branchRef = c.getBranch();
                CDOBranch branch = branchRef.resolve(session.getBranchManager());
                branch.setName(branchName);
                c.setLabel(newLabel);
                c.setBranch(new CDOBranchRef(branch));
            });
            SystemDescriptor.setCommitComment((CDOObject)c, "Rename change '" + oldLabel + "' to '" + newLabel + "'");
            return null;
        }, monitor);
    }

    @Override
    public void deleteChange(Change change, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, ISystemDescriptor.ChangeDeletionException {
        String moduleName = change.getModule().getName();
        if (!change.getDeliveries().isEmpty()) {
            throw new ISystemDescriptor.ChangeDeletionException(change);
        }
        CDOBranchRef changeBranchRef = this.modify(change, c -> {
            String label = c.getLabel();
            Stream stream = c.getStream();
            CDOBranchRef branchRef = c.getBranch();
            SystemDescriptor.setCommitComment((CDOObject)stream, "Delete change '" + label + "'");
            EcoreUtil.remove((EObject)c);
            return branchRef;
        }, monitor);
        if (changeBranchRef != null && FSMUtil.isInvalid((CDOObject)change)) {
            this.withModuleSession(moduleName, (CDOSession session) -> {
                CDOBranch branchToDelete = changeBranchRef.resolve(session.getBranchManager());
                branchToDelete.delete((OMMonitor)new EclipseMonitor(monitor));
            });
        }
    }

    @Override
    public Delivery createDelivery(Stream stream, Change change, LMMerger merger, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        Delivery[] result = new Delivery[1];
        CommitException[] commitException = new CommitException[1];
        String moduleName = stream.getModule().getName();
        this.withModuleSession(moduleName, (CDOSession session) -> {
            CDOBranchRef sourceBranchRef = change.getBranch();
            CDOBranchRef targetBranchRef = stream.getBranch();
            CDOBranchManager branchManager = session.getBranchManager();
            CDOBranch sourceBranch = sourceBranchRef.resolve(branchManager);
            CDOBranch targetBranch = targetBranchRef.resolve(branchManager);
            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            long sourceCommitTime = commitInfoManager.getLastCommitOfBranch(sourceBranch, true);
            CDOBranchPointRef sourceBranchPointRef = sourceBranchRef.getPointRef(sourceCommitTime);
            CDOBranchPoint sourceBranchPoint = sourceBranch.getPoint(sourceCommitTime);
            long targetCommitTime = merger.mergeDelivery(session, sourceBranchPoint, targetBranch);
            if (targetCommitTime != -1L) {
                CDOBranchPointRef targetBranchPointRef = stream.getBranch().getPointRef(targetCommitTime);
                ModuleDefinition moduleDefinition = this.extractModuleDefinition((FloatingBaseline)stream, targetCommitTime);
                Version moduleVersion = moduleDefinition.getVersion();
                try {
                    deliveryArray[0] = this.modify(stream, s -> {
                        CDOTransaction transaction = (CDOTransaction)s.cdoView();
                        Change c = (Change)transaction.getObject((EObject)change);
                        Delivery delivery = LMFactory.eINSTANCE.createDelivery();
                        delivery.setChange(c);
                        delivery.setVersion(moduleVersion);
                        delivery.setMergeSource(sourceBranchPointRef);
                        delivery.setMergeTarget(targetBranchPointRef);
                        this.addDependencies(moduleDefinition, (FixedBaseline)delivery);
                        s.insertContent((Baseline)delivery);
                        SystemDescriptor.setCommitComment((CDOObject)s, "Add delivery '" + delivery.getName() + "' to stream '" + s.getName() + "'");
                        return delivery;
                    }, monitor);
                }
                catch (CommitException ex) {
                    commitExceptionArray[0] = ex;
                }
            }
        });
        if (commitException[0] != null) {
            throw commitException[0];
        }
        return result[0];
    }

    private void addDependencies(ModuleDefinition from, FixedBaseline to) {
        for (DependencyDefinition dependencyDefinition : from.getDependencies()) {
            String targetName = dependencyDefinition.getTargetName();
            Module targetModule = this.system.getModule(targetName);
            Dependency dependency = LMFactory.eINSTANCE.createDependency();
            dependency.setTarget(targetModule);
            dependency.setVersionRange(dependencyDefinition.getVersionRange());
            to.getDependencies().add((Object)dependency);
        }
    }

    private static void setCommitComment(CDOObject object, String comment) {
        CDOTransaction transaction = (CDOTransaction)object.cdoView();
        transaction.setCommitComment(comment);
    }

    private static MetadataFactory.InstallableUnitDescription createIUDescription(ModuleDefinition moduleDefinition) {
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        for (DependencyDefinition dependencyDefinition : moduleDefinition.getDependencies()) {
            String targetName = dependencyDefinition.getTargetName();
            VersionRange versionRange = dependencyDefinition.getVersionRange();
            if (versionRange == null) {
                versionRange = VersionRange.emptyRange;
            }
            IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)targetName, (VersionRange)versionRange, null, (boolean)false, (boolean)false, (boolean)true);
            requirements.add(requirement);
        }
        String name = moduleDefinition.getName();
        Version version = moduleDefinition.getVersion();
        IProvidedCapability selfCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)name, (Version)version);
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId(name);
        iuDescription.setVersion(version);
        iuDescription.setSingleton(true);
        iuDescription.addProvidedCapabilities(Collections.singleton(selfCapability));
        iuDescription.addRequirements(requirements);
        iuDescription.setArtifacts(new IArtifactKey[0]);
        return iuDescription;
    }

    private static IProvisioningAgent createProvisioningAgent(File agentLocation) throws ProvisionException {
        BundleContext context = OSGiUtil.getBundleContext((OMBundle)OM.BUNDLE);
        ServiceReference providerRef = null;
        IProvisioningAgent provisioningAgent = null;
        try {
            providerRef = context.getServiceReference(IProvisioningAgentProvider.class);
            if (providerRef != null) {
                IProvisioningAgentProvider provider = (IProvisioningAgentProvider)context.getService(providerRef);
                provisioningAgent = provider.createAgent(agentLocation.toURI());
            }
        }
        finally {
            if (providerRef != null) {
                context.ungetService(providerRef);
            }
        }
        return provisioningAgent;
    }

    private static ISystemDescriptor.ResolutionException createResolutionException(IStatus status, IInstallableUnit rootIU, List<FixedBaseline> baselines) {
        if (status instanceof PlannerStatus) {
            PlannerStatus plannerStatus = (PlannerStatus)status;
            Set explanations = plannerStatus.getRequestStatus().getExplanations();
            ArrayList<ISystemDescriptor.ResolutionException.Reason> reasons = new ArrayList<ISystemDescriptor.ResolutionException.Reason>();
            for (Explanation explanation : explanations) {
                if (explanation instanceof Explanation.MissingIU) {
                    Explanation.MissingIU missingIU = (Explanation.MissingIU)explanation;
                    ISystemDescriptor.ResolutionException.Reason.Module module = SystemDescriptor.createReasonModule(missingIU.iu, rootIU, baselines);
                    if (missingIU.req == null) {
                        reasons.add(new ISystemDescriptor.ResolutionException.Reason.Missing(module, null));
                        continue;
                    }
                    IRequiredCapability req = (IRequiredCapability)missingIU.req;
                    reasons.add(new ISystemDescriptor.ResolutionException.Reason.Missing(module, new ISystemDescriptor.ResolutionException.Reason.Dependency(req.getName(), req.getRange())));
                    continue;
                }
                if (!(explanation instanceof Explanation.Singleton)) continue;
                Explanation.Singleton singleton = (Explanation.Singleton)explanation;
                ArrayList<ISystemDescriptor.ResolutionException.Reason.Module> modules = new ArrayList<ISystemDescriptor.ResolutionException.Reason.Module>();
                IInstallableUnit[] iInstallableUnitArray = singleton.ius;
                int n = singleton.ius.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallableUnit iu = iInstallableUnitArray[n2];
                    ISystemDescriptor.ResolutionException.Reason.Module module = SystemDescriptor.createReasonModule(iu, rootIU, baselines);
                    modules.add(module);
                    ++n2;
                }
                reasons.add(new ISystemDescriptor.ResolutionException.Reason.Conflicting(modules.toArray(new ISystemDescriptor.ResolutionException.Reason.Module[modules.size()])));
            }
            return new ISystemDescriptor.ResolutionException(reasons.toArray(new ISystemDescriptor.ResolutionException.Reason[reasons.size()]));
        }
        return new ISystemDescriptor.ResolutionException(null);
    }

    private static ISystemDescriptor.ResolutionException.Reason.Module createReasonModule(IInstallableUnit iu, IInstallableUnit rootIU, List<FixedBaseline> baselines) {
        if (iu == rootIU) {
            return new ISystemDescriptor.ResolutionException.Reason.Module(rootIU.getId(), rootIU.getVersion());
        }
        FixedBaseline baseline = SystemDescriptor.getBaseline(iu, baselines);
        if (baseline != null) {
            return new ISystemDescriptor.ResolutionException.Reason.Module(baseline.getModule().getName(), baseline.getVersion());
        }
        return null;
    }

    private static FixedBaseline getBaseline(IInstallableUnit iu, List<FixedBaseline> baselines) {
        String property = iu.getProperty(PROP_BASELINE_INDEX);
        if (property != null) {
            int baselineIndex = Integer.parseInt(property);
            return baselines.get(baselineIndex);
        }
        return null;
    }

    private static void addAnnotation(AssemblyModule module, Baseline baseline, ModuleDefinition definition) {
        Annotation annotation = EtypesFactory.eINSTANCE.createAnnotation();
        annotation.setSource("http://www.eclipse.org/CDO/LM");
        module.getAnnotations().add((Object)annotation);
        EMap details = annotation.getDetails();
        details.put((Object)"baselineID", (Object)CDOExplorerUtil.getCDOIDString((CDOID)baseline.cdoID()));
        details.put((Object)"baselineType", (Object)baseline.getTypeName());
        details.put((Object)"baselineName", (Object)baseline.getName());
        if (definition != null) {
            annotation.getContents().addAll(EcoreUtil.copyAll((Collection)definition.getDependencies()));
        }
    }

    public static ISystemDescriptor getSystemDescriptor(CDOSession session) {
        return (ISystemDescriptor)session.properties().get((Object)KEY_SYSTEM_DESCRIPTOR);
    }

    public static String getModuleName(CDOSession session) {
        return (String)session.properties().get((Object)KEY_MODULE_NAME);
    }
}

