/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LoadChunkIndication
extends CDOServerReadIndication {
    private CDOID id;
    private CDOBranchVersion branchVersion;
    private EStructuralFeature feature;
    private int fromIndex;
    private int toIndex;

    public LoadChunkIndication(CDOServerProtocol protocol) {
        super(protocol, (short)9);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readCDOID();
        this.branchVersion = in.readCDOBranchVersion();
        EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
        int featureID = in.readXInt();
        this.feature = eClass.getEStructuralFeature(featureID);
        this.fromIndex = in.readXInt();
        this.toIndex = in.readXInt();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalRepository repository = this.getRepository();
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        InternalCDORevision revision = revisionManager.getRevisionByVersion(this.id, this.branchVersion, 0, true);
        repository.ensureChunk(revision, this.feature, this.fromIndex, this.toIndex + 1);
        CDOType type = CDOModelUtil.getType((EStructuralFeature)this.feature);
        CDOList list = revision.getListOrNull(this.feature);
        if (list != null) {
            int i = this.fromIndex;
            while (i <= this.toIndex) {
                Object value = list.get(i);
                type.writeValue(out, value);
                ++i;
            }
        }
    }
}

