/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.gmf.notifications.impl;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.gmf.editors.impl.DawnGMFEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnTransactionHandler;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.InvalidObjectException;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.swt.widgets.Display;

public class DawnGMFHandler
extends BasicDawnTransactionHandler {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnGMFHandler.class);

    public DawnGMFHandler(IDawnEditor editor) {
        super(editor);
    }

    public void handleViewInvalidationEvent(CDOViewInvalidationEvent event) {
        CDOViewInvalidationEvent e = event;
        if (TRACER.isEnabled()) {
            TRACER.format("Detached Objects {0} ", new Object[]{e.getDetachedObjects()});
            TRACER.format("Dirty Objects {0} ", new Object[]{e.getDirtyObjects()});
        }
        this.adjustDeletedEdges(e);
        for (CDOObject dirtyObject : e.getDirtyObjects()) {
            this.handleObject(dirtyObject);
        }
        for (CDOObject detachedObject : e.getDetachedObjects()) {
            this.handleObject(detachedObject);
        }
    }

    public void handleTransactionConflictEvent(CDOTransactionConflictEvent event) {
        CDOObject cdoObject = event.getConflictingObject();
        EObject element = CDOUtil.getEObject((EObject)cdoObject);
        View view = DawnDiagramUpdater.findView(element);
        if (DawnConflictHelper.isConflicted((EObject)cdoObject)) {
            DawnConflictHelper.handleConflictedView(cdoObject, view, DawnGMFEditorSupport.getDiagramEditor(this.editor));
            return;
        }
    }

    public void modifyingObject(CDOTransaction transaction, final CDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            TRACER.format("modifyingObject {0}", new Object[]{object});
        }
        this.refresh(object);
        this.editor.setDirty();
        object.eAdapters().add((Object)new Adapter(){

            public void setTarget(Notifier newTarget) {
            }

            public void notifyChanged(Notification notification) {
                DiagramDocumentEditor diagramEditor = DawnGMFEditorSupport.getDiagramEditor(DawnGMFHandler.this.editor);
                DawnDiagramUpdater.refreshEditPart((EditPart)diagramEditor.getDiagramEditPart(), diagramEditor);
                object.eAdapters().remove((Object)this);
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public Notifier getTarget() {
                return null;
            }
        });
    }

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
        super.attachingObject(transaction, object);
        this.refresh(object);
    }

    public void adjustDeletedEdges(final CDOViewInvalidationEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (CDOObject obj : e.getDetachedObjects()) {
                    final EObject view = CDOUtil.getEObject((EObject)obj);
                    if (!(view instanceof Edge)) continue;
                    EditingDomain editingDomain = ((IEditingDomainProvider)view.eResource().getResourceSet()).getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editingDomain){

                        protected void doExecute() {
                            try {
                                ((Edge)view).setTarget(null);
                            }
                            catch (InvalidObjectException invalidObjectException) {
                                // empty catch block
                            }
                            try {
                                ((Edge)view).setSource(null);
                            }
                            catch (InvalidObjectException invalidObjectException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        });
    }

    protected void handleConflicts(CDOViewInvalidationEvent e) {
        for (CDOObject obj : e.getDetachedObjects()) {
            EObject element = CDOUtil.getEObject((EObject)obj);
            View view = DawnDiagramUpdater.findViewByContainer(element);
            DawnConflictHelper.handleConflictedView(CDOUtil.getCDOObject((EObject)element), view, DawnGMFEditorSupport.getDiagramEditor(this.editor));
        }
    }

    private void handleObject(CDOObject dirtyObject) {
        EditPart relatedEditPart;
        if (dirtyObject.cdoInvalid()) {
            return;
        }
        EObject element = CDOUtil.getEObject((EObject)dirtyObject);
        View view = DawnDiagramUpdater.findView(element);
        DiagramDocumentEditor diagramEditor = DawnGMFEditorSupport.getDiagramEditor(this.editor);
        DiagramEditPart diagramEditPart = diagramEditor == null ? null : diagramEditor.getDiagramEditPart();
        EditPartViewer viewer = diagramEditPart == null ? null : diagramEditPart.getViewer();
        EditPart editPart = relatedEditPart = viewer == null ? null : DawnDiagramUpdater.findEditPart(view, viewer);
        if (relatedEditPart != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating EditPart {0} ", new Object[]{relatedEditPart});
            }
            DawnDiagramUpdater.refreshEditPart(relatedEditPart.getParent(), diagramEditor);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating DiagramEditPart {0} ", new Object[]{diagramEditPart});
            }
            DawnDiagramUpdater.refreshEditPart((EditPart)diagramEditPart, diagramEditor);
        }
    }

    protected void refresh(CDOObject object) {
        EditPart relatedEditPart;
        DiagramDocumentEditor diagramEditor = DawnGMFEditorSupport.getDiagramEditor(this.editor);
        View view = DawnDiagramUpdater.findViewByContainer((EObject)object);
        if (view == null) {
            view = DawnDiagramUpdater.findViewForModel((EObject)object, diagramEditor);
        }
        if (view == null) {
            DawnDiagramUpdater.findViewFromCrossReferences((EObject)object);
        }
        DiagramEditPart diagramEditPart = diagramEditor == null ? null : diagramEditor.getDiagramEditPart();
        EditPartViewer viewer = diagramEditPart == null ? null : diagramEditPart.getViewer();
        EditPart editPart = relatedEditPart = viewer == null ? null : DawnDiagramUpdater.findEditPart(view, viewer);
        if (relatedEditPart != null) {
            EditPart parent;
            if (TRACER.isEnabled()) {
                TRACER.format("Updating EditPart {0} ", new Object[]{relatedEditPart});
            }
            if ((parent = relatedEditPart.getParent()) instanceof IGraphicalEditPart) {
                DawnDiagramUpdater.refresh((IGraphicalEditPart)parent);
            } else {
                DawnDiagramUpdater.refreshEditPart(parent, diagramEditor);
            }
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating DiagramEditPart {0} ", new Object[]{DawnGMFEditorSupport.getDiagramEditor(this.editor).getDiagramEditPart()});
            }
            DawnDiagramUpdater.refresh((IGraphicalEditPart)diagramEditor.getDiagramEditPart());
        }
    }
}

