/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class PropertiesFactory
extends Factory {
    public static final String PROPERTY_SEPARATOR = "|";
    public static final String DEFAULT_KEY = "_";

    public PropertiesFactory(FactoryKey key) {
        super(key);
    }

    public PropertiesFactory(String productGroup, String type) {
        super(productGroup, type);
    }

    public Map<String, String> getPropertiesFor(Object product) {
        String description = this.getDescriptionFor(product);
        return PropertiesFactory.parseProperties(description);
    }

    @Override
    public Object create(String description) throws ProductCreationException {
        Map<String, String> properties = PropertiesFactory.parseProperties(description);
        return this.create(properties);
    }

    protected abstract Object create(Map<String, String> var1) throws ProductCreationException;

    public static String createDescription(Map<String, String> properties) {
        StringBuilder builder = new StringBuilder();
        String defaultValue = properties.remove(DEFAULT_KEY);
        if (!StringUtil.isEmpty(defaultValue)) {
            builder.append(defaultValue);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            StringUtil.appendSeparator(builder, PROPERTY_SEPARATOR);
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    public static Map<String, String> parseProperties(String description) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!StringUtil.isEmpty(description)) {
            String[] segments;
            String[] stringArray = segments = description.split("\\|");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (!StringUtil.isEmpty(segment)) {
                    int pos = segment.indexOf(61);
                    if (pos != -1) {
                        String key = segment.substring(0, pos).trim();
                        String value = segment.substring(pos + 1).trim();
                        properties.put(key, value);
                    } else {
                        properties.put(DEFAULT_KEY, segment);
                    }
                }
                ++n2;
            }
        }
        return properties;
    }
}

