/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.derby;

import java.sql.SQLException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.spi.db.DBAdapter;

public abstract class DerbyAdapter
extends DBAdapter {
    public static final String VERSION = "10.3.2.1";
    private static final String[] RESERVED_WORDS = new String[]{"ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "LIKE", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NVARCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "YEAR"};

    public DerbyAdapter(String name) {
        super(name, VERSION);
    }

    protected DerbyAdapter(String name, String version) {
        super(name, version);
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BOOLEAN: 
            case BIT: 
            case TINYINT: {
                return "SMALLINT";
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                return "BLOB";
            }
        }
        return super.getTypeName(field);
    }

    public String[] getReservedWords() {
        return RESERVED_WORDS;
    }

    public boolean isValidFirstChar(char ch) {
        switch (ch) {
            case '_': {
                return false;
            }
        }
        return super.isValidFirstChar(ch);
    }

    public boolean isDuplicateKeyException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "23505".equals(sqlState) || super.isDuplicateKeyException(ex);
    }

    public boolean isTableNotFoundException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "42X05".equals(sqlState) || super.isTableNotFoundException(ex);
    }

    public boolean isColumnNotFoundException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "42X04".equals(sqlState) || super.isColumnNotFoundException(ex);
    }
}

