/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.dialogs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.internal.client.LMResourceSetConfiguration;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.AbstractResourceSelectionDialog;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.widgets.Shell;

public class SelectModuleResourcesDialog
extends AbstractResourceSelectionDialog<LMResourceSetConfiguration> {
    private final LMResourceSetConfiguration configuration;
    private final Map<AssemblyModule, CDOView> views = new LinkedHashMap<AssemblyModule, CDOView>();

    public SelectModuleResourcesDialog(Shell shell, boolean multi, LMResourceSetConfiguration configuration) {
        super(shell, multi, "Select Module Resources", "Select resources from the current module and its dependencies.", OM.Activator.INSTANCE.loadImageDescriptor("icons/NewModule.png"));
        this.configuration = configuration;
        if (configuration != null) {
            Assembly assembly = configuration.getAssembly();
            AssemblyModule rootModule = assembly.getRootModule();
            this.views.put(rootModule, CDOUtil.getViewSet((Notifier)configuration.getResourceSet()).getViews()[0]);
            assembly.forEachDependency(module -> {
                CDOView cDOView = this.views.put((AssemblyModule)module, configuration.getView(module));
            });
        }
    }

    protected LMResourceSetConfiguration getInput() {
        return this.configuration;
    }

    protected boolean elementHasChildren(Object object, Predicate<Object> defaultHasChildren) {
        if (object == this.views) {
            return !this.views.isEmpty();
        }
        return super.elementHasChildren(object, defaultHasChildren);
    }

    protected Object[] elementGetChildren(Object object, Function<Object, Object[]> defaultGetChildren) {
        if (object == this.configuration) {
            return this.views.keySet().toArray();
        }
        if (object instanceof AssemblyModule) {
            AssemblyModule module = (AssemblyModule)object;
            CDOView view = this.views.get(module);
            CDOResource rootResource = view.getRootResource();
            return defaultGetChildren.apply(rootResource);
        }
        return super.elementGetChildren(object, defaultGetChildren);
    }

    protected Object elementGetParent(Object object, Function<Object, Object> defaultGetParent) {
        if (object instanceof CDOResourceNode) {
            CDOResourceNode node = (CDOResourceNode)object;
            CDOResourceFolder folder = node.getFolder();
            if (folder == null) {
                CDOView view = node.cdoView();
                for (Map.Entry<AssemblyModule, CDOView> entry : this.views.entrySet()) {
                    if (entry.getValue() != view) continue;
                    return entry.getKey();
                }
                return null;
            }
            return folder;
        }
        if (object instanceof AssemblyModule) {
            return this.configuration;
        }
        return super.elementGetParent(object, defaultGetParent);
    }

    protected String elementGetText(Object object, Function<Object, String> defaultGetText) {
        if (object instanceof AssemblyModule) {
            AssemblyModule module = (AssemblyModule)object;
            return String.valueOf(module.getName()) + " " + module.getVersion();
        }
        return super.elementGetText(object, defaultGetText);
    }
}

