/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.util.CDONameProvider;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public final class CDOCommonUtil {
    public static final String UNSPECIFIED_DATE_STRING = "*";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'.'SSS");
    public static final Pattern DATE_PATTERN = Pattern.compile("(\\d+)[ -/](\\d+)[ -/](\\d+)( +(\\d+):?(\\d*):?(\\d*)\\.?(\\d*))?");
    public static final String SYSTEM_USER_ID = "CDO_SYSTEM";
    public static final Comparator<CDONameProvider> NAME_COMPARATOR = new Comparator<CDONameProvider>(){

        @Override
        public int compare(CDONameProvider o1, CDONameProvider o2) {
            String n1 = StringUtil.safe((String)o1.getName()).toLowerCase();
            String n2 = StringUtil.safe((String)o2.getName()).toLowerCase();
            return n1.compareTo(n2);
        }
    };
    public static final Comparator<CDOTimeProvider> TIME_COMPARATOR = new Comparator<CDOTimeProvider>(){

        @Override
        public int compare(CDOTimeProvider o1, CDOTimeProvider o2) {
            return CDOCommonUtil.compareTimeStamps(o1.getTimeStamp(), o2.getTimeStamp());
        }
    };

    private CDOCommonUtil() {
    }

    public static CDODataInput createCDODataInput(ExtendedDataInputStream inputStream, final CDOPackageRegistry packageRegistry, final CDOBranchManager branchManager, final CDOCommitInfoManager commitManager, final CDORevisionFactory revisionFactory, final CDOListFactory listFactory, final CDOLobStore lobStore) throws IOException {
        return new CDODataInputImpl((ExtendedDataInput)inputStream){

            @Override
            public CDOPackageRegistry getPackageRegistry() {
                return packageRegistry;
            }

            @Override
            protected CDOBranchManager getBranchManager() {
                return branchManager;
            }

            @Override
            protected CDOCommitInfoManager getCommitInfoManager() {
                return commitManager;
            }

            @Override
            protected CDORevisionFactory getRevisionFactory() {
                return revisionFactory;
            }

            @Override
            protected CDOListFactory getListFactory() {
                return listFactory;
            }

            @Override
            protected CDOLobStore getLobStore() {
                return lobStore;
            }
        };
    }

    @Deprecated
    public static CDODataOutput createCDODataOutput(ExtendedDataOutput extendedDataOutputStream, CDOPackageRegistry packageRegistry, CDOIDProvider idProvider) {
        return CDOCommonUtil.createCDODataOutput(extendedDataOutputStream, packageRegistry, idProvider, null);
    }

    public static CDODataOutput createCDODataOutput(ExtendedDataOutput extendedDataOutputStream, final CDOPackageRegistry packageRegistry, final CDOIDProvider idProvider, final CDORevisionUnchunker unchunker) {
        return new CDODataOutputImpl(extendedDataOutputStream){

            @Override
            public CDOPackageRegistry getPackageRegistry() {
                return packageRegistry;
            }

            @Override
            public CDOIDProvider getIDProvider() {
                return idProvider;
            }

            @Override
            public CDORevisionUnchunker getRevisionUnchunker() {
                return unchunker;
            }
        };
    }

    public static boolean isWellFormedURI(String uri) {
        try {
            return !StringUtil.isEmpty((String)uri) && uri.equals(URI.createURI((String)uri, (boolean)true).toString());
        }
        catch (Throwable exception) {
            return false;
        }
    }

    public static boolean isValidTimeStamp(long timeStamp, long startTime, long endTime) {
        if (timeStamp == 0L) {
            return endTime == 0L;
        }
        return (endTime == 0L || endTime >= timeStamp) && timeStamp >= startTime;
    }

    public static int compareTimeStamps(long t1, long t2) {
        if (t1 == 0L) {
            t1 = Long.MAX_VALUE;
        }
        if (t2 == 0L) {
            t2 = Long.MAX_VALUE;
        }
        if (t1 < t2) {
            return -1;
        }
        if (t1 > t2) {
            return 1;
        }
        return 0;
    }

    public static String formatTimeStamp() {
        return CDOCommonUtil.formatTimeStamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimeStamp(long timeStamp) {
        if (timeStamp == 0L) {
            return UNSPECIFIED_DATE_STRING;
        }
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(new Date(timeStamp));
        }
    }

    public static long parseTimeStamp(String timeStamp) throws ParseException {
        String trimmed = timeStamp.trim();
        if (UNSPECIFIED_DATE_STRING.equals(trimmed)) {
            return 0L;
        }
        Matcher matcher = DATE_PATTERN.matcher(trimmed);
        if (!matcher.matches()) {
            throw new ParseException("Not a valid date: " + trimmed + " --> pattern = " + DATE_PATTERN, 0);
        }
        timeStamp = String.valueOf(matcher.group(1)) + "-" + matcher.group(2) + "-" + matcher.group(3) + " " + CDOCommonUtil.safe(matcher.group(5)) + ":" + CDOCommonUtil.safe(matcher.group(6)) + ":" + CDOCommonUtil.safe(matcher.group(7)) + "." + CDOCommonUtil.safe(matcher.group(8));
        Date date = DATE_FORMAT.parse(timeStamp);
        return date.getTime();
    }

    private static String safe(String value) {
        return StringUtil.isEmpty((String)value) ? "0" : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitWhileInitial(CDOCommonRepository repository, INotifier notifier, IProgressMonitor monitor) {
        double rest = 1.0E7;
        if (monitor != null) {
            monitor.beginTask("Waiting for repository " + repository.getName() + " to become initialized...", (int)rest);
        }
        IListener listener = null;
        try {
        }
        catch (InterruptedException ex) {
            return false;
        }
        finally {
            if (repository.getState() == CDOCommonRepository.State.INITIAL) {
            }
            return true;
        }
    }
}

