/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.net.URISyntaxException;
import org.eclipse.net4j.internal.ws.WSClientConnector;
import org.eclipse.net4j.internal.ws.WSConnector;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.spi.net4j.ConnectorFactory;

public class WSConnectorFactory
extends ConnectorFactory {
    public static final String TYPE = "ws";

    public WSConnectorFactory() {
        super(TYPE);
    }

    protected WSConnectorFactory(String type) {
        super(type);
    }

    public WSClientConnector create(String description) throws ProductCreationException {
        WSClientConnector connector = this.createConnector();
        try {
            connector.setURL(String.valueOf(this.getType()) + "://" + description);
        }
        catch (URISyntaxException ex) {
            throw new ProductCreationException((Throwable)ex);
        }
        return connector;
    }

    protected WSClientConnector createConnector() {
        return new WSClientConnector();
    }

    public String getDescriptionFor(Object object) {
        if (object instanceof WSConnector) {
            WSConnector connector = (WSConnector)object;
            return connector.getURL();
        }
        return null;
    }
}

