/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.bugzilla;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.net4j.internal.jvm.JVMAcceptor;
import org.eclipse.net4j.internal.jvm.JVMAcceptorFactory;
import org.eclipse.net4j.internal.jvm.JVMClientConnector;
import org.eclipse.net4j.internal.jvm.JVMServerConnector;
import org.eclipse.net4j.internal.tcp.TCPAcceptor;
import org.eclipse.net4j.internal.tcp.TCPAcceptorFactory;
import org.eclipse.net4j.internal.tcp.TCPServerConnector;
import org.eclipse.net4j.internal.tcp.ssl.SSLAcceptor;
import org.eclipse.net4j.internal.tcp.ssl.SSLAcceptorFactory;
import org.eclipse.net4j.internal.tcp.ssl.SSLServerConnector;
import org.eclipse.net4j.internal.ws.WSAcceptor;
import org.eclipse.net4j.internal.ws.WSAcceptorFactory;
import org.eclipse.net4j.internal.ws.WSServerConnector;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalConnector;

public class Bugzilla_241463_Test
extends AbstractConfigTest {
    @Override
    protected IManagedContainer createContainer() {
        IManagedContainer container = super.createContainer();
        container.registerFactory((IFactory)new FakeJVMAcceptorFactory());
        container.registerFactory((IFactory)new FakeTCPAcceptorFactory());
        container.registerFactory((IFactory)new FakeSSLAcceptorFactory());
        container.registerFactory((IFactory)new FakeWSAcceptorFactory());
        return container;
    }

    public void testBugzilla241463() throws Exception {
        this.startTransport();
        this.getConnector().setOpenChannelTimeout(2000L);
        try {
            new TestSignalProtocol(this.getConnector());
            Bugzilla_241463_Test.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class FakeJVMAcceptorFactory
    extends JVMAcceptorFactory {
        private FakeJVMAcceptorFactory() {
        }

        public JVMAcceptor create(String description) {
            JVMAcceptor acceptor = new JVMAcceptor(){

                public JVMServerConnector handleAccept(JVMClientConnector client) {
                    JVMServerConnector connector = new JVMServerConnector(this, client){

                        public InternalChannel inverseOpenChannel(short channelID, String protocolID, int protocolVersion) {
                            throw new RuntimeException("Simulated problem");
                        }
                    };
                    this.prepareConnector((InternalConnector)connector);
                    connector.setName(client.getName());
                    connector.activate();
                    this.addConnector((InternalConnector)connector);
                    return connector;
                }
            };
            acceptor.setName(description);
            return acceptor;
        }
    }

    private static final class FakeSSLAcceptorFactory
    extends SSLAcceptorFactory {
        private FakeSSLAcceptorFactory() {
        }

        public SSLAcceptor create(String description) {
            SSLAcceptor acceptor = new SSLAcceptor(){

                public void handleAccept(ITCPSelector selector, ServerSocketChannel serverSocketChannel) {
                    try {
                        SocketChannel socketChannel = serverSocketChannel.accept();
                        if (socketChannel != null) {
                            socketChannel.configureBlocking(false);
                            SSLServerConnector connector = new SSLServerConnector(this){

                                public InternalChannel inverseOpenChannel(short channelID, String protocolID, int protocolVersion) {
                                    throw new RuntimeException("Simulated problem");
                                }
                            };
                            this.prepareConnector((InternalConnector)connector);
                            connector.setSocketChannel(socketChannel);
                            connector.setSelector(selector);
                            connector.activate();
                        }
                    }
                    catch (ClosedChannelException ex) {
                        this.deactivateAsync();
                    }
                    catch (Exception ex) {
                        this.deactivateAsync();
                    }
                }
            };
            acceptor.setAddress("0.0.0.0");
            acceptor.setPort(ITCPAcceptor.DEFAULT_PORT);
            return acceptor;
        }
    }

    private static final class FakeTCPAcceptorFactory
    extends TCPAcceptorFactory {
        private FakeTCPAcceptorFactory() {
        }

        public TCPAcceptor create(String description) {
            TCPAcceptor acceptor = new TCPAcceptor(){

                protected TCPServerConnector createConnector() {
                    return new TCPServerConnector(this){

                        public InternalChannel inverseOpenChannel(short channelID, String protocolID, int protocolVersion) {
                            throw new RuntimeException("Simulated problem");
                        }
                    };
                }
            };
            acceptor.setAddress("0.0.0.0");
            acceptor.setPort(ITCPAcceptor.DEFAULT_PORT);
            return acceptor;
        }
    }

    private static final class FakeWSAcceptorFactory
    extends WSAcceptorFactory {
        private FakeWSAcceptorFactory() {
        }

        protected WSAcceptor createAcceptor() {
            return new WSAcceptor(){

                protected WSServerConnector createConnector() {
                    return new WSServerConnector(this){

                        public InternalChannel inverseOpenChannel(short channelID, String protocolID, int protocolVersion) {
                            throw new RuntimeException("Simulated problem");
                        }
                    };
                }
            };
        }
    }
}

