/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.tests.model1.Customer;
import org.eclipse.emf.cdo.tests.model1.Order;
import org.eclipse.emf.cdo.tests.model1.OrderDetail;
import org.eclipse.emf.cdo.tests.model1.Product1;
import org.eclipse.emf.cdo.tests.model1.PurchaseOrder;
import org.eclipse.emf.cdo.tests.model1.SalesOrder;
import org.eclipse.emf.cdo.tests.model1.VAT;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.io.IOUtil;

public class SQLQueryTest
extends AbstractCDOTest {
    private static final int NUM_OF_PRODUCTS = 20;
    private static final int NUM_OF_CUSTOMERS = 5;
    private static final int NUM_OF_PRODUCTS_CUSTOMER = 4;
    private static final int NUM_OF_SALES_ORDERS = 5;

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testSimpleQueries() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for products with a specific name");
        CDOQuery query = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_PRODUCT1 WHERE name=:name");
        query.setParameter("name", (Object)"1");
        List products = query.getResult(Product1.class);
        SQLQueryTest.assertEquals((int)1, (int)products.size());
        SQLQueryTest.msg((Object)"Query for Customers");
        query = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_CUSTOMER");
        List customers = query.getResult(Customer.class);
        SQLQueryTest.assertEquals((int)5, (int)customers.size());
        SQLQueryTest.msg((Object)"Query for products with VAT15");
        query = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_PRODUCT1 WHERE VAT =:vat");
        query.setParameter("vat", (Object)VAT.VAT15.getValue());
        products = query.getResult(Product1.class);
        SQLQueryTest.assertEquals((int)10, (int)products.size());
        for (Product1 p : products) {
            SQLQueryTest.assertEquals((Object)p.getVat(), (Object)VAT.VAT15);
        }
        transaction.commit();
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testFunctions() throws Exception {
        int intResult;
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Count products");
        CDOQuery query = transaction.createQuery("sql", "SELECT COUNT(*) from MODEL1_PRODUCT1");
        query.setParameter("cdoObjectQuery", (Object)false);
        List counts = query.getResult(Object.class);
        SQLQueryTest.assertEquals((int)counts.size(), (int)1);
        Object result = counts.get(0);
        if (result instanceof Integer) {
            intResult = (Integer)result;
        } else {
            SQLQueryTest.assertEquals((boolean)true, (boolean)(result instanceof Long));
            intResult = ((Long)result).intValue();
        }
        SQLQueryTest.assertEquals((int)20, (int)intResult);
        transaction.commit();
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testComplexQuerySalesOrderJoinCustomerProduct() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for customers");
        CDOQuery customerQuery = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_CUSTOMER ORDER BY NAME");
        List customers = customerQuery.getResult(Customer.class);
        SQLQueryTest.assertEquals((int)5, (int)customers.size());
        SQLQueryTest.msg((Object)"Query for products");
        CDOQuery productQuery = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_PRODUCT1");
        List products = productQuery.getResult(Product1.class);
        SQLQueryTest.assertEquals((int)20, (int)products.size());
        transaction.commit();
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testDateParameter() throws Exception {
        Date aDate = new GregorianCalendar(2020, 4, 2, 6, 45, 14).getTime();
        IOUtil.OUT().println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss-SSS").format(aDate));
        CDOSession session = this.openSession();
        PurchaseOrder purchaseOrder = this.getModel1Factory().createPurchaseOrder();
        purchaseOrder.setDate(aDate);
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        resource.getContents().add((Object)purchaseOrder);
        resource.getContents().add((Object)this.getModel1Factory().createPurchaseOrder());
        transaction.commit();
        String column = "date";
        if (((IDBStore)this.getRepository().getStore()).getDBAdapter().isReservedWord(column)) {
            column = String.valueOf(column) + "0";
        }
        CDOView view = session.openView();
        CDOQuery query = view.createQuery("sql", "SELECT CDO_ID FROM  model1_purchaseorder WHERE " + column + " = :aDate");
        query.setParameter("aDate", (Object)aDate);
        List orders = query.getResult(PurchaseOrder.class);
        SQLQueryTest.assertEquals((int)1, (int)orders.size());
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testPaging() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for products in pages");
        int pageSize = 5;
        int numOfPages = 20 / pageSize;
        ArrayList allProducts = new ArrayList();
        int page = 0;
        while (page < numOfPages) {
            CDOQuery productQuery = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_PRODUCT1");
            productQuery.setMaxResults(pageSize);
            productQuery.setParameter("firstResult", (Object)(page * pageSize));
            List queriedProducts = productQuery.getResult(Product1.class);
            SQLQueryTest.assertEquals((boolean)true, (queriedProducts.size() <= pageSize ? 1 : 0) != 0);
            for (Product1 newProduct : queriedProducts) {
                SQLQueryTest.assertEquals((boolean)true, (!allProducts.contains(newProduct) ? 1 : 0) != 0);
            }
            allProducts.addAll(queriedProducts);
            ++page;
        }
        SQLQueryTest.assertEquals((int)20, (int)allProducts.size());
        transaction.commit();
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testIterator() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for products");
        CDOQuery productQuery = transaction.createQuery("sql", "SELECT CDO_ID FROM MODEL1_PRODUCT1");
        CloseableIterator iterator = productQuery.getResultAsync(Product1.class);
        int counter = 0;
        while (iterator.hasNext()) {
            Product1 product = (Product1)iterator.next();
            SQLQueryTest.assertEquals((boolean)true, (product != null ? 1 : 0) != 0);
            if (counter++ != 10) continue;
            iterator.close();
        }
        transaction.commit();
    }

    public void testIteratorCancelation() throws Exception {
        CDOSession session = this.openSession();
        this.createTestSet(session);
        CDOView view = session.openView();
        int i = 0;
        while (i < 2000) {
            CDOQuery query = view.createQuery("sql", "SELECT CDO_ID FROM MODEL1_PRODUCT1");
            query.getResultAsync(Product1.class).close();
            ++i;
        }
    }

    public void _testNonCdoObjectQueries() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for customer street strings.");
        CDOQuery query = transaction.createQuery("sql", "SELECT STREET FROM MODEL1_CUSTOMER");
        query.setParameter("cdoObjectQuery", (Object)false);
        ArrayList streets = new ArrayList(query.getResult(String.class));
        int i = 0;
        while (i < 5) {
            SQLQueryTest.assertEquals((boolean)true, (boolean)streets.contains("Street " + i));
            ++i;
        }
    }

    public void _testNonCdoObjectQueries_Null() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for customer city strings.");
        CDOQuery query = transaction.createQuery("sql", "SELECT CITY FROM MODEL1_CUSTOMER");
        query.setParameter("cdoObjectQuery", (Object)false);
        ArrayList cities = new ArrayList(query.getResult(String.class));
        SQLQueryTest.assertEquals((boolean)true, (boolean)cities.contains(null));
        int i = 1;
        while (i < 5) {
            SQLQueryTest.assertEquals((boolean)true, (boolean)cities.contains("City " + i));
            ++i;
        }
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testNonCDOObjectQueries_Complex() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for customer fields");
        CDOQuery query = transaction.createQuery("sql", "SELECT street, city, name FROM model1_customer ORDER BY street");
        query.setParameter("cdoObjectQuery", (Object)false);
        List results = query.getResult(Object[].class);
        int i = 0;
        while (i < 5) {
            SQLQueryTest.assertEquals((Object)("Street " + i), (Object)((Object[])results.get(i))[0]);
            Object actual = ((Object[])results.get(i))[1];
            if (i == 0) {
                SQLQueryTest.assertEquals(null, (Object)actual);
            } else {
                SQLQueryTest.assertEquals((Object)("City " + i), (Object)actual);
            }
            SQLQueryTest.assertEquals((Object)("" + i), (Object)((Object[])results.get(i))[2]);
            ++i;
        }
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Query result counting")
    public void testNonCDOObjectQueries_Complex_MAP() throws Exception {
        SQLQueryTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        this.createTestSet(session);
        SQLQueryTest.msg((Object)"Opening transaction for querying");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Query for customer fields");
        CDOQuery query = transaction.createQuery("sql", "SELECT street, city, name FROM model1_customer ORDER BY street");
        query.setParameter("cdoObjectQuery", (Object)false);
        query.setParameter("mapQuery", (Object)true);
        List results = query.getResult();
        int i = 0;
        while (i < 5) {
            SQLQueryTest.assertEquals((Object)("Street " + i), ((Map)results.get(i)).get("STREET"));
            Object actual = ((Map)results.get(i)).get("CITY");
            if (i == 0) {
                SQLQueryTest.assertEquals(null, actual);
            } else {
                SQLQueryTest.assertEquals((Object)("City " + i), actual);
            }
            SQLQueryTest.assertEquals((Object)("" + i), ((Map)results.get(i)).get("NAME"));
            ++i;
        }
    }

    private void createTestSet(CDOSession session) {
        SQLQueryTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        SQLQueryTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        this.fillResource(resource);
        try {
            SQLQueryTest.msg((Object)"Committing");
            transaction.commit();
        }
        catch (CommitException ex) {
            throw WrappedException.wrap((Exception)((Object)ex));
        }
    }

    private void fillResource(CDOResource resource) {
        SQLQueryTest.msg((Object)"Creating Testset");
        ArrayList<Product1> products = new ArrayList<Product1>();
        int i = 0;
        while (i < 20) {
            products.add(this.createProduct(i));
            ++i;
        }
        resource.getContents().addAll(products);
        int productCounter = 0;
        int i2 = 0;
        while (i2 < 5) {
            Customer customer = this.getModel1Factory().createCustomer();
            if (i2 == 0) {
                customer.setCity(null);
            } else {
                customer.setCity("City " + i2);
            }
            customer.setName(String.valueOf(i2));
            customer.setStreet("Street " + i2);
            resource.getContents().add((Object)customer);
            List<Product1> customerProducts = products.subList(productCounter, productCounter + 4);
            int k = 0;
            while (k < 5) {
                resource.getContents().add((Object)this.createSalesOrder(i2 * 10 + k, customer, customerProducts));
                ++k;
            }
            productCounter += 4;
            ++i2;
        }
    }

    private SalesOrder createSalesOrder(int num, Customer customer, List<Product1> products) {
        SalesOrder salesOrder = this.getModel1Factory().createSalesOrder();
        salesOrder.setCustomer(customer);
        salesOrder.setId(num);
        this.createOrderDetail((Order)salesOrder, num, products);
        return salesOrder;
    }

    private List<OrderDetail> createOrderDetail(Order order, int index, List<Product1> products) {
        ArrayList<OrderDetail> orderDetails = new ArrayList<OrderDetail>();
        int count = 0;
        for (Product1 product : products) {
            OrderDetail orderDetail = this.getModel1Factory().createOrderDetail();
            orderDetail.setOrder(order);
            orderDetail.setPrice((float)(count++ * index) * 1.1f);
            orderDetail.setProduct(product);
        }
        return orderDetails;
    }

    private Product1 createProduct(int index) {
        Product1 product = this.getModel1Factory().createProduct1();
        product.setDescription("Description " + index);
        product.setName("" + index);
        if (index < 10) {
            product.setVat(VAT.VAT15);
        } else {
            product.setVat(VAT.VAT7);
        }
        return product;
    }
}

