/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.concurrent.QueueWorkerWorkSerializer;
import org.eclipse.net4j.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.ChannelMultiplexer;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;

public class Channel
extends Lifecycle
implements InternalChannel,
IExecutorServiceProvider,
IManagedContainerProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CHANNEL, Channel.class);
    private String userID;
    private InternalChannelMultiplexer channelMultiplexer;
    private short id = Short.MIN_VALUE;
    private IBufferHandler receiveHandler;
    private transient Queue<IBuffer> sendQueue;
    private transient long sentBuffers;
    private transient long receivedBuffers;

    public IManagedContainer getContainer() {
        return ContainerUtil.getContainer((Object)this.channelMultiplexer);
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public ILocationAware.Location getLocation() {
        return this.channelMultiplexer == null ? null : this.channelMultiplexer.getLocation();
    }

    @Override
    public boolean isClient() {
        return this.channelMultiplexer == null ? false : this.channelMultiplexer.isClient();
    }

    @Override
    public boolean isServer() {
        return this.channelMultiplexer == null ? false : this.channelMultiplexer.isServer();
    }

    @Override
    public IChannelMultiplexer getMultiplexer() {
        return this.channelMultiplexer;
    }

    @Override
    public void setMultiplexer(IChannelMultiplexer channelMultiplexer) {
        this.checkInactive();
        this.channelMultiplexer = (InternalChannelMultiplexer)channelMultiplexer;
    }

    @Override
    public short getID() {
        return this.id;
    }

    @Override
    public void setID(short id) {
        this.checkInactive();
        this.checkArg(id != Short.MIN_VALUE, "id == IBuffer.NO_CHANNEL");
        this.id = id;
    }

    public ExecutorService getExecutorService() {
        return ConcurrencyUtil.getExecutorService((Object)this.channelMultiplexer);
    }

    @Override
    @Deprecated
    public ExecutorService getReceiveExecutor() {
        return null;
    }

    @Override
    @Deprecated
    public void setReceiveExecutor(ExecutorService receiveExecutor) {
    }

    @Override
    public IBufferHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    @Override
    public void setReceiveHandler(IBufferHandler receiveHandler) {
        this.receiveHandler = receiveHandler;
    }

    @Override
    public long getSentBuffers() {
        return this.sentBuffers;
    }

    @Override
    public long getReceivedBuffers() {
        return this.receivedBuffers;
    }

    @Override
    public Queue<IBuffer> getSendQueue() {
        return this.sendQueue;
    }

    @Override
    public void sendBuffer(IBuffer buffer) {
        this.handleBuffer(buffer);
    }

    @Override
    public void handleBuffer(IBuffer buffer) {
        BufferState state = buffer.getState();
        if (state != BufferState.PUTTING) {
            throw new ChannelException("Can't send buffer in state == " + (Object)((Object)state) + ": " + this);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Handling buffer: {0} --> {1}", new Object[]{buffer, this});
        }
        if (this.isClosed()) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Ignoring buffer because channel is closed: " + this);
            }
            buffer.release();
            return;
        }
        if (buffer.getPosition() == 4 && !buffer.isEOS()) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Ignoring empty buffer: " + this);
            }
            if (buffer.isCCAM()) {
                if (this.channelMultiplexer instanceof ChannelMultiplexer) {
                    ((ChannelMultiplexer)this.channelMultiplexer).inverseCloseChannel(this.id);
                } else {
                    this.deactivate();
                }
            }
            buffer.release();
            return;
        }
        ++this.sentBuffers;
        if (this.sendQueue != null) {
            this.sendQueue.add(buffer);
            this.channelMultiplexer.multiplexChannel(this);
        } else {
            ((InternalChannelMultiplexer.BufferMultiplexer)((Object)this.channelMultiplexer)).multiplexBuffer(this, buffer);
        }
    }

    @Override
    public void handleBufferFromMultiplexer(IBuffer buffer) {
        if (this.receiveHandler != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Handling buffer from multiplexer: {0} --> {1}", new Object[]{buffer, this});
            }
            ++this.receivedBuffers;
            this.receiveHandler.handleBuffer(buffer);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Releasing buffer from multiplexer for lack of receive handler: {0} --> {1}", new Object[]{buffer, this});
            }
            buffer.release();
        }
    }

    @Deprecated
    protected ReceiverWork createReceiverWork(IBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getBufferCapacity() {
        return this.channelMultiplexer.getBufferCapacity();
    }

    @Override
    public IBuffer provideBuffer() {
        return this.channelMultiplexer.provideBuffer();
    }

    @Override
    public void retainBuffer(IBuffer buffer) {
        this.channelMultiplexer.retainBuffer(buffer);
    }

    public String toString() {
        if (this.receiveHandler instanceof IProtocol) {
            IProtocol protocol = (IProtocol)this.receiveHandler;
            return MessageFormat.format("Channel[{0}, {1}, {2}]", new Object[]{this.id, this.getLocation(), protocol.getType()});
        }
        return MessageFormat.format("Channel[{0}, {1}]", new Object[]{this.id, this.getLocation()});
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.id != Short.MIN_VALUE, "channelID == NO_CHANNEL");
        this.checkState(this.channelMultiplexer, "channelMultiplexer");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (!(this.channelMultiplexer instanceof InternalChannelMultiplexer.BufferMultiplexer)) {
            this.sendQueue = new SendQueue();
        }
    }

    protected void doDeactivate() throws Exception {
        this.unregisterFromMultiplexer();
        if (this.sendQueue != null) {
            this.sendQueue.clear();
            this.sendQueue = null;
        }
        super.doDeactivate();
    }

    protected void unregisterFromMultiplexer() {
        this.channelMultiplexer.closeChannel(this);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    @Deprecated
    protected class ReceiveSerializer
    extends QueueWorkerWorkSerializer {
        protected ReceiveSerializer() {
        }

        protected String getThreadName() {
            return "Net4jReceiveSerializer-" + Channel.this;
        }

        protected void noWork(Worker.WorkContext context) {
            if (Channel.this.isClosed()) {
                context.terminate();
            }
        }
    }

    @Deprecated
    protected class ReceiverWork
    extends RunnableWithName {
        private final IBuffer buffer;

        public ReceiverWork(IBuffer buffer) {
            this.buffer = buffer;
        }

        public String getName() {
            return "Net4jReceiver-" + Channel.this;
        }

        protected void doRun() {
            IBufferHandler receiveHandler = Channel.this.getReceiveHandler();
            if (receiveHandler != null) {
                receiveHandler.handleBuffer(this.buffer);
            } else {
                this.buffer.release();
            }
        }
    }

    protected class SendQueue
    extends ConcurrentLinkedQueue<IBuffer> {
        private static final long serialVersionUID = 1L;
        private AtomicInteger size = new AtomicInteger();

        protected SendQueue() {
        }

        @Override
        public boolean offer(IBuffer o) {
            super.offer(o);
            this.added(o);
            return true;
        }

        @Override
        public IBuffer poll() {
            IBuffer result = (IBuffer)super.poll();
            if (result != null) {
                this.removed(result);
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = super.remove(o);
            if (result) {
                this.removed((IBuffer)o);
            }
            return result;
        }

        private void added(IBuffer buffer) {
            int queueSize = this.size.incrementAndGet();
            IListener[] listeners = Channel.this.getListeners();
            if (listeners != null) {
                Channel.this.fireEvent(new SendQueueEventImpl(Channel.this, InternalChannel.SendQueueEvent.Type.ENQUEUED, queueSize), listeners);
            }
        }

        private void removed(IBuffer buffer) {
            int queueSize = this.size.decrementAndGet();
            IListener[] listeners = Channel.this.getListeners();
            if (listeners != null) {
                Channel.this.fireEvent(new SendQueueEventImpl(Channel.this, InternalChannel.SendQueueEvent.Type.DEQUEUED, queueSize), listeners);
            }
        }
    }

    private static final class SendQueueEventImpl
    extends Event
    implements InternalChannel.SendQueueEvent {
        private static final long serialVersionUID = 1L;
        private final InternalChannel.SendQueueEvent.Type type;
        private final int queueSize;

        private SendQueueEventImpl(Channel channel, InternalChannel.SendQueueEvent.Type type, int queueSize) {
            super((INotifier)channel);
            this.type = type;
            this.queueSize = queueSize;
        }

        @Override
        public InternalChannel getSource() {
            return (InternalChannel)super.getSource();
        }

        @Override
        public InternalChannel.SendQueueEvent.Type getType() {
            return this.type;
        }

        @Override
        public int getQueueSize() {
            return this.queueSize;
        }
    }
}

