/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.capabilities;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;

public abstract class AbstractCapabilityTest
extends TestCase {
    public AbstractCapabilityTest(String name) {
        super(name);
    }

    public void testDirtyRead() throws Exception {
        this.msg("TEST " + ((Object)((Object)this)).getClass().getSimpleName() + " - DIRTY READ");
        this.msg("----------------------------------------------------------");
        this.msg("Transaction 1 changes a value, transaction 2 will read the value.");
        this.msg("The value of transaction 2 should be UNCHANGED (else we have a dirty read)");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    IDBConnectionProvider provider = AbstractCapabilityTest.this.getConnectionProvider();
                    Connection transaction1 = provider.getConnection();
                    transaction1.setAutoCommit(false);
                    Statement tx1stmt = transaction1.createStatement();
                    tx1stmt.executeUpdate("update status_table set status = 'changed' where trans = 'transaction1'");
                    AbstractCapabilityTest.this.msg("Read value (transaction 1) is " + AbstractCapabilityTest.this.select(transaction1, "select status from status_table where trans = 'transaction1'").toUpperCase());
                    1.sleep(1000L);
                    transaction1.rollback();
                    transaction1.close();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        };
        t.start();
        Thread.sleep(300L);
        IDBConnectionProvider provider = this.getConnectionProvider();
        Connection transaction2 = provider.getConnection();
        transaction2.setAutoCommit(false);
        this.msg("Read value (transaction 2) is " + this.select(transaction2, "select status from status_table where trans = 'transaction1'").toUpperCase());
        this.msg("----------------------------------------------------------");
        transaction2.rollback();
        transaction2.close();
    }

    public void testRollback() throws Exception {
        this.msg("TEST " + ((Object)((Object)this)).getClass().getSimpleName() + " - ROLLBACK");
        this.msg("----------------------------------------------------------");
        this.msg("Transaction changes a value and does a rollback.");
        this.msg("The value of after rollback should be UNCHANGED.");
        IDBConnectionProvider provider = this.getConnectionProvider();
        Connection transaction1 = provider.getConnection();
        transaction1.setAutoCommit(false);
        Statement tx1stmt = transaction1.createStatement();
        try {
            tx1stmt.executeUpdate("update status_table set status = 'changed' where trans = 'transaction1'");
        }
        finally {
            DBUtil.close((Statement)tx1stmt);
        }
        this.msg("Read value before rollback is " + this.select(transaction1, "select status from status_table where trans = 'transaction1'").toUpperCase());
        transaction1.rollback();
        transaction1.close();
        Connection view = provider.getConnection();
        this.msg("Read value after rollback is " + this.select(view, "select status from status_table where trans = 'transaction1'").toUpperCase());
        view.close();
        this.msg("----------------------------------------------------------");
    }

    public void testDml() throws Exception {
        this.msg("TEST " + ((Object)((Object)this)).getClass().getSimpleName() + " - DML");
        this.msg("----------------------------------------------------------");
        this.msg("Transaction 1 will execute DML, transaction 2 will just change its data.");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    IDBConnectionProvider provider = AbstractCapabilityTest.this.getConnectionProvider();
                    Connection transaction2 = provider.getConnection();
                    Statement tx2stmt = transaction2.createStatement();
                    transaction2.setAutoCommit(false);
                    tx2stmt.executeUpdate("update status_table set status = 'changed' where trans = 'transaction2'");
                    tx2stmt.executeUpdate("update change_table set status = 'changed' where trans = 'transaction2'");
                    tx2stmt.close();
                    2.sleep(1000L);
                    transaction2.rollback();
                    transaction2.close();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        };
        t.start();
        Thread.sleep(100L);
        IDBConnectionProvider provider = this.getConnectionProvider();
        Connection transaction1 = provider.getConnection();
        transaction1.setAutoCommit(false);
        Statement tx1stmt = transaction1.createStatement();
        tx1stmt.executeUpdate("update status_table set status = 'changed' where trans = 'transaction1'");
        tx1stmt.executeUpdate("update change_table set status = 'changed' where trans = 'transaction1'");
        tx1stmt.execute("alter table change_table add new_column varchar(255) default 'added column present'");
        tx1stmt.close();
        transaction1.rollback();
        transaction1.close();
        t.join();
        Connection view = provider.getConnection();
        this.msg("transaction1: unchanged table record is " + this.select(view, "select status from status_table where trans = 'transaction1'").toUpperCase());
        this.msg("transaction2: unchanged table record is " + this.select(view, "select status from status_table where trans = 'transaction2'").toUpperCase());
        this.msg("transaction1: changed table record is " + this.select(view, "select status from change_table where trans = 'transaction1'").toUpperCase());
        this.msg("transaction2: changed table record is " + this.select(view, "select status from change_table where trans = 'transaction2'").toUpperCase());
        String present = "present";
        try {
            this.select(view, "select new_column from change_table where trans = 'transaction2'");
        }
        catch (SQLException e) {
            present = "not present";
        }
        this.msg("Added column is " + present.toUpperCase());
        view.close();
        this.msg("----------------------------------------------------------");
    }

    protected void setUp() throws Exception {
        Connection conn = this.getConnectionProvider().getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("drop table status_table");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmt.execute("drop table change_table");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stmt.execute("create table status_table (trans varchar(255), status varchar(255))");
        stmt.execute("insert into status_table values ('transaction1', 'unchanged')");
        stmt.execute("insert into status_table values ('transaction2', 'unchanged')");
        stmt.execute("create table change_table (trans varchar(255), status varchar(255))");
        stmt.execute("insert into change_table values ('transaction1', 'unchanged')");
        stmt.execute("insert into change_table values ('transaction2', 'unchanged')");
        conn.commit();
        stmt.close();
        conn.close();
    }

    protected void tearDown() throws Exception {
        Connection conn = this.getConnectionProvider().getConnection();
        conn.setAutoCommit(true);
        Statement stmt = conn.createStatement();
        stmt.execute("drop table status_table");
        stmt.execute("drop table change_table");
        stmt.close();
        conn.close();
    }

    protected abstract IDBConnectionProvider getConnectionProvider();

    private void msg(String string) {
        System.out.println(string);
    }

    private String select(Connection conn, String sql) throws SQLException {
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(sql);
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void sqlDump(Connection conn, String sql) {
        block17: {
            ResultSet rs = null;
            try {
                try {
                    System.out.format("Dumping output of %s\n", sql);
                    rs = conn.createStatement().executeQuery(sql);
                    int numCol = rs.getMetaData().getColumnCount();
                    StringBuilder row = new StringBuilder(" ");
                    int c = 1;
                    while (c <= numCol) {
                        row.append(String.format("%15s | ", rs.getMetaData().getColumnLabel(c)));
                        ++c;
                    }
                    System.out.println(row.toString());
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------------+");
                        ++c;
                    }
                    System.out.println(row.toString());
                    while (rs.next()) {
                        row = new StringBuilder(" ");
                        c = 1;
                        while (c <= numCol) {
                            row.append(String.format("%15s | ", rs.getString(c)));
                            ++c;
                        }
                        System.out.println(row.toString());
                    }
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------------+");
                        ++c;
                    }
                    System.out.println(row.toString());
                }
                catch (SQLException sQLException) {
                    if (rs == null) break block17;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

