/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.util.concurrent.SerializingExecutor;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class ExecutorWorkSerializerTest
extends AbstractOMTest {
    private static final int WORK_COMPLETION_TIMEOUT = 10000;
    private static final int NUM_WORKPRODUCER_THREADS = 10;
    private static final int NUM_WORK = 40;
    private CountDownLatch workConsumedLatch;
    private AtomicInteger workProduced;
    private ExecutorService threadPool;
    private SerializingExecutor serializer;

    @Override
    public void setUp() {
        this.workProduced = new AtomicInteger(0);
        this.workConsumedLatch = new CountDownLatch(40);
        this.threadPool = Executors.newFixedThreadPool(10);
        this.serializer = new SerializingExecutor((Executor)this.threadPool);
        this.serializer.activate();
    }

    @Override
    public void tearDown() {
        this.serializer.deactivate();
        this.threadPool.shutdown();
    }

    public void testAllWorkSubmittedIsConsumed() throws Throwable {
        this.createWorkProducerThreads(new WorkProducerFactory(){

            @Override
            public WorkProducer createWorkProducer() {
                return new WorkProducer(ExecutorWorkSerializerTest.this){

                    @Override
                    protected Runnable createWork(int id) {
                        return new Work(id);
                    }
                };
            }
        });
        this.waitForAllWorkExecuted();
        ExecutorWorkSerializerTest.assertEquals((long)this.workProduced.get(), (long)(40L - this.workConsumedLatch.getCount()));
    }

    public void testGivenWorkExceptionInWorkAllWorkSubmittedOnlyTheFirstWorkerIsConsumed() throws Throwable {
        this.createWorkProducerThreads(new WorkProducerFactory(){

            @Override
            public WorkProducer createWorkProducer() {
                return new WorkProducer(ExecutorWorkSerializerTest.this){

                    @Override
                    protected Runnable createWork(int id) {
                        return new Work(ExecutorWorkSerializerTest.this, id){

                            @Override
                            public void run() {
                                super.run();
                                throw new RuntimeException("dummy exception to simulate an error in executed workers");
                            }
                        };
                    }
                };
            }
        });
        this.waitForAllWorkExecuted();
        ExecutorWorkSerializerTest.assertEquals((int)40, (int)this.workProduced.get());
    }

    private void waitForAllWorkExecuted() throws InterruptedException {
        if (!this.workConsumedLatch.await(10000L, TimeUnit.MILLISECONDS)) {
            IOUtil.OUT().println("timeout occured before all workers were executed");
        }
    }

    private void createWorkProducerThreads(WorkProducerFactory factory) {
        int i = 0;
        while (i < 10) {
            this.threadPool.submit(factory.createWorkProducer());
            ++i;
        }
    }

    class Work
    implements Runnable {
        private final int id;

        private Work(int id) {
            this.id = id;
            IOUtil.OUT().println("work unit " + id + " created");
        }

        @Override
        public void run() {
            ExecutorWorkSerializerTest.this.workConsumedLatch.countDown();
            IOUtil.OUT().println("work unit " + this.id + " consumed");
        }

        /* synthetic */ Work(int n, Work work, Work work2) {
            this(n);
        }
    }

    private abstract class WorkProducer
    implements Runnable {
        private Random random = new Random();

        private WorkProducer() {
        }

        @Override
        public void run() {
            try {
                int currentWorkProduced;
                while ((currentWorkProduced = ExecutorWorkSerializerTest.this.workProduced.getAndIncrement()) < 40) {
                    ExecutorWorkSerializerTest.this.serializer.execute(this.createWork(currentWorkProduced));
                    Thread.sleep(this.random.nextInt(1000));
                }
                ExecutorWorkSerializerTest.this.workProduced.decrementAndGet();
                IOUtil.OUT().println("work producer " + this + " stopped its production");
            }
            catch (InterruptedException ex) {
                return;
            }
        }

        protected abstract Runnable createWork(int var1);
    }

    private static interface WorkProducerFactory {
        public WorkProducer createWorkProducer();
    }
}

