/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.model5.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;

public class IsLoadingTestFixture {
    private static IsLoadingTestFixture instance;
    private Map<Resource, Set<EObject>> objectsReportedLoading = new HashMap<Resource, Set<EObject>>();

    private IsLoadingTestFixture() {
    }

    public static IsLoadingTestFixture newInstance() {
        IsLoadingTestFixture result;
        instance = result = new IsLoadingTestFixture();
        return result;
    }

    public void dispose() {
        if (instance == this) {
            instance = null;
        }
        this.objectsReportedLoading.clear();
    }

    public static void reportLoading(Resource resource, EObject object) {
        if (instance != null) {
            instance.doReportLoading(resource, object);
        }
    }

    private Set<EObject> demandObjectsReportedLoading(Resource resource) {
        Set<EObject> result = this.objectsReportedLoading.get(resource);
        if (result == null) {
            result = new HashSet<EObject>();
            this.objectsReportedLoading.put(resource, result);
        }
        return result;
    }

    private Set<EObject> getObjectsReportedLoading(Resource resource) {
        Set<Object> result = this.objectsReportedLoading.get(resource);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private void doReportLoading(Resource resource, EObject object) {
        if (resource instanceof Resource.Internal && ((Resource.Internal)resource).isLoading()) {
            this.demandObjectsReportedLoading(resource).add(object);
        }
    }

    public void assertReportedLoading(Resource resource, EObject object) {
        Assert.assertEquals((String)("Object did not report loading: " + object), (Object)true, (Object)this.getObjectsReportedLoading(resource).contains(object));
    }

    public void assertNotReportedLoading(Resource resource, EObject object) {
        Assert.assertEquals((String)("Object reported loading: " + object), (Object)false, (Object)this.getObjectsReportedLoading(resource).contains(object));
    }
}

