/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.embedded;

import java.io.File;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.embedded.CDOEmbeddedRepositoryConfig;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.h2.jdbcx.JdbcDataSource;

public final class CDOFacade
extends CDOEmbeddedRepositoryConfig {
    public static final CDOFacade INSTANCE = new CDOFacade();
    private static final String NAME = "repo";
    private static final boolean AUDITING = false;
    private static final boolean BRANCHING = false;
    private static final File DB_FOLDER = new File("./database");
    private static final String DS_URL = "jdbc:h2:" + DB_FOLDER + "/" + "repo" + ";MVCC=FALSE";
    private CDOServerBrowser serverBrowser;
    private CDONet4jSession session;
    private CDOTransaction transaction;
    private ResourceSet resourceSet;

    private CDOFacade() {
        super(NAME);
    }

    public Connection getJDBCConnection() {
        IDBStore store = (IDBStore)this.getRepository().getStore();
        return store.getConnection();
    }

    public synchronized CDONet4jSession getSession(boolean openOnDemand) {
        this.checkActive();
        if (this.session == null && openOnDemand) {
            this.session = this.openClientSession();
            this.session.addListener((IListener)new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    if (lifecycle == CDOFacade.this.session) {
                        CDOFacade.this.session = null;
                    }
                }
            });
        }
        return this.session;
    }

    public synchronized CDOTransaction getTransaction() {
        this.checkActive();
        if (this.transaction == null) {
            this.resourceSet = new ResourceSetImpl();
            CDONet4jSession session = this.getSession(true);
            this.transaction = session.openTransaction(this.resourceSet);
            this.transaction.addListener((IListener)new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    if (lifecycle == CDOFacade.this.transaction) {
                        CDOFacade.this.transaction = null;
                        CDOFacade.this.resourceSet = null;
                    }
                }
            });
        }
        return this.transaction;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IStore createStore(IManagedContainer container) {
        DB_FOLDER.mkdirs();
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)false, (boolean)false);
        mappingStrategy.getProperties().put("forceNamesWithID", "true");
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL(DS_URL);
        H2Adapter dbAdapter = new H2Adapter();
        IDBConnectionProvider dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    public void initProperties(IManagedContainer container, Map<String, String> properties) {
        properties.put("supportingAudits", Boolean.toString(false));
        properties.put("supportingBranches", Boolean.toString(false));
    }

    public boolean isInitialPackage(IRepository repository, String nsURI) {
        return nsURI.equals("http://www.eclipse.org/emf/CDO/examples/company/1.0.0");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.serverBrowser = new CDOServerBrowser.ContainerBased((IContainer)this.getContainer());
        LifecycleUtil.activate((Object)this.serverBrowser);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.serverBrowser);
        this.serverBrowser = null;
        super.doDeactivate();
    }
}

