/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.signal;

import java.io.IOException;
import java.rmi.AlreadyBoundException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.tests.signal.ArrayIndication;
import org.eclipse.net4j.tests.signal.AsyncIndication;
import org.eclipse.net4j.tests.signal.ExceptionIndication;
import org.eclipse.net4j.tests.signal.IntFailIndication;
import org.eclipse.net4j.tests.signal.IntIndication;
import org.eclipse.net4j.tests.signal.StringIndication;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.spi.net4j.ServerProtocolFactory;

public class TestSignalProtocol
extends SignalProtocol<Object> {
    public static final String PROTOCOL_NAME = "signal.protocol";
    public static final short SIGNAL_INT = 1;
    public static final short SIGNAL_INT_FAIL = 2;
    public static final short SIGNAL_ARRAY = 3;
    public static final short SIGNAL_STRING = 4;
    public static final short SIGNAL_ASYNC = 5;
    public static final short SIGNAL_EXCEPTION = 6;
    public static final String SIMULATED_EXCEPTION = "Simulated exception";
    private int version = super.getVersion();

    public TestSignalProtocol(IConnector connector, int version) {
        this();
        this.version = version;
        this.open(connector);
    }

    public TestSignalProtocol(IConnector connector) {
        this();
        this.open(connector);
    }

    public TestSignalProtocol() {
        super(PROTOCOL_NAME);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 1: {
                return new IntIndication(this);
            }
            case 2: {
                return new IntFailIndication(this);
            }
            case 3: {
                return new ArrayIndication(this);
            }
            case 4: {
                return new StringIndication(this);
            }
            case 5: {
                return new AsyncIndication(this);
            }
            case 6: {
                return new ExceptionIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }

    public void throwException(boolean ioProblem) throws Exception {
        if (ioProblem) {
            throw new IOException(SIMULATED_EXCEPTION);
        }
        try {
            this.throwNestedException();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(SIMULATED_EXCEPTION, ex);
        }
    }

    public void throwNestedException() throws Exception {
        throw new AlreadyBoundException(SIMULATED_EXCEPTION);
    }

    public static class Factory
    extends ServerProtocolFactory {
        private int version = 0;

        public Factory(int version) {
            this();
            this.version = version;
        }

        public Factory() {
            super(TestSignalProtocol.PROTOCOL_NAME);
        }

        public TestSignalProtocol create(String description) throws ProductCreationException {
            TestSignalProtocol protocol = new TestSignalProtocol();
            protocol.setVersion(this.version);
            return protocol;
        }
    }
}

