/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCredential;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import java.util.Arrays;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.types.ObjectId;

final class UserOperationHelper {
    static BsonDocument asCommandDocument(MongoCredential credential, boolean readOnly, String commandName) {
        BsonDocument document = new BsonDocument();
        document.put(commandName, new BsonString(credential.getUserName()));
        document.put("pwd", new BsonString(NativeAuthenticationHelper.createAuthenticationHash(credential.getUserName(), credential.getPassword())));
        document.put("digestPassword", BsonBoolean.FALSE);
        document.put("roles", new BsonArray(Arrays.asList(new BsonString(UserOperationHelper.getRoleName(credential, readOnly)))));
        return document;
    }

    private static String getRoleName(MongoCredential credential, boolean readOnly) {
        return credential.getSource().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    static BsonDocument asCollectionQueryDocument(MongoCredential credential) {
        return new BsonDocument("user", new BsonString(credential.getUserName()));
    }

    static BsonDocument asCollectionUpdateDocument(MongoCredential credential, boolean readOnly) {
        return UserOperationHelper.asCollectionQueryDocument(credential).append("pwd", new BsonString(NativeAuthenticationHelper.createAuthenticationHash(credential.getUserName(), credential.getPassword()))).append("readOnly", BsonBoolean.valueOf(readOnly));
    }

    static BsonDocument asCollectionInsertDocument(MongoCredential credential, boolean readOnly) {
        return UserOperationHelper.asCollectionUpdateDocument(credential, readOnly).append("_id", new BsonObjectId(new ObjectId()));
    }

    private UserOperationHelper() {
    }
}

