/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.verifier;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalAuditClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalAuditMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditMappingStrategy;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.tests.db.bundle.OM;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.junit.Assert;

public abstract class DBStoreVerifier {
    protected static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreVerifier.class);
    private IRepository repository;
    private IDBStoreAccessor accessor;

    public DBStoreVerifier(IRepository repository) {
        this.repository = repository;
        if (repository != null) {
            Assert.assertEquals((Object)true, (Object)(repository.getStore() instanceof IDBStore));
        }
    }

    protected IRepository getRepository() {
        return this.repository;
    }

    protected IDBStore getStore() {
        return (IDBStore)this.repository.getStore();
    }

    protected Statement getStatement() {
        if (this.accessor == null) {
            this.accessor = (IDBStoreAccessor)this.repository.getStore().getReader(null);
        }
        try {
            return this.accessor.getDBConnection().createStatement();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    protected DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    protected List<IClassMapping> getClassMappings() {
        ArrayList<IClassMapping> result = new ArrayList<IClassMapping>();
        InternalCDOPackageRegistry packageRegistry = (InternalCDOPackageRegistry)this.repository.getPackageRegistry();
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageRegistry.getPackageInfos();
        int n = internalCDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            if (!packageInfo.isCorePackage()) {
                EClass[] eClassArray = EMFUtil.getPersistentClasses((EPackage)packageInfo.getEPackage());
                int n3 = eClassArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    EClass cls = eClassArray[n4];
                    result.add(this.getStore().getMappingStrategy().getClassMapping(cls));
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    protected void cleanUp() {
        if (this.accessor != null) {
            this.accessor.release();
        }
    }

    public void verify() throws VerificationException {
        try {
            try {
                if (TRACER.isEnabled()) {
                    TRACER.format("Starting {0}...", new Object[]{this.getClass().getSimpleName()});
                }
                this.doVerify();
                if (TRACER.isEnabled()) {
                    TRACER.format("{0} completed without complaints...", new Object[]{this.getClass().getSimpleName()});
                }
            }
            catch (Exception e) {
                throw new VerificationException(e);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    protected void sqlDump(String sql) {
        block17: {
            ResultSet rs = null;
            try {
                try {
                    TRACER.format("Dumping output of {0}", new Object[]{sql});
                    rs = this.getStatement().executeQuery(sql);
                    int numCol = rs.getMetaData().getColumnCount();
                    StringBuilder row = new StringBuilder();
                    int c = 1;
                    while (c <= numCol) {
                        row.append(String.format("%10s | ", rs.getMetaData().getColumnLabel(c)));
                        ++c;
                    }
                    TRACER.trace(row.toString());
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------+--");
                        ++c;
                    }
                    TRACER.trace(row.toString());
                    while (rs.next()) {
                        row = new StringBuilder();
                        c = 1;
                        while (c <= numCol) {
                            row.append(String.format("%10s | ", rs.getString(c)));
                            ++c;
                        }
                        TRACER.trace(row.toString());
                    }
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------+-");
                        ++c;
                    }
                    TRACER.trace(row.toString());
                }
                catch (SQLException sQLException) {
                    if (rs == null) break block17;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    protected abstract void doVerify() throws Exception;

    public static class Audit
    extends DBStoreVerifier {
        public Audit(IRepository repo) {
            super(repo);
            Assert.assertEquals((Object)true, (Object)(this.getStore().getMappingStrategy() instanceof HorizontalAuditMappingStrategy));
        }

        @Override
        protected void doVerify() throws Exception {
            for (IClassMapping mapping : this.getClassMappings()) {
                if (mapping == null || mapping.getDBTables() == null) continue;
                this.verifyClassMapping(mapping);
            }
        }

        private void verifyClassMapping(IClassMapping mapping) throws Exception {
            this.verifyAtMostOneUnrevised(mapping);
            this.verifyUniqueIdVersion(mapping);
            this.verifyReferences(mapping);
        }

        private void verifyAtMostOneUnrevised(IClassMapping mapping) throws Exception {
            String tableName = ((IDBTable)mapping.getDBTables().iterator().next()).getName();
            TRACER.format("verifyAtMostOneUnrevised: {0} ...", new Object[]{tableName});
            String sql = "SELECT CDO_ID, count(1) FROM " + tableName + " WHERE " + "CDO_REVISED" + "= 0 GROUP BY " + "CDO_ID";
            TRACER.format("  Executing SQL: {0} ", new Object[]{sql});
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                while (resultSet.next()) {
                    Assert.assertEquals((String)("Multiple unrevised rows for ID " + resultSet.getLong(1)), (Object)true, (Object)(resultSet.getInt(2) <= 1 ? 1 : 0));
                }
            }
        }

        private void verifyUniqueIdVersion(IClassMapping mapping) throws Exception {
            String tableName = ((IDBTable)mapping.getDBTables().iterator().next()).getName();
            TRACER.format("verifyUniqueIdVersion: {0} ...", new Object[]{tableName});
            String sql = "SELECT CDO_ID,CDO_VERSION, count(1) FROM " + tableName + " GROUP BY " + "CDO_ID" + "," + "CDO_VERSION";
            TRACER.format("  Executing SQL: {0} ", new Object[]{sql});
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                try {
                    while (resultSet.next()) {
                        Assert.assertEquals((String)("Multiple rows for ID " + resultSet.getLong(1) + "v" + resultSet.getInt(2)), (Object)true, (Object)(resultSet.getInt(3) <= 1 ? 1 : 0));
                    }
                }
                catch (AssertionFailedError e) {
                    TRACER.trace(e.getMessage());
                    this.sqlDump("SELECT * FROM " + tableName + " WHERE " + "CDO_REVISED" + "=0");
                    throw e;
                }
            }
        }

        private void verifyReferences(IClassMapping mapping) throws Exception {
            List listMappings = ((HorizontalAuditClassMapping)mapping).getListMappings();
            if (listMappings == null) {
                return;
            }
            String tableName = ((IDBTable)mapping.getDBTables().iterator().next()).getName();
            String sql = "SELECT CDO_ID, CDO_VERSION FROM " + tableName;
            ArrayList<Pair> idVersions = new ArrayList<Pair>();
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                while (resultSet.next()) {
                    idVersions.add(Pair.create((Object)resultSet.getLong(1), (Object)resultSet.getInt(2)));
                }
            }
            for (IListMapping listMapping : listMappings) {
                for (Pair idVersion : idVersions) {
                    this.verifyCorrectIndices(listMapping, (Long)idVersion.getElement1(), (Integer)idVersion.getElement2());
                }
            }
        }

        private void verifyCorrectIndices(IListMapping refMapping, long id, int version) throws Exception {
            String tableName = ((IDBTable)refMapping.getDBTables().iterator().next()).getName();
            TRACER.format("verifyUniqueIdVersion: {0} for ID{1}v{2} ...", new Object[]{tableName, id, version});
            String sql = "SELECT CDO_IDX FROM " + tableName + " WHERE " + "CDO_SOURCE" + "=" + id + " AND " + "CDO_VERSION" + "=" + version + " ORDER BY " + "CDO_IDX";
            TRACER.format("  Executing SQL: {0} ", new Object[]{sql});
            int indexShouldBe = 0;
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                try {
                    while (resultSet.next()) {
                        Assert.assertEquals((String)("Index " + indexShouldBe + " missing for ID" + id + "v" + version), (long)indexShouldBe++, (long)resultSet.getInt(1));
                    }
                }
                catch (AssertionFailedError e) {
                    this.sqlDump("SELECT * FROM " + tableName + " WHERE " + "CDO_SOURCE" + "=" + id + " AND " + "CDO_VERSION" + "=" + version + " ORDER BY " + "CDO_IDX");
                    throw e;
                }
            }
        }
    }

    public static class NonAudit
    extends DBStoreVerifier {
        public NonAudit(IRepository repo) {
            super(repo);
            Assert.assertEquals((Object)true, (Object)(this.getStore().getRevisionTemporality() == IStore.RevisionTemporality.NONE ? 1 : 0));
            Assert.assertEquals((Object)true, (Object)(this.getStore().getMappingStrategy() instanceof HorizontalNonAuditMappingStrategy));
        }

        @Override
        protected void doVerify() throws Exception {
            for (IClassMapping mapping : this.getClassMappings()) {
                if (mapping == null || mapping.getDBTables().size() <= 0) continue;
                this.verifyClassMapping(mapping);
            }
        }

        private void verifyClassMapping(IClassMapping mapping) throws Exception {
            this.verifyNoUnrevisedRevisions(mapping);
            this.verifyUniqueId(mapping);
            this.verifyReferences(mapping);
        }

        private void verifyNoUnrevisedRevisions(IClassMapping mapping) throws Exception {
            String tableName = ((IDBTable)mapping.getDBTables().iterator().next()).getName();
            String sql = "SELECT count(1) FROM " + tableName + " WHERE " + "CDO_REVISED" + " <> 0";
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                Assert.assertEquals((Object)true, (Object)resultSet.next());
                Assert.assertEquals((String)("Revised revision in table " + tableName), (long)0L, (long)resultSet.getInt(1));
            }
        }

        private void verifyUniqueId(IClassMapping mapping) throws Exception {
            String tableName = ((IDBTable)mapping.getDBTables().iterator().next()).getName();
            String sql = "SELECT CDO_ID, count(1) FROM " + tableName + " GROUP BY " + "CDO_ID";
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                while (resultSet.next()) {
                    Assert.assertEquals((String)("Multiple rows for ID " + resultSet.getLong(1)), (long)1L, (long)resultSet.getInt(2));
                }
            }
        }

        private void verifyReferences(IClassMapping mapping) throws Exception {
            List referenceMappings = ((HorizontalNonAuditClassMapping)mapping).getListMappings();
            if (referenceMappings == null) {
                return;
            }
            String tableName = ((IDBTable)mapping.getDBTables().iterator().next()).getName();
            String sql = "SELECT CDO_ID, CDO_VERSION FROM " + tableName;
            ArrayList<Pair> idVersions = new ArrayList<Pair>();
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                while (resultSet.next()) {
                    idVersions.add(Pair.create((Object)resultSet.getLong(1), (Object)resultSet.getInt(2)));
                }
            }
            for (IListMapping refMapping : referenceMappings) {
                for (Pair idVersion : idVersions) {
                    this.verifyCorrectIndices(refMapping, (Long)idVersion.getElement1());
                }
            }
        }

        private void verifyCorrectIndices(IListMapping refMapping, long id) throws Exception {
            String tableName = ((IDBTable)refMapping.getDBTables().iterator().next()).getName();
            String sql = "SELECT CDO_IDX FROM " + tableName + " WHERE " + "CDO_SOURCE" + "=" + id + " ORDER BY " + "CDO_IDX";
            int indexShouldBe = 0;
            try (ResultSet resultSet = this.getStatement().executeQuery(sql);){
                while (resultSet.next()) {
                    Assert.assertEquals((String)("Index " + indexShouldBe + " missing for ID" + id), (long)indexShouldBe++, (long)resultSet.getInt(1));
                }
            }
        }
    }

    public static class VerificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VerificationException(String message) {
            super(message);
        }

        public VerificationException(String message, Throwable t) {
            super(message, t);
        }

        public VerificationException(Throwable t) {
            super(t);
        }
    }
}

