/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.uml;

import java.util.Collection;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

@ConfigTest.Requires(value={"model.legacy"})
public class DynamicProfileTest
extends AbstractCDOTest {
    private final EPackage stuffPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/cdo/tests/schema/stuff/1.0");
    private final EFactory originalStuffFactory = this.stuffPackage.getEFactoryInstance();
    private static final String MY_PROFILE_URI = "http://www.eclipse.org/cdo/tests/schema/myprofile";
    private static final String S_CONCEPT = "Concept";

    public void testInstancesOfRegisteredDynamicUMLProfile() throws Exception {
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage((EPackage)UMLPackage.eINSTANCE);
        ResourceSetImpl rset = new ResourceSetImpl();
        CDOTransaction transaction = session.openTransaction((ResourceSet)rset);
        CDOResource res = transaction.createResource(this.getResourcePath("/model1.uml"));
        Model umlModel = UMLFactory.eINSTANCE.createModel();
        res.getContents().add((Object)umlModel);
        umlModel.setName("model");
        Class aClass = umlModel.createOwnedClass("Fruit", true);
        Profile profile = (Profile)UML2Util.load((ResourceSet)rset, (URI)URI.createURI((String)MY_PROFILE_URI), (EClass)UMLPackage.Literals.PROFILE);
        DynamicProfileTest.assertNotNull((Object)profile);
        umlModel.applyProfile(profile);
        Stereotype conceptStereotype = profile.getOwnedStereotype(S_CONCEPT);
        aClass.applyStereotype(conceptStereotype);
        transaction.commit();
        session.close();
        session = this.openSession();
        transaction = session.openTransaction();
        res = transaction.getResource(this.getResourcePath("/model1.uml"), true);
        DynamicProfileTest.assertEquals((boolean)true, (boolean)res.isLoaded());
        DynamicProfileTest.assertEquals((int)2, (int)res.getContents().size());
        umlModel = (Model)res.getContents().get(0);
        aClass = (Class)EcoreUtil.getObjectByType((Collection)umlModel.getOwnedTypes(), (EClassifier)UMLPackage.Literals.CLASS);
        DynamicProfileTest.assertNotNull((Object)aClass);
        DynamicProfileTest.assertEquals((String)"Stereotype doesn't appear to be applied.", (boolean)true, (boolean)aClass.isStereotypeApplied(conceptStereotype));
        DynamicProfileTest.assertEquals((String)"Wrong stereotype EClass.", (Object)transaction.getResourceSet().getPackageRegistry().getEPackage(MY_PROFILE_URI).getEClassifier(S_CONCEPT), (Object)aClass.getStereotypeApplication(conceptStereotype).eClass());
    }

    public void testInstancesOfLocalDynamicUMLProfile() throws Exception {
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage((EPackage)UMLPackage.eINSTANCE);
        ResourceSetImpl rset = new ResourceSetImpl();
        CDOTransaction transaction = session.openTransaction((ResourceSet)rset);
        CDOResource res = transaction.createResource(this.getResourcePath("/model1.uml"));
        Model umlModel = UMLFactory.eINSTANCE.createModel();
        res.getContents().add((Object)umlModel);
        umlModel.setName("model");
        Class aClass = umlModel.createOwnedClass("Fruit", true);
        CDOResource profileRes = transaction.createResource(this.getResourcePath("/profile1.profile.uml"));
        Profile profile = UMLFactory.eINSTANCE.createProfile();
        profileRes.getContents().add((Object)profile);
        profile.setName("MyProfile");
        Stereotype conceptStereotype = profile.createOwnedStereotype(S_CONCEPT, false);
        Model uml = (Model)UML2Util.load((ResourceSet)rset, (URI)URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), (EClass)UMLPackage.Literals.MODEL);
        profile.createMetamodelReference((Package)uml);
        conceptStereotype.createExtension((Class)uml.getOwnedType("Classifier"), false);
        EPackage definition = profile.define();
        CDOUtil.prepareDynamicEPackage((EPackage)definition);
        umlModel.applyProfile(profile);
        aClass.applyStereotype(conceptStereotype);
        DynamicProfileTest.assertEquals((String)"Stereotype not applied.", (boolean)true, (boolean)aClass.isStereotypeApplied(conceptStereotype));
        transaction.commit();
        session.close();
        session = this.openSession();
        transaction = session.openTransaction();
        res = transaction.getResource(this.getResourcePath("/model1.uml"), true);
        DynamicProfileTest.assertEquals((boolean)true, (boolean)res.isLoaded());
        DynamicProfileTest.assertEquals((int)2, (int)res.getContents().size());
        umlModel = (Model)res.getContents().get(0);
        aClass = (Class)EcoreUtil.getObjectByType((Collection)umlModel.getOwnedTypes(), (EClassifier)UMLPackage.Literals.CLASS);
        DynamicProfileTest.assertNotNull((Object)aClass);
        EObject stereotypeApplication = (EObject)res.getContents().get(1);
        DynamicProfileTest.assertSame((String)"Wrong base element reference.", (Object)aClass, (Object)stereotypeApplication.eGet(stereotypeApplication.eClass().getEStructuralFeature("base_Classifier")));
    }

    protected void doTearDown() throws Exception {
        this.stuffPackage.setEFactoryInstance(this.originalStuffFactory);
        super.doTearDown();
    }
}

