/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.mongodb.Commits;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStore;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;

public class Classes {
    public static final String PROPERTIES = "props";
    private Map<EClassifier, Integer> classifierToIDs = new HashMap<EClassifier, Integer>();
    private Map<Integer, EClassifier> idToClassifiers = new HashMap<Integer, EClassifier>();
    private MongoDBStore store;
    private boolean initialized;
    private int lastClassifierID;
    private int resourceNodeClassID;
    private int resourceFolderClassID;
    private int resourceClassID;

    public Classes(MongoDBStore store) {
        this.store = store;
    }

    public MongoDBStore getStore() {
        return this.store;
    }

    public int getLastClassifierID() {
        return this.lastClassifierID;
    }

    public void setLastClassifierID(int lastClassifierID) {
        this.lastClassifierID = lastClassifierID;
    }

    public synchronized int getResourceNodeClassID() {
        this.initialize();
        return this.resourceNodeClassID;
    }

    public synchronized int getResourceFolderClassID() {
        this.initialize();
        return this.resourceFolderClassID;
    }

    public synchronized int getResourceClassID() {
        this.initialize();
        return this.resourceClassID;
    }

    public synchronized int mapNewClassifier(EClassifier classifier) {
        int id = ++this.lastClassifierID;
        this.mapClassifier(classifier, id);
        return id;
    }

    public synchronized void mapClassifier(EClassifier classifier, int id) {
        this.classifierToIDs.put(classifier, id);
        this.idToClassifiers.put(id, classifier);
        if (classifier == EresourcePackage.eINSTANCE.getCDOResourceNode()) {
            this.resourceNodeClassID = id;
        } else if (classifier == EresourcePackage.eINSTANCE.getCDOResourceFolder()) {
            this.resourceFolderClassID = id;
        } else if (classifier == EresourcePackage.eINSTANCE.getCDOResource()) {
            this.resourceClassID = id;
        }
    }

    public synchronized int getClassifierID(EClassifier classifier) {
        this.initialize();
        return this.classifierToIDs.get(classifier);
    }

    public synchronized EClassifier getClassifier(int id) {
        this.initialize();
        return this.idToClassifiers.get(id);
    }

    public synchronized EClass getClass(int id) {
        return (EClass)this.getClassifier(id);
    }

    private void initialize() {
        if (!this.initialized) {
            Commits commits = this.store.getCommits();
            commits.initializeClassifiers();
            this.initialized = true;
        }
    }
}

